/*
 * Decompiled with CFR 0.152.
 */
package unluac;

import java.io.FileOutputStream;
import java.io.IOException;
import unluac.Main;
import unluac.decompile.FileOutputProvider;
import unluac.decompile.Output;

public class Configuration {
    public boolean rawstring;
    public Mode mode;
    public VariableMode variable;
    public boolean strict_scope;
    public String opmap;
    public String output;

    public Configuration() {
        this.rawstring = false;
        this.mode = Mode.DECOMPILE;
        this.variable = VariableMode.DEFAULT;
        this.strict_scope = false;
        this.opmap = null;
        this.output = null;
    }

    public Configuration(Configuration other) {
        this.rawstring = other.rawstring;
        this.mode = other.mode;
        this.variable = other.variable;
        this.strict_scope = other.strict_scope;
        this.opmap = other.opmap;
        this.output = other.output;
    }

    public Output getOutput() {
        if (this.output != null) {
            try {
                return new Output(new FileOutputProvider(new FileOutputStream(this.output)));
            }
            catch (IOException e) {
                Main.error(e.getMessage(), false);
                return null;
            }
        }
        return new Output();
    }

    public static enum Mode {
        DECOMPILE,
        DISASSEMBLE,
        ASSEMBLE;

    }

    public static enum VariableMode {
        NODEBUG,
        DEFAULT,
        FINDER;

    }
}

