/*
 * Decompiled with CFR 0.152.
 */
package unluac;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import unluac.Configuration;
import unluac.assemble.Assembler;
import unluac.assemble.AssemblerException;
import unluac.decompile.Decompiler;
import unluac.decompile.Disassembler;
import unluac.decompile.Output;
import unluac.decompile.OutputProvider;
import unluac.parse.BHeader;
import unluac.parse.LFunction;
import unluac.util.FileUtils;

public class Main {
    public static String version = "1.2.3.490-string5-ext";

    public static void main(String[] args) {
        String fn = null;
        Configuration config = new Configuration();
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                if (arg.equals("--rawstring")) {
                    config.rawstring = true;
                } else if (arg.equals("--nodebug")) {
                    config.variable = Configuration.VariableMode.NODEBUG;
                } else if (arg.equals("--disassemble")) {
                    config.mode = Configuration.Mode.DISASSEMBLE;
                } else if (arg.equals("--assemble")) {
                    config.mode = Configuration.Mode.ASSEMBLE;
                } else if (arg.equals("--output") || arg.equals("-o")) {
                    if (i + 1 < args.length) {
                        config.output = args[i + 1];
                        ++i;
                    } else {
                        Main.error("option \"" + arg + "\" doesn't have an argument", true);
                    }
                } else if (arg.equals("--opmap")) {
                    if (i + 1 < args.length) {
                        config.opmap = args[i + 1];
                        ++i;
                    } else {
                        Main.error("option \"" + arg + "\" doesn't have an argument", true);
                    }
                } else {
                    Main.error("unrecognized option: " + arg, true);
                }
            } else if (fn == null) {
                fn = arg;
            } else {
                Main.error("too many arguments: " + arg, true);
            }
            ++i;
        }
        if (fn == null) {
            Main.error("no input file provided", true);
        } else {
            switch (config.mode) {
                case DECOMPILE: {
                    LFunction lmain = null;
                    try {
                        lmain = Main.file_to_function(fn, config);
                    }
                    catch (IOException e) {
                        Main.error(e.getMessage(), false);
                    }
                    Object d = new Decompiler(lmain);
                    Decompiler.State result = ((Decompiler)d).decompile();
                    ((Decompiler)d).print(result, config.getOutput());
                    break;
                }
                case DISASSEMBLE: {
                    LFunction lmain = null;
                    try {
                        lmain = Main.file_to_function(fn, config);
                    }
                    catch (IOException e) {
                        Main.error(e.getMessage(), false);
                    }
                    Object d = new Disassembler(lmain);
                    ((Disassembler)d).disassemble(config.getOutput());
                    break;
                }
                case ASSEMBLE: {
                    if (config.output == null) {
                        Main.error("assembler mode requires an output file", true);
                        break;
                    }
                    try {
                        Assembler a = new Assembler(FileUtils.createSmartTextFileReader(new File(fn)), new FileOutputStream(config.output));
                        a.assemble();
                    }
                    catch (IOException e) {
                        Main.error(e.getMessage(), false);
                    }
                    catch (AssemblerException e) {
                        Main.error(e.getMessage(), false);
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            System.exit(0);
        }
    }

    public static void error(String err, boolean usage) {
        System.err.println("unluac v" + version);
        System.err.print("  error: ");
        System.err.println(err);
        if (usage) {
            System.err.println("  usage: java -jar unluac.jar [options] <file>");
        }
        System.exit(1);
    }

    private static LFunction file_to_function(String fn, Configuration config) throws IOException {
        try (RandomAccessFile file = null;){
            file = new RandomAccessFile(fn, "r");
            ByteBuffer buffer = ByteBuffer.allocate((int)file.length());
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int len = (int)file.length();
            FileChannel in = file.getChannel();
            while (len > 0) {
                len -= in.read(buffer);
            }
            buffer.rewind();
            BHeader header = new BHeader(buffer, config);
            LFunction lFunction = header.main;
            return lFunction;
        }
    }

    public static void decompile(String in, String out, Configuration config) throws IOException {
        LFunction lmain = Main.file_to_function(in, config);
        Decompiler d = new Decompiler(lmain);
        Decompiler.State result = d.decompile();
        final PrintStream pout = new PrintStream(out);
        d.print(result, new Output(new OutputProvider(){

            @Override
            public void print(String s) {
                pout.print(s);
            }

            @Override
            public void print(byte b) {
                pout.write(b);
            }

            @Override
            public void println() {
                pout.println();
            }
        }));
        pout.flush();
        pout.close();
    }

    public static void assemble(String in, String out) throws IOException, AssemblerException {
        BufferedOutputStream outstream = new BufferedOutputStream(new FileOutputStream(new File(out)));
        Assembler a = new Assembler(FileUtils.createSmartTextFileReader(new File(in)), outstream);
        a.assemble();
        ((OutputStream)outstream).flush();
        ((OutputStream)outstream).close();
    }

    public static void disassemble(String in, String out) throws IOException {
        LFunction lmain = Main.file_to_function(in, new Configuration());
        Disassembler d = new Disassembler(lmain);
        final PrintStream pout = new PrintStream(out);
        d.disassemble(new Output(new OutputProvider(){

            @Override
            public void print(String s) {
                pout.print(s);
            }

            @Override
            public void print(byte b) {
                pout.print(b);
            }

            @Override
            public void println() {
                pout.println();
            }
        }));
        pout.flush();
        pout.close();
    }
}

