/*
 * Decompiled with CFR 0.152.
 */
package unluac;

import java.util.HashSet;
import java.util.Set;
import unluac.decompile.Op;
import unluac.decompile.OpcodeMap;
import unluac.parse.LConstantType;
import unluac.parse.LFunctionType;
import unluac.parse.LHeaderType;
import unluac.parse.LStringType;
import unluac.parse.LUpvalueType;

public class Version {
    public final Setting<VarArgType> varargtype;
    public final Setting<Boolean> useupvaluecountinheader;
    public final Setting<InstructionFormat> instructionformat;
    public final Setting<Integer> outerblockscopeadjustment;
    public final Setting<Boolean> extendedrepeatscope;
    public final Setting<Boolean> closeinscope;
    public final Setting<CloseSemantics> closesemantics;
    public final Setting<UpvalueDeclarationType> upvaluedeclarationtype;
    public final Setting<Op> fortarget;
    public final Setting<Op> tfortarget;
    public final Setting<WhileFormat> whileformat;
    public final Setting<Boolean> allowpreceedingsemicolon;
    public final Setting<Boolean> usenestinglongstrings;
    public final Setting<String> environmenttable;
    public final Setting<Boolean> useifbreakrewrite;
    public final Setting<Boolean> usegoto;
    public final Setting<Integer> rkoffset;
    private final int major;
    private final int minor;
    private final String name;
    private final Set<String> reservedWords;
    private final LHeaderType lheadertype;
    private final LStringType lstringtype;
    private final LConstantType lconstanttype;
    private final LUpvalueType lupvaluetype;
    private final LFunctionType lfunctiontype;
    private final OpcodeMap opcodemap;
    private final Op defaultop;

    public static Version getVersion(int major, int minor) {
        return new Version(major, minor);
    }

    private Version(int major, int minor) {
        OpcodeMapType opcodemap;
        FunctionType functiontype;
        UpvalueType upvaluetype;
        ConstantType constanttype;
        StringType stringtype;
        HeaderType headertype;
        block9: {
            block8: {
                this.major = major;
                this.minor = minor;
                this.name = String.valueOf(major) + "." + minor;
                if (major != 5 || minor < 0 || minor > 4) break block8;
                switch (minor) {
                    case 0: {
                        this.varargtype = new Setting<VarArgType>(VarArgType.ARG);
                        this.useupvaluecountinheader = new Setting<Boolean>(false);
                        headertype = HeaderType.LUA50;
                        stringtype = StringType.LUA50;
                        constanttype = ConstantType.LUA50;
                        upvaluetype = UpvalueType.LUA50;
                        functiontype = FunctionType.LUA50;
                        opcodemap = OpcodeMapType.LUA50;
                        this.defaultop = Op.DEFAULT;
                        this.instructionformat = new Setting<InstructionFormat>(InstructionFormat.LUA50);
                        this.outerblockscopeadjustment = new Setting<Integer>(-1);
                        this.extendedrepeatscope = new Setting<Boolean>(true);
                        this.closeinscope = new Setting<Boolean>(true);
                        this.closesemantics = new Setting<CloseSemantics>(CloseSemantics.DEFAULT);
                        this.upvaluedeclarationtype = new Setting<UpvalueDeclarationType>(UpvalueDeclarationType.INLINE);
                        this.fortarget = new Setting<Op>(Op.FORLOOP);
                        this.tfortarget = new Setting<Object>(null);
                        this.whileformat = new Setting<WhileFormat>(WhileFormat.BOTTOM_CONDITION);
                        this.allowpreceedingsemicolon = new Setting<Boolean>(false);
                        this.usenestinglongstrings = new Setting<Boolean>(true);
                        this.environmenttable = new Setting<Object>(null);
                        this.useifbreakrewrite = new Setting<Boolean>(false);
                        this.usegoto = new Setting<Boolean>(false);
                        this.rkoffset = new Setting<Integer>(250);
                        break block9;
                    }
                    case 1: {
                        this.varargtype = new Setting<VarArgType>(VarArgType.HYBRID);
                        this.useupvaluecountinheader = new Setting<Boolean>(false);
                        headertype = HeaderType.LUA51;
                        stringtype = StringType.LUA50;
                        constanttype = ConstantType.LUA50;
                        upvaluetype = UpvalueType.LUA50;
                        functiontype = FunctionType.LUA51;
                        opcodemap = OpcodeMapType.LUA51;
                        this.defaultop = Op.DEFAULT;
                        this.instructionformat = new Setting<InstructionFormat>(InstructionFormat.LUA51);
                        this.outerblockscopeadjustment = new Setting<Integer>(-1);
                        this.extendedrepeatscope = new Setting<Boolean>(false);
                        this.closeinscope = new Setting<Boolean>(true);
                        this.closesemantics = new Setting<CloseSemantics>(CloseSemantics.DEFAULT);
                        this.upvaluedeclarationtype = new Setting<UpvalueDeclarationType>(UpvalueDeclarationType.INLINE);
                        this.fortarget = new Setting<Object>(null);
                        this.tfortarget = new Setting<Op>(Op.TFORLOOP);
                        this.whileformat = new Setting<WhileFormat>(WhileFormat.TOP_CONDITION);
                        this.allowpreceedingsemicolon = new Setting<Boolean>(false);
                        this.usenestinglongstrings = new Setting<Boolean>(false);
                        this.environmenttable = new Setting<Object>(null);
                        this.useifbreakrewrite = new Setting<Boolean>(false);
                        this.usegoto = new Setting<Boolean>(false);
                        this.rkoffset = new Setting<Integer>(256);
                        break block9;
                    }
                    case 2: {
                        this.varargtype = new Setting<VarArgType>(VarArgType.ELLIPSIS);
                        this.useupvaluecountinheader = new Setting<Boolean>(false);
                        headertype = HeaderType.LUA52;
                        stringtype = StringType.LUA50;
                        constanttype = ConstantType.LUA50;
                        upvaluetype = UpvalueType.LUA50;
                        functiontype = FunctionType.LUA52;
                        opcodemap = OpcodeMapType.LUA52;
                        this.defaultop = Op.DEFAULT;
                        this.instructionformat = new Setting<InstructionFormat>(InstructionFormat.LUA51);
                        this.outerblockscopeadjustment = new Setting<Integer>(0);
                        this.extendedrepeatscope = new Setting<Boolean>(false);
                        this.closeinscope = new Setting<Object>(null);
                        this.closesemantics = new Setting<CloseSemantics>(CloseSemantics.JUMP);
                        this.upvaluedeclarationtype = new Setting<UpvalueDeclarationType>(UpvalueDeclarationType.HEADER);
                        this.fortarget = new Setting<Object>(null);
                        this.tfortarget = new Setting<Op>(Op.TFORCALL);
                        this.whileformat = new Setting<WhileFormat>(WhileFormat.TOP_CONDITION);
                        this.allowpreceedingsemicolon = new Setting<Boolean>(true);
                        this.usenestinglongstrings = new Setting<Boolean>(false);
                        this.environmenttable = new Setting<String>("_ENV");
                        this.useifbreakrewrite = new Setting<Boolean>(true);
                        this.usegoto = new Setting<Boolean>(true);
                        this.rkoffset = new Setting<Integer>(256);
                        break block9;
                    }
                    case 3: {
                        this.varargtype = new Setting<VarArgType>(VarArgType.ELLIPSIS);
                        this.useupvaluecountinheader = new Setting<Boolean>(true);
                        headertype = HeaderType.LUA53;
                        stringtype = StringType.LUA53;
                        constanttype = ConstantType.LUA53;
                        upvaluetype = UpvalueType.LUA50;
                        functiontype = FunctionType.LUA53;
                        opcodemap = OpcodeMapType.LUA53;
                        this.defaultop = Op.DEFAULT;
                        this.instructionformat = new Setting<InstructionFormat>(InstructionFormat.LUA51);
                        this.outerblockscopeadjustment = new Setting<Integer>(0);
                        this.extendedrepeatscope = new Setting<Boolean>(false);
                        this.closeinscope = new Setting<Object>(null);
                        this.closesemantics = new Setting<CloseSemantics>(CloseSemantics.JUMP);
                        this.upvaluedeclarationtype = new Setting<UpvalueDeclarationType>(UpvalueDeclarationType.HEADER);
                        this.fortarget = new Setting<Object>(null);
                        this.tfortarget = new Setting<Op>(Op.TFORCALL);
                        this.whileformat = new Setting<WhileFormat>(WhileFormat.TOP_CONDITION);
                        this.allowpreceedingsemicolon = new Setting<Boolean>(true);
                        this.usenestinglongstrings = new Setting<Boolean>(false);
                        this.environmenttable = new Setting<String>("_ENV");
                        this.useifbreakrewrite = new Setting<Boolean>(true);
                        this.usegoto = new Setting<Boolean>(true);
                        this.rkoffset = new Setting<Integer>(256);
                        break block9;
                    }
                    case 4: {
                        this.varargtype = new Setting<VarArgType>(VarArgType.ELLIPSIS);
                        this.useupvaluecountinheader = new Setting<Boolean>(true);
                        headertype = HeaderType.LUA54;
                        stringtype = StringType.LUA54;
                        constanttype = ConstantType.LUA54;
                        upvaluetype = UpvalueType.LUA54;
                        functiontype = FunctionType.LUA54;
                        opcodemap = OpcodeMapType.LUA54;
                        this.defaultop = Op.DEFAULT54;
                        this.instructionformat = new Setting<InstructionFormat>(InstructionFormat.LUA54);
                        this.outerblockscopeadjustment = new Setting<Integer>(0);
                        this.extendedrepeatscope = new Setting<Boolean>(false);
                        this.closeinscope = new Setting<Boolean>(false);
                        this.closesemantics = new Setting<CloseSemantics>(CloseSemantics.LUA54);
                        this.upvaluedeclarationtype = new Setting<UpvalueDeclarationType>(UpvalueDeclarationType.HEADER);
                        this.fortarget = new Setting<Object>(null);
                        this.tfortarget = new Setting<Object>(null);
                        this.whileformat = new Setting<WhileFormat>(WhileFormat.TOP_CONDITION);
                        this.allowpreceedingsemicolon = new Setting<Boolean>(true);
                        this.usenestinglongstrings = new Setting<Boolean>(false);
                        this.environmenttable = new Setting<String>("_ENV");
                        this.useifbreakrewrite = new Setting<Boolean>(true);
                        this.usegoto = new Setting<Boolean>(true);
                        this.rkoffset = new Setting<Object>(null);
                        break block9;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            throw new IllegalStateException();
        }
        this.reservedWords = new HashSet<String>();
        this.reservedWords.add("and");
        this.reservedWords.add("break");
        this.reservedWords.add("do");
        this.reservedWords.add("else");
        this.reservedWords.add("elseif");
        this.reservedWords.add("end");
        this.reservedWords.add("false");
        this.reservedWords.add("for");
        this.reservedWords.add("function");
        this.reservedWords.add("if");
        this.reservedWords.add("in");
        this.reservedWords.add("local");
        this.reservedWords.add("nil");
        this.reservedWords.add("not");
        this.reservedWords.add("or");
        this.reservedWords.add("repeat");
        this.reservedWords.add("return");
        this.reservedWords.add("then");
        this.reservedWords.add("true");
        this.reservedWords.add("until");
        this.reservedWords.add("while");
        if (this.usegoto.get().booleanValue()) {
            this.reservedWords.add("goto");
        }
        this.lheadertype = LHeaderType.get(headertype);
        this.lstringtype = LStringType.get(stringtype);
        this.lconstanttype = LConstantType.get(constanttype);
        this.lupvaluetype = LUpvalueType.get(upvaluetype);
        this.lfunctiontype = LFunctionType.get(functiontype);
        this.opcodemap = new OpcodeMap(opcodemap);
    }

    public int getVersionMajor() {
        return this.major;
    }

    public int getVersionMinor() {
        return this.minor;
    }

    public String getName() {
        return this.name;
    }

    public boolean isEnvironmentTable(String name) {
        String env = this.environmenttable.get();
        if (env != null) {
            return name.equals(env);
        }
        return false;
    }

    public boolean isReserved(String name) {
        return this.reservedWords.contains(name);
    }

    public LHeaderType getLHeaderType() {
        return this.lheadertype;
    }

    public LStringType getLStringType() {
        return this.lstringtype;
    }

    public LConstantType getLConstantType() {
        return this.lconstanttype;
    }

    public LUpvalueType getLUpvalueType() {
        return this.lupvaluetype;
    }

    public LFunctionType getLFunctionType() {
        return this.lfunctiontype;
    }

    public OpcodeMap getOpcodeMap() {
        return this.opcodemap;
    }

    public Op getDefaultOp() {
        return this.defaultop;
    }

    public static enum CloseSemantics {
        DEFAULT,
        JUMP,
        LUA54;

    }

    public static enum ConstantType {
        LUA50,
        LUA53,
        LUA54;

    }

    public static enum FunctionType {
        LUA50,
        LUA51,
        LUA52,
        LUA53,
        LUA54;

    }

    public static enum HeaderType {
        LUA50,
        LUA51,
        LUA52,
        LUA53,
        LUA54;

    }

    public static enum InstructionFormat {
        LUA50,
        LUA51,
        LUA54;

    }

    public static enum OpcodeMapType {
        LUA50,
        LUA51,
        LUA52,
        LUA53,
        LUA54;

    }

    public static class Setting<T> {
        private final T value;

        public Setting(T value) {
            this.value = value;
        }

        public T get() {
            return this.value;
        }
    }

    public static enum StringType {
        LUA50,
        LUA53,
        LUA54;

    }

    public static enum UpvalueDeclarationType {
        INLINE,
        HEADER;

    }

    public static enum UpvalueType {
        LUA50,
        LUA54;

    }

    public static enum VarArgType {
        ARG,
        HYBRID,
        ELLIPSIS;

    }

    public static enum WhileFormat {
        TOP_CONDITION,
        BOTTOM_CONDITION;

    }
}

