/*
 * Decompiled with CFR 0.152.
 */
package unluac.assemble;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import unluac.Version;
import unluac.assemble.AssemblerChunk;
import unluac.assemble.AssemblerException;
import unluac.assemble.Directive;
import unluac.assemble.Tokenizer;
import unluac.decompile.Op;
import unluac.decompile.OpcodeMap;
import unluac.util.StringUtils;

public class Assembler {
    private Tokenizer t;
    private OutputStream out;
    private Version version;

    public Assembler(InputStream in, OutputStream out) {
        this.t = new Tokenizer(in);
        this.out = out;
    }

    public void assemble() throws AssemblerException, IOException {
        int minor;
        int major;
        String tok = this.t.next();
        if (!tok.equals(".version")) {
            throw new AssemblerException("First directive must be .version, instead was \"" + tok + "\"");
        }
        tok = this.t.next();
        String[] parts = tok.split("\\.");
        if (parts.length == 2) {
            try {
                major = Integer.valueOf(parts[0]);
                minor = Integer.valueOf(parts[1]);
            }
            catch (NumberFormatException e) {
                throw new AssemblerException("Unsupported version " + tok);
            }
        } else {
            throw new AssemblerException("Unsupported version " + tok);
        }
        if (major < 0 || major > 15 || minor < 0 || minor > 15) {
            throw new AssemblerException("Unsupported version " + tok);
        }
        this.version = Version.getVersion(major, minor);
        if (this.version == null) {
            throw new AssemblerException("Unsupported version " + tok);
        }
        HashMap<String, Op> oplookup = null;
        HashMap<Op, Integer> opcodelookup = null;
        AssemblerChunk chunk = new AssemblerChunk(this.version);
        boolean opinit = false;
        block7: while ((tok = this.t.next()) != null) {
            Directive d = Directive.lookup.get(tok);
            if (d != null) {
                switch (d.type) {
                    case HEADER: {
                        chunk.processHeaderDirective(this, d);
                        continue block7;
                    }
                    case NEWFUNCTION: {
                        if (!opinit) {
                            opinit = true;
                            OpcodeMap opmap = chunk.useropmap != null ? new OpcodeMap(chunk.useropmap) : this.version.getOpcodeMap();
                            oplookup = new HashMap<String, Op>();
                            opcodelookup = new HashMap<Op, Integer>();
                            int i = 0;
                            while (i < opmap.size()) {
                                Op op = opmap.get(i);
                                if (op != null) {
                                    oplookup.put(op.name, op);
                                    opcodelookup.put(op, i);
                                }
                                ++i;
                            }
                            oplookup.put(Op.EXTRABYTE.name, Op.EXTRABYTE);
                            opcodelookup.put(Op.EXTRABYTE, -1);
                        }
                        chunk.processNewFunction(this);
                        continue block7;
                    }
                    case FUNCTION: {
                        chunk.processFunctionDirective(this, d);
                        continue block7;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            Op op = (Op)((Object)oplookup.get(tok));
            if (op != null) {
                chunk.processOp(this, op, (Integer)opcodelookup.get((Object)op));
                continue;
            }
            throw new AssemblerException("Unexpected token \"" + tok + "\"");
        }
        chunk.fixup();
        chunk.write(this.out);
    }

    String getAny() throws AssemblerException, IOException {
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        return s;
    }

    String getName() throws AssemblerException, IOException {
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        return s;
    }

    String getString() throws AssemblerException, IOException {
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        return StringUtils.fromPrintString(s);
    }

    int getInteger() throws AssemblerException, IOException {
        int i;
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        try {
            i = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            throw new AssemblerException("Excepted number, got \"" + s + "\"");
        }
        return i;
    }

    boolean getBoolean() throws AssemblerException, IOException {
        boolean b;
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        if (s.equals("true")) {
            b = true;
        } else if (s.equals("false")) {
            b = false;
        } else {
            throw new AssemblerException("Expected boolean, got \"" + s + "\"");
        }
        return b;
    }

    int getRegister() throws AssemblerException, IOException {
        int r;
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        if (s.length() >= 2 && s.charAt(0) == 'r') {
            try {
                r = Integer.parseInt(s.substring(1));
            }
            catch (NumberFormatException e) {
                throw new AssemblerException("Excepted register, got \"" + s + "\"");
            }
        } else {
            throw new AssemblerException("Excepted register, got \"" + s + "\"");
        }
        return r;
    }

    RKInfo getRegisterK54() throws AssemblerException, IOException {
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        RKInfo rk = new RKInfo();
        if (s.length() >= 2 && s.charAt(0) == 'r') {
            rk.constant = false;
            try {
                rk.x = Integer.parseInt(s.substring(1));
            }
            catch (NumberFormatException e) {
                throw new AssemblerException("Excepted register, got \"" + s + "\"");
            }
        } else if (s.length() >= 2 && s.charAt(0) == 'k') {
            rk.constant = true;
            try {
                rk.x = Integer.parseInt(s.substring(1));
            }
            catch (NumberFormatException e) {
                throw new AssemblerException("Excepted constant, got \"" + s + "\"");
            }
        } else {
            throw new AssemblerException("Excepted register or constant, got \"" + s + "\"");
        }
        return rk;
    }

    int getConstant() throws AssemblerException, IOException {
        int k;
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexpected end of file");
        }
        if (s.length() >= 2 && s.charAt(0) == 'k') {
            try {
                k = Integer.parseInt(s.substring(1));
            }
            catch (NumberFormatException e) {
                throw new AssemblerException("Excepted constant, got \"" + s + "\"");
            }
        } else {
            throw new AssemblerException("Excepted constant, got \"" + s + "\"");
        }
        return k;
    }

    int getUpvalue() throws AssemblerException, IOException {
        int u;
        String s = this.t.next();
        if (s == null) {
            throw new AssemblerException("Unexcepted end of file");
        }
        if (s.length() >= 2 && s.charAt(0) == 'u') {
            try {
                u = Integer.parseInt(s.substring(1));
            }
            catch (NumberFormatException e) {
                throw new AssemblerException("Excepted register, got \"" + s + "\"");
            }
        } else {
            throw new AssemblerException("Excepted register, got \"" + s + "\"");
        }
        return u;
    }

    static class RKInfo {
        int x;
        boolean constant;

        RKInfo() {
        }
    }
}

