/*
 * Decompiled with CFR 0.152.
 */
package unluac.assemble;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import unluac.Version;
import unluac.assemble.Assembler;
import unluac.assemble.AssemblerAbsLineInfo;
import unluac.assemble.AssemblerConstant;
import unluac.assemble.AssemblerException;
import unluac.assemble.AssemblerFunction;
import unluac.assemble.AssemblerLocal;
import unluac.assemble.AssemblerUpvalue;
import unluac.assemble.Directive;
import unluac.decompile.CodeExtract;
import unluac.decompile.Op;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BIntegerType;
import unluac.parse.LAbsLineInfo;
import unluac.parse.LAbsLineInfoType;
import unluac.parse.LBoolean;
import unluac.parse.LBooleanType;
import unluac.parse.LConstantType;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LHeader;
import unluac.parse.LLocal;
import unluac.parse.LLocalType;
import unluac.parse.LNil;
import unluac.parse.LNumberType;
import unluac.parse.LObject;
import unluac.parse.LString;
import unluac.parse.LStringType;
import unluac.parse.LUpvalue;
import unluac.parse.LUpvalueType;

class AssemblerChunk {
    public Version version;
    public int format;
    public LHeader.LEndianness endianness;
    public int int_size;
    public BIntegerType integer;
    public int size_t_size;
    public BIntegerType sizeT;
    public int instruction_size;
    public int op_size;
    public int a_size;
    public int b_size;
    public int c_size;
    public Map<Integer, Op> useropmap;
    public boolean number_integral;
    public int number_size;
    public LNumberType number;
    public LNumberType linteger;
    public LNumberType lfloat;
    public AssemblerFunction main;
    public AssemblerFunction current;
    public CodeExtract extract;
    public final Set<Directive> processed_directives;

    public AssemblerChunk(Version version) {
        this.version = version;
        this.processed_directives = new HashSet<Directive>();
        this.main = null;
        this.current = null;
        this.extract = null;
    }

    public void processHeaderDirective(Assembler a, Directive d) throws AssemblerException, IOException {
        if (d != Directive.OP && this.processed_directives.contains((Object)d)) {
            throw new AssemblerException("Duplicate " + d.name() + " directive");
        }
        this.processed_directives.add(d);
        block0 : switch (d) {
            case FORMAT: {
                this.format = a.getInteger();
                break;
            }
            case ENDIANNESS: {
                String endiannessName;
                switch (endiannessName = a.getName()) {
                    case "LITTLE": {
                        this.endianness = LHeader.LEndianness.LITTLE;
                        break block0;
                    }
                    case "BIG": {
                        this.endianness = LHeader.LEndianness.BIG;
                        break block0;
                    }
                }
                throw new AssemblerException("Unknown endianness \"" + endiannessName + "\"");
            }
            case INT_SIZE: {
                this.int_size = a.getInteger();
                this.integer = BIntegerType.create50Type(this.int_size);
                break;
            }
            case SIZE_T_SIZE: {
                this.size_t_size = a.getInteger();
                this.sizeT = BIntegerType.create50Type(this.size_t_size);
                break;
            }
            case INSTRUCTION_SIZE: {
                this.instruction_size = a.getInteger();
                break;
            }
            case SIZE_OP: {
                this.op_size = a.getInteger();
                break;
            }
            case SIZE_A: {
                this.a_size = a.getInteger();
                break;
            }
            case SIZE_B: {
                this.b_size = a.getInteger();
                break;
            }
            case SIZE_C: {
                this.c_size = a.getInteger();
                break;
            }
            case NUMBER_FORMAT: {
                String numberTypeName;
                switch (numberTypeName = a.getName()) {
                    case "integer": {
                        this.number_integral = true;
                        break;
                    }
                    case "float": {
                        this.number_integral = false;
                        break;
                    }
                    default: {
                        throw new AssemblerException("Unknown number_format \"" + numberTypeName + "\"");
                    }
                }
                this.number_size = a.getInteger();
                this.number = new LNumberType(this.number_size, this.number_integral, LNumberType.NumberMode.MODE_NUMBER);
                break;
            }
            case INTEGER_FORMAT: {
                this.linteger = new LNumberType(a.getInteger(), true, LNumberType.NumberMode.MODE_INTEGER);
                break;
            }
            case FLOAT_FORMAT: {
                this.lfloat = new LNumberType(a.getInteger(), false, LNumberType.NumberMode.MODE_FLOAT);
                break;
            }
            case OP: {
                if (this.useropmap == null) {
                    this.useropmap = new HashMap<Integer, Op>();
                }
                int opcode = a.getInteger();
                String name = a.getName();
                Op op = this.version.getOpcodeMap().get(name);
                if (op == null) {
                    throw new AssemblerException("Unknown op name \"" + name + "\"");
                }
                this.useropmap.put(opcode, op);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled directive: " + (Object)((Object)d));
            }
        }
    }

    public CodeExtract getCodeExtract() throws AssemblerException {
        if (this.extract == null) {
            this.extract = new CodeExtract(this.version, this.op_size, this.a_size, this.b_size, this.c_size);
        }
        return this.extract;
    }

    public void processNewFunction(Assembler a) throws AssemblerException, IOException {
        String name = a.getName();
        String[] parts = name.split("/");
        if (this.main == null) {
            if (parts.length != 1) {
                throw new AssemblerException("First (main) function declaration must not have a \"/\" in the name");
            }
            this.current = this.main = new AssemblerFunction(this, null, name);
        } else {
            if (parts.length == 1 || !parts[0].equals(this.main.name)) {
                throw new AssemblerException("Function \"" + name + "\" isn't contained in the main function");
            }
            AssemblerFunction parent = this.main.getInnerParent(parts, 1);
            this.current = parent.addChild(parts[parts.length - 1]);
        }
    }

    public void processFunctionDirective(Assembler a, Directive d) throws AssemblerException, IOException {
        if (this.current == null) {
            throw new AssemblerException("Misplaced function directive before declaration of any function");
        }
        this.current.processFunctionDirective(a, d);
    }

    public void processOp(Assembler a, Op op, int opcode) throws AssemblerException, IOException {
        if (this.current == null) {
            throw new AssemblerException("Misplaced code before declaration of any function");
        }
        this.current.processOp(a, this.getCodeExtract(), op, opcode);
    }

    public void fixup() throws AssemblerException {
        this.main.fixup(this.getCodeExtract());
    }

    public void write(OutputStream out) throws AssemblerException, IOException {
        LBooleanType bool = new LBooleanType();
        LStringType string = this.version.getLStringType();
        LConstantType constant = this.version.getLConstantType();
        LAbsLineInfoType abslineinfo = new LAbsLineInfoType();
        LLocalType local = new LLocalType();
        LUpvalueType upvalue = this.version.getLUpvalueType();
        LFunctionType function = this.version.getLFunctionType();
        CodeExtract extract = this.getCodeExtract();
        if (this.integer == null) {
            this.sizeT = this.integer = BIntegerType.create54();
        }
        LHeader lheader = new LHeader(this.format, this.endianness, this.integer, this.sizeT, bool, this.number, this.linteger, this.lfloat, string, constant, abslineinfo, local, upvalue, function, extract);
        BHeader header = new BHeader(this.version, lheader);
        LFunction main = this.convert_function(header, this.main);
        header = new BHeader(this.version, lheader, main);
        header.write(out);
    }

    private LFunction convert_function(BHeader header, AssemblerFunction function) {
        int[] code = new int[function.code.size()];
        int i = 0;
        for (int codepoint : function.code) {
            code[i++] = codepoint;
        }
        int[] lines = new int[function.lines.size()];
        i = 0;
        for (int line : function.lines) {
            lines[i++] = line;
        }
        LAbsLineInfo[] abslineinfo = new LAbsLineInfo[function.abslineinfo.size()];
        i = 0;
        for (AssemblerAbsLineInfo info : function.abslineinfo) {
            abslineinfo[i++] = new LAbsLineInfo(info.pc, info.line);
        }
        LLocal[] locals = new LLocal[function.locals.size()];
        i = 0;
        for (AssemblerLocal local : function.locals) {
            locals[i++] = new LLocal(this.convert_string(header, local.name), new BInteger(local.begin), new BInteger(local.end));
        }
        LObject[] constants = new LObject[function.constants.size()];
        i = 0;
        for (AssemblerConstant constant : function.constants) {
            Object object;
            switch (constant.type) {
                case NIL: {
                    object = LNil.NIL;
                    break;
                }
                case BOOLEAN: {
                    object = constant.booleanValue ? LBoolean.LTRUE : LBoolean.LFALSE;
                    break;
                }
                case NUMBER: {
                    object = header.number.create(constant.numberValue);
                    break;
                }
                case INTEGER: {
                    object = header.linteger.create(constant.integerValue);
                    break;
                }
                case FLOAT: {
                    object = header.lfloat.create(constant.numberValue);
                    break;
                }
                case STRING: {
                    object = this.convert_string(header, constant.stringValue);
                    break;
                }
                case LONGSTRING: {
                    object = this.convert_long_string(header, constant.stringValue);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            constants[i++] = object;
        }
        LUpvalue[] upvalues = new LUpvalue[function.upvalues.size()];
        i = 0;
        for (AssemblerUpvalue upvalue : function.upvalues) {
            LUpvalue lup = new LUpvalue();
            lup.bname = this.convert_string(header, upvalue.name);
            lup.idx = upvalue.index;
            lup.instack = upvalue.instack;
            upvalues[i++] = lup;
        }
        LFunction[] functions = new LFunction[function.children.size()];
        i = 0;
        for (AssemblerFunction f : function.children) {
            functions[i++] = this.convert_function(header, f);
        }
        return new LFunction(header, this.convert_string(header, function.source), function.linedefined, function.lastlinedefined, code, lines, abslineinfo, locals, constants, upvalues, functions, function.maxStackSize, function.upvalues.size(), function.numParams, function.vararg);
    }

    private LString convert_string(BHeader header, String string) {
        if (string == null) {
            return LString.NULL;
        }
        return new LString(string);
    }

    private LString convert_long_string(BHeader header, String string) {
        return new LString(string, true);
    }
}

