/*
 * Decompiled with CFR 0.152.
 */
package unluac.assemble;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import unluac.assemble.Assembler;
import unluac.assemble.AssemblerAbsLineInfo;
import unluac.assemble.AssemblerChunk;
import unluac.assemble.AssemblerConstant;
import unluac.assemble.AssemblerException;
import unluac.assemble.AssemblerLabel;
import unluac.assemble.AssemblerLocal;
import unluac.assemble.AssemblerUpvalue;
import unluac.assemble.Directive;
import unluac.decompile.CodeExtract;
import unluac.decompile.Op;
import unluac.decompile.OperandFormat;
import unluac.util.StringUtils;

class AssemblerFunction {
    public AssemblerChunk chunk;
    public AssemblerFunction parent;
    public String name;
    public List<AssemblerFunction> children;
    public boolean hasSource;
    public String source;
    public boolean hasLineDefined;
    public int linedefined;
    public boolean hasLastLineDefined;
    public int lastlinedefined;
    public boolean hasMaxStackSize;
    public int maxStackSize;
    public boolean hasNumParams;
    public int numParams;
    public boolean hasVararg;
    public int vararg;
    public List<AssemblerLabel> labels;
    public List<AssemblerConstant> constants;
    public List<AssemblerUpvalue> upvalues;
    public List<Integer> code;
    public List<Integer> lines;
    public List<AssemblerAbsLineInfo> abslineinfo;
    public List<AssemblerLocal> locals;
    public List<FunctionFixup> f_fixup;
    public List<JumpFixup> j_fixup;

    public AssemblerFunction(AssemblerChunk chunk, AssemblerFunction parent, String name) {
        this.chunk = chunk;
        this.parent = parent;
        this.name = name;
        this.children = new ArrayList<AssemblerFunction>();
        this.hasSource = false;
        this.hasLineDefined = false;
        this.hasLastLineDefined = false;
        this.hasMaxStackSize = false;
        this.hasNumParams = false;
        this.hasVararg = false;
        this.labels = new ArrayList<AssemblerLabel>();
        this.constants = new ArrayList<AssemblerConstant>();
        this.upvalues = new ArrayList<AssemblerUpvalue>();
        this.code = new ArrayList<Integer>();
        this.lines = new ArrayList<Integer>();
        this.abslineinfo = new ArrayList<AssemblerAbsLineInfo>();
        this.locals = new ArrayList<AssemblerLocal>();
        this.f_fixup = new ArrayList<FunctionFixup>();
        this.j_fixup = new ArrayList<JumpFixup>();
    }

    public AssemblerFunction addChild(String name) {
        AssemblerFunction child = new AssemblerFunction(this.chunk, this, name);
        this.children.add(child);
        return child;
    }

    public AssemblerFunction getInnerParent(String[] parts, int index) throws AssemblerException {
        if (index + 1 == parts.length) {
            return this;
        }
        for (AssemblerFunction child : this.children) {
            if (!child.name.equals(parts[index])) continue;
            return child.getInnerParent(parts, index + 1);
        }
        throw new AssemblerException("Can't find outer function");
    }

    public void processFunctionDirective(Assembler a, Directive d) throws AssemblerException, IOException {
        switch (d) {
            case SOURCE: {
                if (this.hasSource) {
                    throw new AssemblerException("Duplicate .source directive");
                }
                this.hasSource = true;
                this.source = a.getString();
                break;
            }
            case LINEDEFINED: {
                if (this.hasLineDefined) {
                    throw new AssemblerException("Duplicate .linedefined directive");
                }
                this.hasLineDefined = true;
                this.linedefined = a.getInteger();
                break;
            }
            case LASTLINEDEFINED: {
                if (this.hasLastLineDefined) {
                    throw new AssemblerException("Duplicate .lastlinedefined directive");
                }
                this.hasLastLineDefined = true;
                this.lastlinedefined = a.getInteger();
                break;
            }
            case MAXSTACKSIZE: {
                if (this.hasMaxStackSize) {
                    throw new AssemblerException("Duplicate .maxstacksize directive");
                }
                this.hasMaxStackSize = true;
                this.maxStackSize = a.getInteger();
                break;
            }
            case NUMPARAMS: {
                if (this.hasNumParams) {
                    throw new AssemblerException("Duplicate .numparams directive");
                }
                this.hasNumParams = true;
                this.numParams = a.getInteger();
                break;
            }
            case IS_VARARG: {
                if (this.hasVararg) {
                    throw new AssemblerException("Duplicate .is_vararg directive");
                }
                this.hasVararg = true;
                this.vararg = a.getInteger();
                break;
            }
            case LABEL: {
                String name = a.getAny();
                AssemblerLabel label = new AssemblerLabel();
                label.name = name;
                label.code_index = this.code.size();
                this.labels.add(label);
                break;
            }
            case CONSTANT: {
                String name = a.getName();
                String value = a.getAny();
                AssemblerConstant constant = new AssemblerConstant();
                constant.name = name;
                if (value.equals("nil")) {
                    constant.type = AssemblerConstant.Type.NIL;
                } else if (value.equals("true")) {
                    constant.type = AssemblerConstant.Type.BOOLEAN;
                    constant.booleanValue = true;
                } else if (value.equals("false")) {
                    constant.type = AssemblerConstant.Type.BOOLEAN;
                    constant.booleanValue = false;
                } else if (value.startsWith("\"")) {
                    constant.type = AssemblerConstant.Type.STRING;
                    constant.stringValue = StringUtils.fromPrintString(value);
                } else if (value.startsWith("L\"")) {
                    constant.type = AssemblerConstant.Type.LONGSTRING;
                    constant.stringValue = StringUtils.fromPrintString(value.substring(1));
                } else if (value.equals("null")) {
                    constant.type = AssemblerConstant.Type.STRING;
                    constant.stringValue = null;
                } else {
                    try {
                        if (this.chunk.number != null) {
                            constant.numberValue = Double.parseDouble(value);
                            constant.type = AssemblerConstant.Type.NUMBER;
                        } else if (value.contains(".") || value.contains("E") || value.contains("e")) {
                            constant.numberValue = Double.parseDouble(value);
                            constant.type = AssemblerConstant.Type.FLOAT;
                        } else {
                            constant.integerValue = new BigInteger(value);
                            constant.type = AssemblerConstant.Type.INTEGER;
                        }
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalStateException("Unrecognized constant value: " + value);
                    }
                }
                this.constants.add(constant);
                break;
            }
            case LINE: {
                this.lines.add(a.getInteger());
                break;
            }
            case ABSLINEINFO: {
                AssemblerAbsLineInfo info = new AssemblerAbsLineInfo();
                info.pc = a.getInteger();
                info.line = a.getInteger();
                this.abslineinfo.add(info);
                break;
            }
            case LOCAL: {
                AssemblerLocal local = new AssemblerLocal();
                local.name = a.getString();
                local.begin = a.getInteger();
                local.end = a.getInteger();
                this.locals.add(local);
                break;
            }
            case UPVALUE: {
                AssemblerUpvalue upvalue = new AssemblerUpvalue();
                upvalue.name = a.getString();
                upvalue.index = a.getInteger();
                upvalue.instack = a.getBoolean();
                this.upvalues.add(upvalue);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled directive: " + (Object)((Object)d));
            }
        }
    }

    public void processOp(Assembler a, CodeExtract extract, Op op, int opcode) throws AssemblerException, IOException {
        if (!this.hasMaxStackSize) {
            throw new AssemblerException("Expected .maxstacksize before code");
        }
        if (opcode >= 0 && !extract.op.check(opcode)) {
            throw new IllegalStateException("Invalid opcode: " + opcode);
        }
        int codepoint = opcode >= 0 ? extract.op.encode(opcode) : 0;
        OperandFormat[] operandFormatArray = op.operands;
        int n = op.operands.length;
        int n2 = 0;
        while (n2 < n) {
            int x;
            CodeExtract.Field field;
            OperandFormat operand = operandFormatArray[n2];
            switch (operand.field) {
                case A: {
                    field = extract.A;
                    break;
                }
                case B: {
                    field = extract.B;
                    break;
                }
                case C: {
                    field = extract.C;
                    break;
                }
                case k: {
                    field = extract.k;
                    break;
                }
                case Ax: {
                    field = extract.Ax;
                    break;
                }
                case sJ: {
                    field = extract.sJ;
                    break;
                }
                case Bx: {
                    field = extract.Bx;
                    break;
                }
                case sBx: {
                    field = extract.sBx;
                    break;
                }
                case x: {
                    field = extract.x;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled field: " + (Object)((Object)operand.field));
                }
            }
            switch (operand.format) {
                case RAW: 
                case IMMEDIATE_INTEGER: 
                case IMMEDIATE_FLOAT: {
                    x = a.getInteger();
                    break;
                }
                case IMMEDIATE_SIGNED_INTEGER: {
                    x = a.getInteger();
                    x += field.max() / 2;
                    break;
                }
                case REGISTER: {
                    x = a.getRegister();
                    break;
                }
                case REGISTER_K: {
                    Assembler.RKInfo rk = a.getRegisterK54();
                    x = rk.x;
                    if (!rk.constant) break;
                    x += this.chunk.version.rkoffset.get().intValue();
                    break;
                }
                case REGISTER_K54: {
                    Assembler.RKInfo rk = a.getRegisterK54();
                    codepoint |= extract.k.encode(rk.constant ? 1 : 0);
                    x = rk.x;
                    break;
                }
                case CONSTANT: 
                case CONSTANT_INTEGER: 
                case CONSTANT_STRING: {
                    x = a.getConstant();
                    break;
                }
                case UPVALUE: {
                    x = a.getUpvalue();
                    break;
                }
                case FUNCTION: {
                    Object fix = new FunctionFixup();
                    ((FunctionFixup)fix).code_index = this.code.size();
                    ((FunctionFixup)fix).function = a.getAny();
                    ((FunctionFixup)fix).field = field;
                    this.f_fixup.add((FunctionFixup)fix);
                    x = 0;
                    break;
                }
                case JUMP: {
                    Object fix = new JumpFixup();
                    ((JumpFixup)fix).code_index = this.code.size();
                    ((JumpFixup)fix).label = a.getAny();
                    ((JumpFixup)fix).field = field;
                    ((JumpFixup)fix).negate = false;
                    this.j_fixup.add((JumpFixup)fix);
                    x = 0;
                    break;
                }
                case JUMP_NEGATIVE: {
                    Object fix = new JumpFixup();
                    ((JumpFixup)fix).code_index = this.code.size();
                    ((JumpFixup)fix).label = a.getAny();
                    ((JumpFixup)fix).field = field;
                    ((JumpFixup)fix).negate = true;
                    this.j_fixup.add((JumpFixup)fix);
                    x = 0;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled operand format: " + (Object)((Object)operand.format));
                }
            }
            if (!field.check(x)) {
                throw new AssemblerException("Operand " + (Object)((Object)operand.field) + " out of range");
            }
            codepoint |= field.encode(x);
            ++n2;
        }
        this.code.add(codepoint);
    }

    public void fixup(CodeExtract extract) throws AssemblerException {
        int x;
        int codepoint;
        for (FunctionFixup functionFixup : this.f_fixup) {
            codepoint = this.code.get(functionFixup.code_index);
            x = -1;
            int f = 0;
            while (f < this.children.size()) {
                AssemblerFunction child = this.children.get(f);
                if (functionFixup.function.equals(child.name)) {
                    x = f;
                    break;
                }
                ++f;
            }
            if (x == -1) {
                throw new AssemblerException("Unknown function: " + functionFixup.function);
            }
            codepoint = functionFixup.field.clear(codepoint);
            this.code.set(functionFixup.code_index, codepoint |= functionFixup.field.encode(x));
        }
        for (JumpFixup jumpFixup : this.j_fixup) {
            codepoint = this.code.get(jumpFixup.code_index);
            x = 0;
            boolean found = false;
            for (AssemblerLabel label : this.labels) {
                if (!jumpFixup.label.equals(label.name)) continue;
                x = label.code_index - jumpFixup.code_index - 1;
                if (jumpFixup.negate) {
                    x = -x;
                }
                found = true;
                break;
            }
            if (!found) {
                throw new AssemblerException("Unknown label: " + jumpFixup.label);
            }
            codepoint = jumpFixup.field.clear(codepoint);
            this.code.set(jumpFixup.code_index, codepoint |= jumpFixup.field.encode(x));
        }
        for (AssemblerFunction assemblerFunction : this.children) {
            assemblerFunction.fixup(extract);
        }
    }

    class FunctionFixup {
        int code_index;
        String function;
        CodeExtract.Field field;

        FunctionFixup() {
        }
    }

    class JumpFixup {
        int code_index;
        String label;
        CodeExtract.Field field;
        boolean negate;

        JumpFixup() {
        }
    }
}

