/*
 * Decompiled with CFR 0.152.
 */
package unluac.assemble;

import java.io.IOException;
import java.io.InputStream;

public class Tokenizer {
    private StringBuilder b;
    private InputStream in;

    public Tokenizer(InputStream in) {
        this.in = in;
        this.b = new StringBuilder();
    }

    public String next() throws IOException {
        int code;
        this.b.setLength(0);
        boolean inToken = false;
        boolean inString = false;
        boolean inComment = false;
        boolean isLPrefix = false;
        boolean inEscape = false;
        while ((code = this.in.read()) != -1) {
            char c = (char)code;
            if (inString) {
                if (c == '\\' && !inEscape) {
                    inEscape = true;
                    this.b.append(c);
                    continue;
                }
                if (c == '\"' && !inEscape) {
                    this.b.append(c);
                    break;
                }
                inEscape = false;
                this.b.append(c);
                continue;
            }
            if (inComment) {
                if (c != '\n' && c != '\r') continue;
                inComment = false;
                if (!inToken) continue;
                break;
            }
            if (c == ';') {
                inComment = true;
                continue;
            }
            if (Character.isWhitespace(c)) {
                if (!inToken) continue;
                break;
            }
            if ((!inToken || isLPrefix) && c == '\"') {
                inString = true;
            } else {
                isLPrefix = !inToken && c == 'L';
            }
            inToken = true;
            this.b.append(c);
        }
        if (this.b.length() == 0) {
            return null;
        }
        return this.b.toString();
    }
}

