/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.decompile.CodeExtract;
import unluac.decompile.Op;
import unluac.decompile.OpcodeMap;
import unluac.parse.LFunction;

public class Code {
    private final CodeExtract extractor;
    private final OpcodeMap map;
    private final int[] code;
    private final boolean[] extraByte;
    private final boolean[] upvalue;
    public final int length;

    public Code(LFunction function) {
        int line;
        this.code = function.code;
        this.length = this.code.length;
        this.map = function.header.opmap;
        this.extractor = function.header.extractor;
        this.extraByte = new boolean[this.length];
        int i = 0;
        while (i < this.length) {
            line = i + 1;
            Op op = this.op(line);
            this.extraByte[i] = op != null && op.hasExtraByte(this.codepoint(line), this.extractor);
            ++i;
        }
        this.upvalue = new boolean[this.length];
        if (function.header.version.upvaluedeclarationtype.get() == Version.UpvalueDeclarationType.INLINE) {
            i = 0;
            while (i < this.length) {
                int f;
                line = i + 1;
                if (this.op(line) == Op.CLOSURE && (f = this.Bx(line)) < function.functions.length) {
                    int nups = function.functions[f].numUpvalues;
                    int j = 1;
                    while (j <= nups) {
                        if (i + j < this.length) {
                            this.upvalue[i + j] = true;
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public CodeExtract getExtractor() {
        return this.extractor;
    }

    public Op op(int line) {
        if (line >= 2 && this.extraByte[line - 2]) {
            return Op.EXTRABYTE;
        }
        return this.map.get(this.opcode(line));
    }

    public int opcode(int line) {
        return this.extractor.op.extract(this.code[line - 1]);
    }

    public int A(int line) {
        return this.extractor.A.extract(this.code[line - 1]);
    }

    public int C(int line) {
        return this.extractor.C.extract(this.code[line - 1]);
    }

    public int sC(int line) {
        int C = this.C(line);
        return C - this.extractor.C.max() / 2;
    }

    public boolean k(int line) {
        return this.extractor.k.extract(this.code[line - 1]) != 0;
    }

    public int B(int line) {
        return this.extractor.B.extract(this.code[line - 1]);
    }

    public int sB(int line) {
        int B = this.B(line);
        return B - this.extractor.B.max() / 2;
    }

    public int Ax(int line) {
        return this.extractor.Ax.extract(this.code[line - 1]);
    }

    public int Bx(int line) {
        return this.extractor.Bx.extract(this.code[line - 1]);
    }

    public int sBx(int line) {
        return this.extractor.sBx.extract(this.code[line - 1]);
    }

    public int target(int line) {
        return line + 1 + this.op(line).jumpField(this.codepoint(line), this.extractor);
    }

    public int codepoint(int line) {
        return this.code[line - 1];
    }

    public boolean isUpvalueDeclaration(int line) {
        return this.upvalue[line - 1];
    }

    public int length() {
        return this.code.length;
    }

    public String toString(int line) {
        return this.op(line).codePointToString(this.codepoint(line), this.extractor, null);
    }
}

