/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;

public class CodeExtract {
    public final Field op;
    public final Field A;
    public final Field B;
    public final Field C;
    public final Field k;
    public final Field Ax;
    public final Field sJ;
    public final Field Bx;
    public final Field sBx;
    public final Field x;
    private final int rk_offset;

    public CodeExtract(Version version, int sizeOp, int sizeA, int sizeB, int sizeC) {
        switch (version.instructionformat.get()) {
            case LUA50: {
                this.op = new Field(sizeOp, 0);
                this.A = new Field(sizeA, sizeB + sizeC + sizeOp);
                this.B = new Field(sizeB, sizeB + sizeOp);
                this.C = new Field(sizeC, sizeOp);
                this.k = null;
                this.Ax = null;
                this.sJ = null;
                this.Bx = new Field(sizeB + sizeC, sizeOp);
                this.sBx = new Field(sizeB + sizeC, sizeOp, CodeExtract.size_to_mask(sizeB + sizeC) / 2);
                this.x = new Field(32, 0);
                break;
            }
            case LUA51: {
                this.op = new Field(6, 0);
                this.A = new Field(8, 6);
                this.B = new Field(9, 23);
                this.C = new Field(9, 14);
                this.k = null;
                this.Ax = new Field(26, 6);
                this.sJ = null;
                this.Bx = new Field(18, 14);
                this.sBx = new Field(18, 14, 131071);
                this.x = new Field(32, 0);
                break;
            }
            case LUA54: {
                this.op = new Field(7, 0);
                this.A = new Field(8, 7);
                this.B = new Field(8, 16);
                this.C = new Field(8, 24);
                this.k = new Field(1, 15);
                this.Ax = new Field(25, 7);
                this.sJ = new Field(25, 7, 0xFFFFFF);
                this.Bx = new Field(17, 15);
                this.sBx = new Field(17, 15, 65535);
                this.x = new Field(32, 0);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        Integer rk_offset = version.rkoffset.get();
        this.rk_offset = rk_offset == null ? -1 : rk_offset;
    }

    public boolean is_k(int field) {
        return field >= this.rk_offset;
    }

    public int get_k(int field) {
        return field - this.rk_offset;
    }

    public int encode_k(int constant) {
        return constant + this.rk_offset;
    }

    private static int size_to_mask(int size) {
        return (int)((1L << size) - 1L);
    }

    public static class Field {
        public final int size;
        private final int shift;
        private final int mask;
        private final int offset;

        public Field(int size, int shift) {
            this(size, shift, 0);
        }

        public Field(int size, int shift, int offset) {
            this.size = size;
            this.shift = shift;
            this.mask = CodeExtract.size_to_mask(size);
            this.offset = offset;
        }

        public int extract(int codepoint) {
            return (codepoint >>> this.shift & this.mask) - this.offset;
        }

        public boolean check(int x) {
            return (x + this.offset & ~this.mask) == 0;
        }

        public int encode(int x) {
            return x + this.offset << this.shift;
        }

        public int clear(int codepoint) {
            return codepoint & ~(this.mask << this.shift);
        }

        public int max() {
            return this.mask - this.offset;
        }
    }
}

