/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.parse.LBoolean;
import unluac.parse.LNil;
import unluac.parse.LNumber;
import unluac.parse.LObject;
import unluac.parse.LString;

public class Constant {
    private final Type type;
    private final boolean bool;
    private final LNumber number;
    private final String string;

    public Constant(int constant) {
        this.type = Type.NUMBER;
        this.bool = false;
        this.number = LNumber.makeInteger(constant);
        this.string = null;
    }

    public Constant(double x) {
        this.type = Type.NUMBER;
        this.bool = false;
        this.number = LNumber.makeDouble(x);
        this.string = null;
    }

    public Constant(LObject constant) {
        if (constant instanceof LNil) {
            this.type = Type.NIL;
            this.bool = false;
            this.number = null;
            this.string = null;
        } else if (constant instanceof LBoolean) {
            this.type = Type.BOOLEAN;
            this.bool = constant == LBoolean.LTRUE;
            this.number = null;
            this.string = null;
        } else if (constant instanceof LNumber) {
            this.type = Type.NUMBER;
            this.bool = false;
            this.number = (LNumber)constant;
            this.string = null;
        } else if (constant instanceof LString) {
            this.type = Type.STRING;
            this.bool = false;
            this.number = null;
            this.string = ((LString)constant).deref();
        } else {
            throw new IllegalArgumentException("Illegal constant type: " + constant.toString());
        }
    }

    public void print(Decompiler d, Output out, boolean braced) {
        switch (this.type) {
            case NIL: {
                out.print("nil");
                break;
            }
            case BOOLEAN: {
                out.print(this.bool ? "true" : "false");
                break;
            }
            case NUMBER: {
                out.print(this.number.toPrintString());
                break;
            }
            case STRING: {
                int newlines = 0;
                int unprintable = 0;
                boolean rawstring = d.getConfiguration().rawstring;
                int i = 0;
                while (i < this.string.length()) {
                    char c = this.string.charAt(i);
                    if (c == '\n') {
                        ++newlines;
                    } else if (c <= '\u001f' && c != '\t' || c >= '\u007f') {
                        ++unprintable;
                    }
                    ++i;
                }
                boolean longString = newlines > 1 || newlines == 1 && this.string.indexOf(10) != this.string.length() - 1;
                longString = longString && unprintable == 0;
                boolean bl = longString = longString && !this.string.contains("[[");
                if (d.function.header.version.usenestinglongstrings.get().booleanValue()) {
                    boolean bl2 = longString = longString && !this.string.contains("]]") && !this.string.endsWith("]");
                }
                if (longString) {
                    int pipe = 0;
                    String pipeString = "]]";
                    String startPipeString = "]";
                    while (this.string.endsWith(startPipeString) || this.string.indexOf(pipeString) >= 0) {
                        pipeString = "]";
                        int i2 = ++pipe;
                        while (i2-- > 0) {
                            pipeString = String.valueOf(pipeString) + "=";
                        }
                        startPipeString = pipeString;
                        pipeString = String.valueOf(pipeString) + "]";
                    }
                    if (braced) {
                        out.print("(");
                    }
                    out.print("[");
                    while (pipe-- > 0) {
                        out.print("=");
                    }
                    out.print("[");
                    int indent = out.getIndentationLevel();
                    out.setIndentationLevel(0);
                    out.println();
                    out.print(this.string);
                    out.print(pipeString);
                    if (braced) {
                        out.print(")");
                    }
                    out.setIndentationLevel(indent);
                    break;
                }
                out.print("\"");
                int i3 = 0;
                while (i3 < this.string.length()) {
                    char c = this.string.charAt(i3);
                    if (c <= '\u001f' || c >= '\u007f') {
                        if (c == '\u0007') {
                            out.print("\\a");
                        } else if (c == '\b') {
                            out.print("\\b");
                        } else if (c == '\f') {
                            out.print("\\f");
                        } else if (c == '\n') {
                            out.print("\\n");
                        } else if (c == '\r') {
                            out.print("\\r");
                        } else if (c == '\t') {
                            out.print("\\t");
                        } else if (c == '\u000b') {
                            out.print("\\v");
                        } else if (!rawstring || c <= '\u007f') {
                            String dec = Integer.toString(c);
                            int len = dec.length();
                            out.print("\\");
                            while (len++ < 3) {
                                out.print("0");
                            }
                            out.print(dec);
                        } else {
                            out.print((byte)c);
                        }
                    } else if (c == '\"') {
                        out.print("\\\"");
                    } else if (c == '\\') {
                        out.print("\\\\");
                    } else {
                        out.print(Character.toString(c));
                    }
                    ++i3;
                }
                out.print("\"");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    public boolean isNil() {
        return this.type == Type.NIL;
    }

    public boolean isBoolean() {
        return this.type == Type.BOOLEAN;
    }

    public boolean isNumber() {
        return this.type == Type.NUMBER;
    }

    public boolean isInteger() {
        return this.number.value() == (double)Math.round(this.number.value());
    }

    public boolean isNegative() {
        return String.valueOf(this.number.value()).startsWith("-");
    }

    public int asInteger() {
        if (!this.isInteger()) {
            throw new IllegalStateException();
        }
        return (int)this.number.value();
    }

    public boolean isString() {
        return this.type == Type.STRING;
    }

    public boolean isIdentifierPermissive(Version version) {
        if (!this.isString() || version.isReserved(this.string)) {
            return false;
        }
        if (this.string.length() == 0) {
            return false;
        }
        char start = this.string.charAt(0);
        return !Character.isDigit(start) || start == ' ' || Character.isLetter(start);
    }

    public boolean isIdentifier(Version version) {
        if (!this.isIdentifierPermissive(version)) {
            return false;
        }
        char start = this.string.charAt(0);
        if (start != '_' && !Character.isLetter(start)) {
            return false;
        }
        int i = 1;
        while (i < this.string.length()) {
            char next = this.string.charAt(i);
            if (!Character.isLetter(next) && !Character.isDigit(next) && next != '_') {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String asName() {
        if (this.type != Type.STRING) {
            throw new IllegalStateException();
        }
        return this.string;
    }

    private static enum Type {
        NIL,
        BOOLEAN,
        NUMBER,
        STRING;

    }
}

