/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import unluac.Version;
import unluac.decompile.CloseType;
import unluac.decompile.Code;
import unluac.decompile.Declaration;
import unluac.decompile.Decompiler;
import unluac.decompile.Op;
import unluac.decompile.Registers;
import unluac.decompile.block.AlwaysLoop;
import unluac.decompile.block.Block;
import unluac.decompile.block.Break;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.block.DoEndBlock;
import unluac.decompile.block.ElseEndBlock;
import unluac.decompile.block.ForBlock;
import unluac.decompile.block.ForBlock50;
import unluac.decompile.block.ForBlock51;
import unluac.decompile.block.Goto;
import unluac.decompile.block.IfThenElseBlock;
import unluac.decompile.block.IfThenEndBlock;
import unluac.decompile.block.OnceLoop;
import unluac.decompile.block.OuterBlock;
import unluac.decompile.block.RepeatBlock;
import unluac.decompile.block.SetBlock;
import unluac.decompile.block.TForBlock;
import unluac.decompile.block.WhileBlock50;
import unluac.decompile.block.WhileBlock51;
import unluac.decompile.condition.AndCondition;
import unluac.decompile.condition.BinaryCondition;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.ConstantCondition;
import unluac.decompile.condition.FinalSetCondition;
import unluac.decompile.condition.FixedCondition;
import unluac.decompile.condition.OrCondition;
import unluac.decompile.condition.TestCondition;
import unluac.parse.LFunction;
import unluac.util.Stack;

public class ControlFlowHandler {
    public static boolean verbose = false;

    public static Result process(Decompiler d, Registers r) {
        State state = new State();
        state.d = d;
        state.function = d.function;
        state.r = r;
        state.code = d.code;
        state.labels = new boolean[d.code.length + 1];
        ControlFlowHandler.find_reverse_targets(state);
        ControlFlowHandler.find_branches(state);
        ControlFlowHandler.combine_branches(state);
        ControlFlowHandler.resolve_lines(state);
        ControlFlowHandler.initialize_blocks(state);
        ControlFlowHandler.find_fixed_blocks(state);
        ControlFlowHandler.find_while_loops(state);
        ControlFlowHandler.find_repeat_loops(state);
        ControlFlowHandler.find_if_break(state, d.declList);
        ControlFlowHandler.find_set_blocks(state);
        ControlFlowHandler.find_pseudo_goto_statements(state, d.declList);
        ControlFlowHandler.find_do_blocks(state, d.declList);
        Collections.sort(state.blocks);
        return new Result(state);
    }

    private static void find_reverse_targets(State state) {
        Code code = state.code;
        state.reverse_targets = new boolean[state.code.length + 1];
        boolean[] reverse_targets = state.reverse_targets;
        int line = 1;
        while (line <= code.length) {
            int target;
            if (ControlFlowHandler.is_jmp(state, line) && (target = code.target(line)) <= line) {
                reverse_targets[target] = true;
            }
            ++line;
        }
    }

    private static void resolve_lines(State state) {
        int[] resolved = new int[state.code.length + 1];
        Arrays.fill(resolved, -1);
        int line = 1;
        while (line <= state.code.length) {
            int r = line;
            Branch b = state.branches[line];
            while (b != null && b.type == Branch.Type.jump) {
                if (resolved[r] >= 1) {
                    r = resolved[r];
                    break;
                }
                if (resolved[r] == -2) {
                    r = b.targetSecond;
                    break;
                }
                resolved[r] = -2;
                r = b.targetSecond;
                b = state.branches[r];
            }
            if (r == line && state.code.op(line) == Op.JMP52 && ControlFlowHandler.is_close(state, line)) {
                r = line + 1;
            }
            resolved[line] = r;
            ++line;
        }
        state.resolved = resolved;
    }

    private static int find_loadboolblock(State state, int target) {
        int loadboolblock = -1;
        Op op = state.code.op(target);
        if (op == Op.LOADBOOL) {
            if (state.code.C(target) != 0) {
                loadboolblock = target;
            } else if (target - 1 >= 1 && state.code.op(target - 1) == Op.LOADBOOL && state.code.C(target - 1) != 0) {
                loadboolblock = target - 1;
            }
        } else if (op == Op.LFALSESKIP) {
            loadboolblock = target;
        } else if (target - 1 >= 1 && op == Op.LOADTRUE && state.code.op(target - 1) == Op.LFALSESKIP) {
            loadboolblock = target - 1;
        }
        return loadboolblock;
    }

    private static void handle_loadboolblock(State state, boolean[] skip, int loadboolblock, Condition c, int line, int target) {
        boolean loadboolvalue;
        Op op = state.code.op(target);
        if (op == Op.LOADBOOL) {
            loadboolvalue = state.code.B(target) != 0;
        } else if (op == Op.LFALSESKIP) {
            loadboolvalue = false;
        } else if (op == Op.LOADTRUE) {
            loadboolvalue = true;
        } else {
            throw new IllegalStateException();
        }
        int final_line = -1;
        if (loadboolblock - 1 >= 1 && ControlFlowHandler.is_jmp(state, loadboolblock - 1)) {
            int boolskip_target = state.code.target(loadboolblock - 1);
            int boolskip_target_redirected = -1;
            if (ControlFlowHandler.is_jmp_raw(state, loadboolblock + 2)) {
                boolskip_target_redirected = state.code.target(loadboolblock + 2);
            }
            if (boolskip_target == loadboolblock + 2 || boolskip_target == boolskip_target_redirected) {
                skip[loadboolblock - 1] = true;
                final_line = loadboolblock - 2;
            }
        }
        boolean inverse = false;
        if (loadboolvalue) {
            inverse = true;
            c = c.inverse();
        }
        boolean constant = ControlFlowHandler.is_jmp(state, line);
        int begin = line + 2;
        Branch b = constant ? new Branch(line, line, Branch.Type.testset, c, --begin, loadboolblock + 2, null) : (line + 2 == loadboolblock ? new Branch(loadboolblock, loadboolblock, Branch.Type.finalset, c, begin, loadboolblock + 2, null) : new Branch(line, line, Branch.Type.testset, c, begin, loadboolblock + 2, null));
        b.target = state.code.A(loadboolblock);
        b.inverseValue = inverse;
        ControlFlowHandler.insert_branch(state, b);
        if (final_line != -1) {
            if (constant && final_line < begin) {
                ++final_line;
            }
            FinalSetCondition finalc = new FinalSetCondition(final_line, b.target);
            Branch finalb = new Branch(final_line, final_line, Branch.Type.finalset, finalc, final_line, loadboolblock + 2, finalc);
            finalb.target = b.target;
            ControlFlowHandler.insert_branch(state, finalb);
            b.finalset = finalc;
        }
    }

    private static void handle_test(State state, boolean[] skip, int line, Condition c, int target, boolean invert) {
        Code code = state.code;
        int loadboolblock = ControlFlowHandler.find_loadboolblock(state, target);
        if (loadboolblock >= 1) {
            if (invert) {
                c = c.inverse();
            }
            ControlFlowHandler.handle_loadboolblock(state, skip, loadboolblock, c, line, target);
        } else {
            int ploadboolblock;
            int n = ploadboolblock = target - 2 >= 1 ? ControlFlowHandler.find_loadboolblock(state, target - 2) : -1;
            if (ploadboolblock != -1 && ploadboolblock == target - 2 && code.A(target - 2) == c.register() && !ControlFlowHandler.has_statement(state, line + 2, target - 3)) {
                ControlFlowHandler.handle_testset(state, skip, line, c, target, c.register(), invert);
            } else {
                if (invert) {
                    c = c.inverse();
                }
                Branch b = new Branch(line, line, Branch.Type.test, c, line + 2, target, null);
                b.target = code.A(line);
                if (invert) {
                    b.inverseValue = true;
                }
                ControlFlowHandler.insert_branch(state, b);
            }
        }
        skip[line + 1] = true;
    }

    private static void handle_testset(State state, boolean[] skip, int line, Condition c, int target, int register, boolean invert) {
        int branch_line;
        if (state.r.isNoDebug && ControlFlowHandler.find_loadboolblock(state, target) == -1) {
            if (invert) {
                c = c.inverse();
            }
            Branch b = new Branch(line, line, Branch.Type.test, c, line + 2, target, null);
            b.target = state.code.A(line);
            if (invert) {
                b.inverseValue = true;
            }
            ControlFlowHandler.insert_branch(state, b);
            skip[line + 1] = true;
            return;
        }
        Branch b = new Branch(line, line, Branch.Type.testset, c, line + 2, target, null);
        b.target = register;
        if (invert) {
            b.inverseValue = true;
        }
        skip[line + 1] = true;
        ControlFlowHandler.insert_branch(state, b);
        int final_line = target - 1;
        int loadboolblock = ControlFlowHandler.find_loadboolblock(state, target - 2);
        if (loadboolblock != -1 && state.code.A(loadboolblock) == register) {
            final_line = loadboolblock;
            if (loadboolblock - 2 >= 1 && ControlFlowHandler.is_jmp(state, loadboolblock - 1) && (state.code.target(loadboolblock - 1) == target || ControlFlowHandler.is_jmp_raw(state, target) && state.code.target(loadboolblock - 1) == state.code.target(target))) {
                final_line = loadboolblock - 2;
            }
            branch_line = final_line;
        } else {
            branch_line = Math.max(final_line, line + 2);
        }
        FinalSetCondition finalc = new FinalSetCondition(final_line, register);
        Branch finalb = new Branch(branch_line, branch_line, Branch.Type.finalset, finalc, final_line, target, finalc);
        finalb.target = register;
        ControlFlowHandler.insert_branch(state, finalb);
        b.finalset = finalc;
    }

    private static void process_condition(State state, boolean[] skip, int line, Condition c, boolean invert) {
        int loadboolblock;
        int target = state.code.target(line + 1);
        if (invert) {
            c = c.inverse();
        }
        if ((loadboolblock = ControlFlowHandler.find_loadboolblock(state, target)) >= 1) {
            ControlFlowHandler.handle_loadboolblock(state, skip, loadboolblock, c, line, target);
        } else {
            Branch b = new Branch(line, line, Branch.Type.comparison, c, line + 2, target, null);
            if (invert) {
                b.inverseValue = true;
            }
            ControlFlowHandler.insert_branch(state, b);
        }
        skip[line + 1] = true;
    }

    private static void find_branches(State state) {
        Code code = state.code;
        state.branches = new Branch[state.code.length + 1];
        state.setbranches = new Branch[state.code.length + 1];
        state.finalsetbranches = new ArrayList(state.code.length + 1);
        int i = 0;
        while (i <= state.code.length) {
            state.finalsetbranches.add(null);
            ++i;
        }
        boolean[] skip = new boolean[code.length + 1];
        int line = 1;
        while (line <= code.length) {
            if (!skip[line]) {
                switch (code.op(line)) {
                    case EQ: 
                    case LT: 
                    case LE: {
                        BinaryCondition.Operator op = BinaryCondition.Operator.EQ;
                        if (code.op(line) == Op.LT) {
                            op = BinaryCondition.Operator.LT;
                        }
                        if (code.op(line) == Op.LE) {
                            op = BinaryCondition.Operator.LE;
                        }
                        Condition.Operand left = new Condition.Operand(Condition.OperandType.RK, code.B(line));
                        Condition.Operand right = new Condition.Operand(Condition.OperandType.RK, code.C(line));
                        BinaryCondition c = new BinaryCondition(op, line, left, right);
                        ControlFlowHandler.process_condition(state, skip, line, c, code.A(line) != 0);
                        break;
                    }
                    case EQ54: 
                    case LT54: 
                    case LE54: {
                        BinaryCondition.Operator op = BinaryCondition.Operator.EQ;
                        if (code.op(line) == Op.LT54) {
                            op = BinaryCondition.Operator.LT;
                        }
                        if (code.op(line) == Op.LE54) {
                            op = BinaryCondition.Operator.LE;
                        }
                        Condition.Operand left = new Condition.Operand(Condition.OperandType.R, code.A(line));
                        Condition.Operand right = new Condition.Operand(Condition.OperandType.R, code.B(line));
                        BinaryCondition c = new BinaryCondition(op, line, left, right);
                        ControlFlowHandler.process_condition(state, skip, line, c, code.k(line));
                        break;
                    }
                    case EQK: {
                        BinaryCondition.Operator op = BinaryCondition.Operator.EQ;
                        Condition.Operand right = new Condition.Operand(Condition.OperandType.R, code.A(line));
                        Condition.Operand left = new Condition.Operand(Condition.OperandType.K, code.B(line));
                        BinaryCondition c = new BinaryCondition(op, line, left, right);
                        ControlFlowHandler.process_condition(state, skip, line, c, code.k(line));
                        break;
                    }
                    case EQI: 
                    case LTI: 
                    case LEI: 
                    case GTI: 
                    case GEI: {
                        BinaryCondition.Operator op = BinaryCondition.Operator.EQ;
                        if (code.op(line) == Op.LTI) {
                            op = BinaryCondition.Operator.LT;
                        }
                        if (code.op(line) == Op.LEI) {
                            op = BinaryCondition.Operator.LE;
                        }
                        if (code.op(line) == Op.GTI) {
                            op = BinaryCondition.Operator.GT;
                        }
                        if (code.op(line) == Op.GEI) {
                            op = BinaryCondition.Operator.GE;
                        }
                        Condition.OperandType operandType = code.C(line) != 0 ? Condition.OperandType.F : Condition.OperandType.I;
                        Condition.Operand left = new Condition.Operand(Condition.OperandType.R, code.A(line));
                        Condition.Operand right = new Condition.Operand(operandType, code.sB(line));
                        if (op == BinaryCondition.Operator.EQ) {
                            Condition.Operand temp = left;
                            left = right;
                            right = temp;
                        }
                        BinaryCondition c = new BinaryCondition(op, line, left, right);
                        ControlFlowHandler.process_condition(state, skip, line, c, code.k(line));
                        break;
                    }
                    case TEST50: {
                        TestCondition c = new TestCondition(line, code.B(line));
                        int target = code.target(line + 1);
                        if (code.A(line) == code.B(line)) {
                            ControlFlowHandler.handle_test(state, skip, line, c, target, code.C(line) != 0);
                            break;
                        }
                        ControlFlowHandler.handle_testset(state, skip, line, c, target, code.A(line), code.C(line) != 0);
                        break;
                    }
                    case TEST: {
                        int target = code.target(line + 1);
                        TestCondition c = new TestCondition(line, code.A(line));
                        ControlFlowHandler.handle_test(state, skip, line, c, target, code.C(line) != 0);
                        break;
                    }
                    case TEST54: {
                        int target = code.target(line + 1);
                        TestCondition c = new TestCondition(line, code.A(line));
                        ControlFlowHandler.handle_test(state, skip, line, c, target, code.k(line));
                        break;
                    }
                    case TESTSET: {
                        TestCondition c = new TestCondition(line, code.B(line));
                        int target = code.target(line + 1);
                        ControlFlowHandler.handle_testset(state, skip, line, c, target, code.A(line), code.C(line) != 0);
                        break;
                    }
                    case TESTSET54: {
                        TestCondition c = new TestCondition(line, code.B(line));
                        int target = code.target(line + 1);
                        ControlFlowHandler.handle_testset(state, skip, line, c, target, code.A(line), code.k(line));
                        break;
                    }
                    case JMP: 
                    case JMP52: 
                    case JMP54: {
                        if (!ControlFlowHandler.is_jmp(state, line)) break;
                        int target = code.target(line);
                        int loadboolblock = ControlFlowHandler.find_loadboolblock(state, target);
                        if (loadboolblock >= 1) {
                            ControlFlowHandler.handle_loadboolblock(state, skip, loadboolblock, new ConstantCondition(-1, false), line, target);
                            break;
                        }
                        Branch b = new Branch(line, line, Branch.Type.jump, null, target, target, null);
                        ControlFlowHandler.insert_branch(state, b);
                        break;
                    }
                }
            }
            ++line;
        }
        ControlFlowHandler.link_branches(state);
    }

    private static void combine_branches(State state) {
        Branch b = state.end_branch;
        while (b != null) {
            b = ControlFlowHandler.combine_left((State)state, (Branch)b).previous;
        }
    }

    private static void initialize_blocks(State state) {
        state.blocks = new LinkedList<Block>();
    }

    private static void find_fixed_blocks(State state) {
        boolean forvarClose;
        int C;
        int A;
        int target;
        int line;
        List<Block> blocks = state.blocks;
        Registers r = state.r;
        Code code = state.code;
        Op tforTarget = state.function.header.version.tfortarget.get();
        Op forTarget = state.function.header.version.fortarget.get();
        blocks.add(new OuterBlock(state.function, state.code.length));
        boolean[] loop = new boolean[state.code.length + 1];
        Branch b = state.begin_branch;
        while (b != null) {
            if (b.type == Branch.Type.jump) {
                line = b.line;
                target = b.targetFirst;
                if (code.op(target) == tforTarget && !loop[target]) {
                    loop[target] = true;
                    A = code.A(target);
                    C = code.C(target);
                    if (C == 0) {
                        throw new IllegalStateException();
                    }
                    ControlFlowHandler.remove_branch(state, state.branches[line]);
                    if (state.branches[target + 1] != null) {
                        ControlFlowHandler.remove_branch(state, state.branches[target + 1]);
                    }
                    forvarClose = false;
                    boolean innerClose = false;
                    int close = target - 1;
                    if (close >= line + 1 && ControlFlowHandler.is_close(state, close) && code.A(close) == A + 3) {
                        forvarClose = true;
                        --close;
                    }
                    if (close >= line + 1 && ControlFlowHandler.is_close(state, close) && code.A(close) <= A + 3 + C) {
                        innerClose = true;
                    }
                    TForBlock block = TForBlock.make51(state.function, line + 1, target + 2, A, C, forvarClose, innerClose);
                    block.handleVariableDeclarations(r);
                    blocks.add(block);
                } else if (code.op(target) == forTarget && !loop[target]) {
                    loop[target] = true;
                    A = code.A(target);
                    ForBlock50 block = new ForBlock50(state.function, line + 1, target + 1, A, ControlFlowHandler.get_close_type(state, target - 1), target - 1);
                    ((ForBlock)block).handleVariableDeclarations(r);
                    blocks.add(block);
                    ControlFlowHandler.remove_branch(state, b);
                }
            }
            b = b.next;
        }
        line = 1;
        while (line <= code.length) {
            switch (code.op(line)) {
                case FORPREP: 
                case FORPREP54: {
                    int A2 = code.A(line);
                    int target2 = code.target(line);
                    boolean forvarClose2 = false;
                    int closeLine = target2 - 1;
                    if (closeLine >= line + 1 && ControlFlowHandler.is_close(state, closeLine) && code.A(closeLine) == A2 + 3) {
                        forvarClose2 = true;
                        --closeLine;
                    }
                    ForBlock51 block = new ForBlock51(state.function, line + 1, target2 + 1, A2, ControlFlowHandler.get_close_type(state, closeLine), closeLine, forvarClose2);
                    ((ForBlock)block).handleVariableDeclarations(r);
                    blocks.add(block);
                    break;
                }
                case TFORPREP: {
                    target = code.target(line);
                    A = code.A(target);
                    C = code.C(target);
                    boolean innerClose = false;
                    int close = target - 1;
                    if (close >= line + 1 && ControlFlowHandler.is_close(state, close) && code.A(close) == A + 3 + C) {
                        innerClose = true;
                    }
                    TForBlock block = TForBlock.make50(state.function, line + 1, target + 2, A, C + 1, innerClose);
                    block.handleVariableDeclarations(r);
                    blocks.add(block);
                    ControlFlowHandler.remove_branch(state, state.branches[target + 1]);
                    break;
                }
                case TFORPREP54: {
                    target = code.target(line);
                    A = code.A(line);
                    C = code.C(target);
                    forvarClose = false;
                    int close = target - 1;
                    if (close >= line + 1 && ControlFlowHandler.is_close(state, close) && code.A(close) == A + 4) {
                        forvarClose = true;
                        --close;
                    }
                    TForBlock block = TForBlock.make54(state.function, line + 1, target + 2, A, C, forvarClose);
                    block.handleVariableDeclarations(r);
                    blocks.add(block);
                    break;
                }
            }
            ++line;
        }
    }

    private static void unredirect(State state, int begin, int end, int line, int target) {
        Branch b = state.begin_branch;
        while (b != null) {
            if (b.line >= begin && b.line < end && b.targetSecond == target) {
                if (b.type == Branch.Type.finalset) {
                    b.targetFirst = line - 1;
                    b.targetSecond = line;
                    if (b.finalset != null) {
                        b.finalset.line = line - 1;
                    }
                } else {
                    b.targetSecond = line;
                    if (b.targetFirst == target) {
                        b.targetFirst = line;
                    }
                }
            }
            b = b.next;
        }
    }

    private static void find_while_loops(State state) {
        List<Block> blocks = state.blocks;
        Branch j = state.end_branch;
        while (j != null) {
            if (j.type == Branch.Type.jump && j.targetFirst <= j.line) {
                int line;
                int loopback = line = j.targetFirst;
                int end = j.line + 1;
                Branch b = state.begin_branch;
                int extent = -1;
                while (b != null) {
                    if (ControlFlowHandler.is_conditional(b) && b.line >= loopback && b.line < j.line && state.resolved[b.targetSecond] == state.resolved[end] && extent <= b.line) break;
                    if (b.line >= loopback) {
                        extent = Math.max(extent, b.targetSecond);
                    }
                    b = b.next;
                }
                if (b != null) {
                    boolean reverse = state.reverse_targets[loopback];
                    state.reverse_targets[loopback] = false;
                    if (ControlFlowHandler.has_statement(state, loopback, b.line - 1)) {
                        b = null;
                    }
                    state.reverse_targets[loopback] = reverse;
                }
                if (state.function.header.version.whileformat.get() == Version.WhileFormat.BOTTOM_CONDITION) {
                    b = null;
                }
                ContainerBlock loop = null;
                if (b != null) {
                    b.targetSecond = end;
                    ControlFlowHandler.remove_branch(state, b);
                    loop = new WhileBlock51(state.function, b.cond, b.targetFirst, b.targetSecond, loopback, ControlFlowHandler.get_close_type(state, end - 2), end - 2);
                    ControlFlowHandler.unredirect(state, loopback, end, j.line, loopback);
                }
                if (loop == null && j.line - 5 >= 1 && state.code.op(j.line - 3) == Op.CLOSE && ControlFlowHandler.is_jmp_raw(state, j.line - 2) && state.code.target(j.line - 2) == end && state.code.op(j.line - 1) == Op.CLOSE) {
                    b = j.previous;
                    while (!(b == null || ControlFlowHandler.is_conditional(b) && b.line2 == j.line - 5)) {
                        b = b.previous;
                    }
                    if (b != null) {
                        Branch skip = state.branches[j.line - 2];
                        if (skip == null) {
                            throw new IllegalStateException();
                        }
                        int scopeEnd = j.line - 3;
                        if (state.function.header.version.closeinscope.get().booleanValue()) {
                            scopeEnd = j.line - 2;
                        }
                        loop = new RepeatBlock(state.function, b.cond, j.targetFirst, j.line + 1, CloseType.NONE, -1, true, scopeEnd);
                        ControlFlowHandler.remove_branch(state, b);
                        ControlFlowHandler.remove_branch(state, skip);
                    }
                }
                if (loop == null) {
                    boolean repeat = false;
                    if (state.function.header.version.whileformat.get() == Version.WhileFormat.BOTTOM_CONDITION) {
                        repeat = true;
                        if (loopback - 1 >= 1 && state.branches[loopback - 1] != null) {
                            Branch head = state.branches[loopback - 1];
                            if (head.type == Branch.Type.jump && head.targetFirst == j.line) {
                                ControlFlowHandler.remove_branch(state, head);
                                repeat = false;
                            }
                        }
                    }
                    loop = new AlwaysLoop(state.function, loopback, end, ControlFlowHandler.get_close_type(state, end - 2), end - 2, repeat);
                    ControlFlowHandler.unredirect(state, loopback, end, j.line, loopback);
                }
                ControlFlowHandler.remove_branch(state, j);
                blocks.add(loop);
            }
            j = j.previous;
        }
    }

    private static void find_repeat_loops(State state) {
        List<Block> blocks = state.blocks;
        Branch b = state.begin_branch;
        while (b != null) {
            if (ControlFlowHandler.is_conditional(b) && b.targetSecond < b.targetFirst) {
                int head;
                ContainerBlock block = null;
                if (state.function.header.version.whileformat.get() == Version.WhileFormat.BOTTOM_CONDITION && (head = b.targetSecond - 1) >= 1 && state.branches[head] != null && state.branches[head].type == Branch.Type.jump) {
                    Branch headb = state.branches[head];
                    if (headb.targetSecond <= b.line) {
                        if (ControlFlowHandler.has_statement(state, headb.targetSecond, b.line - 1)) {
                            headb = null;
                        }
                        if (headb != null) {
                            block = new WhileBlock50(state.function, b.cond.inverse(), head + 1, b.targetFirst, headb.targetFirst, ControlFlowHandler.get_close_type(state, headb.targetFirst - 1), headb.targetFirst - 1);
                            ControlFlowHandler.remove_branch(state, headb);
                            ControlFlowHandler.unredirect(state, 1, headb.line, headb.line, headb.targetSecond);
                        }
                    }
                }
                if (block == null) {
                    if (state.function.header.version.extendedrepeatscope.get().booleanValue()) {
                        int statementLine = b.line - 1;
                        while (statementLine >= 1 && !ControlFlowHandler.is_statement(state, statementLine)) {
                            --statementLine;
                        }
                        block = new RepeatBlock(state.function, b.cond, b.targetSecond, b.targetFirst, ControlFlowHandler.get_close_type(state, statementLine), statementLine, true, statementLine);
                    } else {
                        block = state.function.header.version.closesemantics.get() == Version.CloseSemantics.JUMP ? new RepeatBlock(state.function, b.cond, b.targetSecond, b.targetFirst, ControlFlowHandler.get_close_type(state, b.targetFirst), b.targetFirst, false, -1) : new RepeatBlock(state.function, b.cond, b.targetSecond, b.targetFirst, CloseType.NONE, -1, false, -1);
                    }
                }
                ControlFlowHandler.remove_branch(state, b);
                blocks.add(block);
            }
            b = b.next;
        }
    }

    private static boolean splits_decl(int line, int begin, int end, Declaration[] declList) {
        Declaration[] declarationArray = declList;
        int n = declList.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration decl = declarationArray[n2];
            if (decl.isSplitBy(line, begin, end)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static int stack_reach(State state, Stack<Branch> stack) {
        int i = 0;
        while (i < stack.size()) {
            Branch b = stack.peek(i);
            Block breakable = ControlFlowHandler.enclosing_breakable_block(state, b.line);
            if (breakable == null || breakable.end != b.targetSecond) {
                return b.targetSecond;
            }
            ++i;
        }
        return Integer.MAX_VALUE;
    }

    private static Block resolve_if_stack(State state, Stack<Branch> stack, int line) {
        IfThenEndBlock block = null;
        if (!stack.isEmpty() && ControlFlowHandler.stack_reach(state, stack) <= line) {
            Branch top = stack.pop();
            int literalEnd = state.code.target(top.targetFirst - 1);
            block = new IfThenEndBlock(state.function, state.r, top.cond, top.targetFirst, top.targetSecond, ControlFlowHandler.get_close_type(state, top.targetSecond - 1), top.targetSecond - 1, literalEnd != top.targetSecond);
            state.blocks.add(block);
            ControlFlowHandler.remove_branch(state, top);
        }
        return block;
    }

    private static void resolve_else(State state, Stack<Branch> stack, Stack<Branch> hanging, Stack<ElseEndBlock> elseStack, Branch top, Branch b, int tailTargetSecond) {
        while (!elseStack.isEmpty() && elseStack.peek().end == tailTargetSecond && elseStack.peek().begin >= top.targetFirst) {
            elseStack.pop().end = b.line;
        }
        Stack<Branch> replace = new Stack<Branch>();
        while (!hanging.isEmpty() && hanging.peek().targetSecond == tailTargetSecond && hanging.peek().line > top.line) {
            Branch hanger = hanging.pop();
            hanger.targetSecond = b.line;
            Block breakable = ControlFlowHandler.enclosing_breakable_block(state, hanger.line);
            if (breakable != null && hanger.targetSecond >= breakable.end) {
                replace.push(hanger);
                continue;
            }
            stack.push(hanger);
            Block if_block = ControlFlowHandler.resolve_if_stack(state, stack, b.line);
            if (if_block != null) continue;
            throw new IllegalStateException();
        }
        while (!replace.isEmpty()) {
            hanging.push((Branch)replace.pop());
        }
        ControlFlowHandler.unredirect_finalsets(state, tailTargetSecond, b.line, top.targetFirst);
        Stack<Branch> restore = new Stack<Branch>();
        while (!stack.isEmpty() && stack.peek().line > top.line && stack.peek().targetSecond == b.targetSecond) {
            stack.peek().targetSecond = b.line;
            restore.push(stack.pop());
        }
        while (!restore.isEmpty()) {
            stack.push((Branch)restore.pop());
        }
        b.targetSecond = tailTargetSecond;
        state.blocks.add(new IfThenElseBlock(state.function, top.cond, top.targetFirst, top.targetSecond, b.targetSecond, ControlFlowHandler.get_close_type(state, top.targetSecond - 2), top.targetSecond - 2));
        ElseEndBlock elseBlock = new ElseEndBlock(state.function, top.targetSecond, b.targetSecond, ControlFlowHandler.get_close_type(state, b.targetSecond - 1), b.targetSecond - 1);
        state.blocks.add(elseBlock);
        elseStack.push(elseBlock);
        ControlFlowHandler.remove_branch(state, b);
    }

    private static boolean is_hanger_resolvable(State state, Declaration[] declList, Branch hanging, Branch resolver) {
        return hanging.targetSecond == resolver.targetFirst && ControlFlowHandler.enclosing_block(state, hanging.line) == ControlFlowHandler.enclosing_block(state, resolver.line) && !ControlFlowHandler.splits_decl(hanging.line, hanging.targetFirst, resolver.line, declList) && (state.function.header.version.useifbreakrewrite.get() == false || hanging.targetFirst != resolver.line - 1 || !ControlFlowHandler.is_jmp(state, resolver.line - 1));
    }

    private static boolean is_hanger_resolvable(State state, Declaration[] declList, Branch hanging, Stack<Branch> resolvers) {
        int i = 0;
        while (i < resolvers.size()) {
            if (ControlFlowHandler.is_hanger_resolvable(state, declList, hanging, resolvers.peek(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void resolve_hanger(State state, Declaration[] declList, Stack<Branch> stack, Branch hanger, Branch b) {
        hanger.targetSecond = b.line;
        stack.push(hanger);
        Block if_block = ControlFlowHandler.resolve_if_stack(state, stack, b.line);
        if (if_block == null) {
            throw new IllegalStateException();
        }
    }

    private static void resolve_hangers(State state, Declaration[] declList, Stack<Branch> stack, Stack<Branch> hanging, Branch b) {
        while (!hanging.isEmpty() && ControlFlowHandler.is_hanger_resolvable(state, declList, hanging.peek(), b)) {
            ControlFlowHandler.resolve_hanger(state, declList, stack, hanging.pop(), b);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void find_if_break(State state, Declaration[] declList) {
        stack = new Stack<Branch>();
        hanging = new Stack<Branch>();
        elseStack = new Stack<ElseEndBlock>();
        b = state.begin_branch;
        hangingResolver = new Stack<Branch>();
        while (b != null) {
            block39: {
                block40: {
                    block38: {
                        while (ControlFlowHandler.resolve_if_stack(state, stack, b.line2) != null) {
                        }
                        while (!elseStack.isEmpty() && ((ElseEndBlock)elseStack.peek()).end <= b.line) {
                            elseStack.pop();
                        }
                        while (!hangingResolver.isEmpty() && !ControlFlowHandler.enclosing_block(state, ((Branch)hangingResolver.peek()).line).contains(b.line)) {
                            ControlFlowHandler.resolve_hangers(state, declList, stack, hanging, (Branch)hangingResolver.pop());
                        }
                        if (!ControlFlowHandler.is_conditional(b)) break block38;
                        unprotected = ControlFlowHandler.enclosing_unprotected_block(state, b.line);
                        if (b.targetFirst > b.targetSecond) {
                            throw new IllegalStateException();
                        }
                        if (unprotected != null && !unprotected.contains(b.targetSecond) && b.targetSecond == unprotected.getUnprotectedTarget()) {
                            b.targetSecond = unprotected.getUnprotectedLine();
                        }
                        breakable = ControlFlowHandler.enclosing_breakable_block(state, b.line);
                        if (!stack.isEmpty() && stack.peek().targetSecond < b.targetSecond || breakable != null && !breakable.contains(b.targetSecond)) {
                            hanging.push(b);
                        } else {
                            stack.push(b);
                        }
                        break block39;
                    }
                    if (b.type != Branch.Type.jump) break block39;
                    line = b.line;
                    enclosing = ControlFlowHandler.enclosing_block(state, b.line);
                    tailTargetSecond = b.targetSecond;
                    unprotected = ControlFlowHandler.enclosing_unprotected_block(state, b.line);
                    if (unprotected != null && !unprotected.contains(b.targetSecond) && tailTargetSecond == state.resolved[unprotected.getUnprotectedTarget()]) {
                        tailTargetSecond = unprotected.getUnprotectedLine();
                    }
                    handled = false;
                    breakable = ControlFlowHandler.enclosing_breakable_block(state, line);
                    if (breakable != null && (b.targetFirst == breakable.end || b.targetFirst == state.resolved[breakable.end])) {
                        block /* !! */  = new Break(state.function, b.line, b.targetFirst);
                        if (!hanging.isEmpty() && hanging.peek().targetSecond == b.targetFirst && ControlFlowHandler.enclosing_block(state, hanging.peek().line) == enclosing && (stack.isEmpty() || stack.peek().line < hanging.peek().line || hanging.peek().line > stack.peek().line)) {
                            hangingResolver.push(b);
                        }
                        ControlFlowHandler.unredirect_finalsets(state, b.targetFirst, line, breakable.begin);
                        state.blocks.add(block /* !! */ );
                        ControlFlowHandler.remove_branch(state, b);
                        handled = true;
                    }
                    if (!handled && state.function.header.version.usegoto.get().booleanValue() && breakable != null && !breakable.contains(b.targetFirst) && state.resolved[b.targetFirst] != state.resolved[breakable.end]) {
                        block /* !! */  = new Goto(state.function, b.line, b.targetFirst);
                        if (!hanging.isEmpty() && hanging.peek().targetSecond == b.targetFirst && ControlFlowHandler.enclosing_block(state, hanging.peek().line) == enclosing && (stack.isEmpty() || hanging.peek().line > stack.peek().line)) {
                            hangingResolver.push(b);
                        }
                        ControlFlowHandler.unredirect_finalsets(state, b.targetFirst, line, 1);
                        state.blocks.add(block /* !! */ );
                        state.labels[b.targetFirst] = true;
                        ControlFlowHandler.remove_branch(state, b);
                        handled = true;
                    }
                    if (!handled && !stack.isEmpty() && stack.peek().targetSecond - 1 == b.line) {
                        top = stack.peek();
                        while (top != null && top.targetSecond - 1 == b.line && ControlFlowHandler.splits_decl(top.line, top.targetFirst, top.targetSecond, declList)) {
                            if_block = ControlFlowHandler.resolve_if_stack(state, stack, top.targetSecond);
                            if (if_block == null) {
                                throw new IllegalStateException();
                            }
                            v0 = top = stack.isEmpty() != false ? null : stack.peek();
                        }
                        if (top != null && top.targetSecond - 1 == b.line) {
                            if (top.targetSecond != b.targetSecond) {
                                ControlFlowHandler.resolve_else(state, stack, hanging, elseStack, top, b, tailTargetSecond);
                                stack.pop();
                            } else if (!ControlFlowHandler.splits_decl(top.line, top.targetFirst, top.targetSecond - 1, declList)) {
                                b.targetSecond = tailTargetSecond;
                                state.blocks.add(new IfThenElseBlock(state.function, top.cond, top.targetFirst, top.targetSecond, b.targetSecond, ControlFlowHandler.get_close_type(state, top.targetSecond - 2), top.targetSecond - 2));
                                ControlFlowHandler.remove_branch(state, b);
                                stack.pop();
                            }
                        }
                        handled = true;
                    }
                    if (handled || breakable == null || line + 1 >= state.branches.length || state.branches[line + 1] == null || state.branches[line + 1].type != Branch.Type.jump) break block40;
                    i = 0;
                    while (i < hanging.size()) {
                        block41: {
                            hanger = hanging.peek(i);
                            if (state.resolved[hanger.targetSecond] != state.resolved[breakable.end] || line + 1 >= state.branches.length || state.branches[line + 1] == null || state.branches[line + 1].targetFirst != hanger.targetSecond || ControlFlowHandler.splits_decl(hanger.line, hanger.targetFirst, b.line, declList) || ControlFlowHandler.splits_decl(b.line, b.line + 1, b.line + 2, declList) || ControlFlowHandler.splits_decl(hanger.line, hanger.targetFirst, b.line + 2, declList)) break block41;
                            j = i;
                            ** GOTO lbl92
                            {
                                hangingResolver.pop();
                                do {
                                    if (!ControlFlowHandler.is_hanger_resolvable(state, declList, hanging.peek(), hangingResolver.peek())) continue block6;
                                    ControlFlowHandler.resolve_hanger(state, declList, stack, hanging.pop(), hangingResolver.peek());
                                    --j;
lbl92:
                                    // 2 sources

                                } while (j > 0);
                            }
                            top = hanging.pop();
                            if (!hangingResolver.isEmpty() && hangingResolver.peek().targetFirst == top.targetSecond) {
                                hangingResolver.pop();
                            }
                            top.targetSecond = line + 1;
                            ControlFlowHandler.resolve_else(state, stack, hanging, elseStack, top, b, tailTargetSecond);
                            handled = true;
                            break;
                        }
                        if (!ControlFlowHandler.is_hanger_resolvable(state, declList, hanger, hangingResolver)) break;
                        ++i;
                    }
                }
                if (!handled && breakable != null && breakable.isSplitable() && state.resolved[b.targetFirst] == breakable.getUnprotectedTarget() && line + 1 < state.branches.length && state.branches[line + 1] != null && state.branches[line + 1].type == Branch.Type.jump && state.resolved[state.branches[line + 1].targetFirst] == state.resolved[breakable.end]) {
                    var17_27 = split = breakable.split(b.line, ControlFlowHandler.get_close_type(state, b.line - 1));
                    var16_26 = split.length;
                    var15_25 = 0;
                    while (var15_25 < var16_26) {
                        block = var17_27[var15_25];
                        state.blocks.add(block);
                        ++var15_25;
                    }
                    ControlFlowHandler.remove_branch(state, b);
                    handled = true;
                }
                if (!handled && !stack.isEmpty() && stack.peek().targetSecond == b.targetFirst && line + 1 < state.branches.length && state.branches[line + 1] != null && state.branches[line + 1].type == Branch.Type.jump && state.branches[line + 1].targetFirst == b.targetFirst) {
                    top = stack.peek();
                    if (!ControlFlowHandler.splits_decl(top.line, top.targetFirst, b.line, declList)) {
                        top.targetSecond = line + 1;
                        b.targetSecond = line + 1;
                        state.blocks.add(new IfThenElseBlock(state.function, top.cond, top.targetFirst, top.targetSecond, b.targetSecond, ControlFlowHandler.get_close_type(state, line - 1), line - 1));
                        ControlFlowHandler.remove_branch(state, b);
                        stack.pop();
                    }
                    handled = true;
                }
                if (!handled && !hanging.isEmpty() && hanging.peek().targetSecond == b.targetFirst && line + 1 < state.branches.length && state.branches[line + 1] != null && state.branches[line + 1].type == Branch.Type.jump && state.branches[line + 1].targetFirst == b.targetFirst) {
                    top = hanging.peek();
                    if (!ControlFlowHandler.splits_decl(top.line, top.targetFirst, b.line, declList)) {
                        if (!hangingResolver.isEmpty() && hangingResolver.peek().targetFirst == top.targetSecond) {
                            hangingResolver.pop();
                        }
                        top.targetSecond = line + 1;
                        b.targetSecond = line + 1;
                        state.blocks.add(new IfThenElseBlock(state.function, top.cond, top.targetFirst, top.targetSecond, b.targetSecond, ControlFlowHandler.get_close_type(state, line - 1), line - 1));
                        ControlFlowHandler.remove_branch(state, b);
                        hanging.pop();
                    }
                    handled = true;
                }
                if (!handled && (state.function.header.version.usegoto.get().booleanValue() || state.r.isNoDebug)) {
                    block = new Goto(state.function, b.line, b.targetFirst);
                    if (!hanging.isEmpty() && hanging.peek().targetSecond == b.targetFirst && ControlFlowHandler.enclosing_block(state, hanging.peek().line) == enclosing) {
                        hangingResolver.push(b);
                    }
                    state.blocks.add(block);
                    state.labels[b.targetFirst] = true;
                    ControlFlowHandler.remove_branch(state, b);
                    handled = true;
                }
            }
            b = b.next;
        }
        while (!hangingResolver.isEmpty()) {
            ControlFlowHandler.resolve_hangers(state, declList, stack, hanging, (Branch)hangingResolver.pop());
        }
        while (!hanging.isEmpty()) {
            block44: {
                block42: {
                    block43: {
                        top = (Branch)hanging.pop();
                        breakable = ControlFlowHandler.enclosing_breakable_block(state, top.line);
                        if (breakable == null || breakable.end != top.targetSecond) break block42;
                        if (!state.function.header.version.useifbreakrewrite.get().booleanValue() && !state.r.isNoDebug) break block43;
                        block = new IfThenEndBlock(state.function, state.r, top.cond.inverse(), top.targetFirst - 1, top.targetFirst - 1);
                        block.addStatement(new Break(state.function, top.targetFirst - 1, top.targetSecond));
                        state.blocks.add(block);
                        break block44;
                    }
                    throw new IllegalStateException();
                }
                if (!state.function.header.version.usegoto.get().booleanValue() && !state.r.isNoDebug) ** GOTO lbl180
                if (state.function.header.version.useifbreakrewrite.get().booleanValue() || state.r.isNoDebug) {
                    block = new IfThenEndBlock(state.function, state.r, top.cond.inverse(), top.targetFirst - 1, top.targetFirst - 1);
                    block.addStatement(new Goto(state.function, top.targetFirst - 1, top.targetSecond));
                    state.blocks.add(block);
                    state.labels[top.targetSecond] = true;
                } else {
                    throw new IllegalStateException();
lbl180:
                    // 1 sources

                    throw new IllegalStateException();
                }
            }
            ControlFlowHandler.remove_branch(state, top);
        }
        while (ControlFlowHandler.resolve_if_stack(state, stack, 0x7FFFFFFF) != null) {
        }
    }

    private static void unredirect_finalsets(State state, int target, int line, int begin) {
        Branch b = state.begin_branch;
        while (b != null) {
            if (b.type == Branch.Type.finalset && b.targetSecond == target && b.line < line && b.line >= begin) {
                b.targetFirst = line - 1;
                b.targetSecond = line;
                if (b.finalset != null) {
                    b.finalset.line = line - 1;
                }
            }
            b = b.next;
        }
    }

    private static void find_set_blocks(State state) {
        List<Block> blocks = state.blocks;
        Branch b = state.begin_branch;
        while (b != null) {
            if (ControlFlowHandler.is_assignment(b) || b.type == Branch.Type.finalset) {
                if (b.finalset != null) {
                    FinalSetCondition c = b.finalset;
                    Op op = state.code.op(c.line);
                    if (c.line >= 2 && (op == Op.MMBIN || op == Op.MMBINI || op == Op.MMBINK || op == Op.EXTRAARG)) {
                        --c.line;
                        if (b.targetFirst == c.line + 1) {
                            b.targetFirst = c.line;
                        }
                    }
                    while (state.code.isUpvalueDeclaration(c.line)) {
                        --c.line;
                        if (b.targetFirst != c.line + 1) continue;
                        b.targetFirst = c.line;
                    }
                    c.type = ControlFlowHandler.is_jmp_raw(state, c.line) ? FinalSetCondition.Type.REGISTER : FinalSetCondition.Type.VALUE;
                }
                if (b.cond == b.finalset) {
                    ControlFlowHandler.remove_branch(state, b);
                } else {
                    SetBlock block = new SetBlock(state.function, b.cond, b.target, b.line, b.targetFirst, b.targetSecond, state.r);
                    blocks.add(block);
                    ControlFlowHandler.remove_branch(state, b);
                }
            }
            b = b.next;
        }
    }

    private static Block enclosing_block(State state, int line) {
        Block enclosing = null;
        for (Block block : state.blocks) {
            if (!block.contains(line) || enclosing != null && !enclosing.contains(block)) continue;
            enclosing = block;
        }
        return enclosing;
    }

    private static Block enclosing_breakable_block(State state, int line) {
        Block enclosing = null;
        for (Block block : state.blocks) {
            if (!block.contains(line) || !block.breakable() || enclosing != null && !enclosing.contains(block)) continue;
            enclosing = block;
        }
        return enclosing;
    }

    private static Block enclosing_unprotected_block(State state, int line) {
        Block enclosing = null;
        for (Block block : state.blocks) {
            if (!block.contains(line) || !block.isUnprotected() || enclosing != null && !enclosing.contains(block)) continue;
            enclosing = block;
        }
        return enclosing;
    }

    private static void find_pseudo_goto_statements(State state, Declaration[] declList) {
        Branch b = state.begin_branch;
        while (b != null) {
            if (b.type == Branch.Type.jump && b.targetFirst > b.line) {
                int end = b.targetFirst;
                Block smallestEnclosing = null;
                for (Block block : state.blocks) {
                    if (!block.contains(b.line) || !block.contains(end - 1) || smallestEnclosing != null && !smallestEnclosing.contains(block)) continue;
                    smallestEnclosing = block;
                }
                if (smallestEnclosing != null) {
                    Block wrapping = null;
                    for (Block block : state.blocks) {
                        if (block == smallestEnclosing || !smallestEnclosing.contains(block) || !block.contains(b.line) || wrapping != null && !block.contains(wrapping)) continue;
                        wrapping = block;
                    }
                    int begin = smallestEnclosing.begin;
                    if (wrapping != null) {
                        begin = Math.max(wrapping.begin - 1, smallestEnclosing.begin);
                    }
                    int lowerBound = Integer.MIN_VALUE;
                    int upperBound = Integer.MAX_VALUE;
                    int scopeAdjust = -1;
                    Declaration[] declarationArray = declList;
                    int n = declList.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Declaration decl = declarationArray[n2];
                        if (decl.end >= begin && decl.end <= end + -1 && decl.begin < begin) {
                            upperBound = Math.min(decl.begin, upperBound);
                        }
                        if (decl.begin >= begin && decl.begin <= end + -1 && decl.end > end + -1) {
                            lowerBound = Math.max(decl.begin + 1, lowerBound);
                            begin = decl.begin + 1;
                        }
                        ++n2;
                    }
                    if (lowerBound > upperBound) {
                        throw new IllegalStateException();
                    }
                    begin = Math.max(lowerBound, begin);
                    begin = Math.min(upperBound, begin);
                    Block breakable = ControlFlowHandler.enclosing_breakable_block(state, b.line);
                    if (breakable != null) {
                        begin = Math.max(breakable.begin, begin);
                    }
                    boolean containsBreak = false;
                    OnceLoop loop = new OnceLoop(state.function, begin, end);
                    for (Block block : state.blocks) {
                        if (!loop.contains(block) || !(block instanceof Break)) continue;
                        containsBreak = true;
                        break;
                    }
                    if (containsBreak) {
                        state.blocks.add(new IfThenElseBlock(state.function, FixedCondition.TRUE, begin, b.line + 1, end, CloseType.NONE, -1));
                        state.blocks.add(new ElseEndBlock(state.function, b.line + 1, end, CloseType.NONE, -1));
                        ControlFlowHandler.remove_branch(state, b);
                    } else {
                        state.blocks.add(loop);
                        Branch b2 = b;
                        while (b2 != null) {
                            if (b2.type == Branch.Type.jump && b2.targetFirst > b2.line && b2.targetFirst == b.targetFirst) {
                                Break breakStatement = new Break(state.function, b2.line, b2.targetFirst);
                                state.blocks.add(breakStatement);
                                breakStatement.comment = "pseudo-goto";
                                ControlFlowHandler.remove_branch(state, b2);
                                if (b.next == b2) {
                                    b = b2;
                                }
                            }
                            b2 = b2.next;
                        }
                    }
                }
            }
            b = b.next;
        }
    }

    private static void find_do_blocks(State state, Declaration[] declList) {
        ArrayList<DoEndBlock> newBlocks = new ArrayList<DoEndBlock>();
        for (Block block : state.blocks) {
            int closeLine;
            Block enclosing;
            if (!block.hasCloseLine() || block.getCloseLine() < 1 || (enclosing = ControlFlowHandler.enclosing_block(state, closeLine = block.getCloseLine())) != block && !enclosing.contains(block) || !ControlFlowHandler.is_close(state, closeLine)) continue;
            int register = ControlFlowHandler.get_close_value(state, closeLine);
            boolean close = true;
            Declaration closeDecl = null;
            Declaration[] declarationArray = declList;
            int n = declList.length;
            int n2 = 0;
            while (n2 < n) {
                Declaration decl = declarationArray[n2];
                if (!decl.forLoop && !decl.forLoopExplicit && block.contains(decl.begin)) {
                    if (decl.register < register) {
                        close = false;
                    } else if (decl.register == register) {
                        closeDecl = decl;
                    }
                }
                ++n2;
            }
            if (close) {
                block.useClose();
                continue;
            }
            if (closeDecl == null) continue;
            DoEndBlock inner = new DoEndBlock(state.function, closeDecl.begin, closeDecl.end + 1);
            inner.closeRegister = register;
            newBlocks.add(inner);
            ControlFlowHandler.strictScopeCheck(state);
        }
        state.blocks.addAll(newBlocks);
        Declaration[] declarationArray = declList;
        int n = declList.length;
        int n3 = 0;
        while (n3 < n) {
            Declaration decl = declarationArray[n3];
            int begin = decl.begin;
            if (!decl.forLoop && !decl.forLoopExplicit) {
                boolean needsDoEnd = true;
                for (Block block : state.blocks) {
                    if (!block.contains(decl.begin)) continue;
                    if (block.scopeEnd() == decl.end) {
                        block.useScope();
                        needsDoEnd = false;
                        break;
                    }
                    if (block.scopeEnd() >= decl.end) continue;
                    begin = Math.min(begin, block.begin);
                }
                if (needsDoEnd) {
                    state.blocks.add(new DoEndBlock(state.function, begin, decl.end + 1));
                    ControlFlowHandler.strictScopeCheck(state);
                }
            }
            ++n3;
        }
    }

    private static void strictScopeCheck(State state) {
        if (state.function.header.config.strict_scope) {
            throw new RuntimeException("Violation of strict scope rule");
        }
    }

    private static boolean is_conditional(Branch b) {
        return b.type == Branch.Type.comparison || b.type == Branch.Type.test;
    }

    private static boolean is_assignment(Branch b) {
        return b.type == Branch.Type.testset;
    }

    private static boolean is_assignment(Branch b, int r) {
        return b.type == Branch.Type.testset || b.type == Branch.Type.test && b.target == r;
    }

    private static boolean adjacent(State state, Branch branch0, Branch branch1) {
        boolean adjacent;
        if (branch1.finalset != null && branch0.finalset == branch1.finalset) {
            return true;
        }
        if (branch0 == null || branch1 == null) {
            return false;
        }
        boolean bl = adjacent = branch0.targetFirst <= branch1.line;
        if (adjacent) {
            adjacent = !ControlFlowHandler.has_statement(state, branch0.targetFirst, branch1.line - 1);
            adjacent = adjacent && !state.reverse_targets[branch1.line];
        }
        return adjacent;
    }

    private static Branch combine_left(State state, Branch branch1) {
        if (ControlFlowHandler.is_conditional(branch1)) {
            return ControlFlowHandler.combine_conditional(state, branch1);
        }
        if (ControlFlowHandler.is_assignment(branch1) || branch1.type == Branch.Type.finalset) {
            return ControlFlowHandler.combine_assignment(state, branch1);
        }
        return branch1;
    }

    private static Branch combine_conditional(State state, Branch branch1) {
        Branch branch0 = branch1.previous;
        Branch branchn = branch1;
        while (branch0 != null && branch0.line > branch1.line) {
            branch0 = branch0.previous;
        }
        while (branch0 != null && branchn == branch1 && ControlFlowHandler.adjacent(state, branch0, branch1)) {
            branchn = ControlFlowHandler.combine_conditional_helper(state, branch0, branch1);
            if (branch0.targetSecond > branch1.targetFirst) break;
            branch0 = branch0.previous;
        }
        return branchn;
    }

    private static Branch combine_conditional_helper(State state, Branch branch0, Branch branch1) {
        if (ControlFlowHandler.is_conditional(branch0) && ControlFlowHandler.is_conditional(branch1)) {
            int branch0TargetSecond = branch0.targetSecond;
            if (ControlFlowHandler.is_jmp(state, branch1.targetFirst) && state.code.target(branch1.targetFirst) == branch0TargetSecond) {
                branch0TargetSecond = branch1.targetFirst;
            }
            if (branch0TargetSecond == branch1.targetFirst) {
                branch0 = ControlFlowHandler.combine_conditional(state, branch0);
                OrCondition c = new OrCondition(branch0.cond.inverse(), branch1.cond);
                Branch branchn = new Branch(branch0.line, branch1.line2, Branch.Type.comparison, c, branch1.targetFirst, branch1.targetSecond, branch1.finalset);
                branchn.inverseValue = branch1.inverseValue;
                if (verbose) {
                    System.err.println("conditional or " + branchn.line);
                }
                ControlFlowHandler.replace_branch(state, branch0, branch1, branchn);
                return ControlFlowHandler.combine_conditional(state, branchn);
            }
            if (branch0TargetSecond == branch1.targetSecond) {
                branch0 = ControlFlowHandler.combine_conditional(state, branch0);
                AndCondition c = new AndCondition(branch0.cond, branch1.cond);
                Branch branchn = new Branch(branch0.line, branch1.line2, Branch.Type.comparison, c, branch1.targetFirst, branch1.targetSecond, branch1.finalset);
                branchn.inverseValue = branch1.inverseValue;
                if (verbose) {
                    System.err.println("conditional and " + branchn.line);
                }
                ControlFlowHandler.replace_branch(state, branch0, branch1, branchn);
                return ControlFlowHandler.combine_conditional(state, branchn);
            }
        }
        return branch1;
    }

    private static Branch combine_assignment(State state, Branch branch1) {
        Branch branch0 = branch1.previous;
        Branch branchn = branch1;
        while (branch0 != null && branchn == branch1) {
            branchn = ControlFlowHandler.combine_assignment_helper(state, branch0, branch1);
            if (branch1.cond != branch1.finalset && branch0.cond != branch0.finalset && branch0.targetSecond > branch1.targetFirst) break;
            branch0 = branch0.previous;
        }
        return branchn;
    }

    private static Branch combine_assignment_helper(State state, Branch branch0, Branch branch1) {
        if (ControlFlowHandler.adjacent(state, branch0, branch1)) {
            int register = branch1.target;
            if (branch1.target == -1) {
                throw new IllegalStateException();
            }
            if (ControlFlowHandler.is_conditional(branch0) && ControlFlowHandler.is_assignment(branch1)) {
                if (branch0.targetSecond == branch1.targetFirst) {
                    boolean inverse = branch0.inverseValue;
                    if (verbose) {
                        System.err.println("bridge " + (inverse ? "or" : "and") + " " + branch1.line + " " + branch0.line);
                    }
                    branch0 = ControlFlowHandler.combine_conditional(state, branch0);
                    if (inverse != branch0.inverseValue) {
                        throw new IllegalStateException();
                    }
                    Condition c = !branch1.inverseValue ? new OrCondition(branch0.cond.inverse(), branch1.cond) : new AndCondition(branch0.cond, branch1.cond);
                    Branch branchn = new Branch(branch0.line, branch1.line2, branch1.type, c, branch1.targetFirst, branch1.targetSecond, branch1.finalset);
                    branchn.inverseValue = branch1.inverseValue;
                    branchn.target = register;
                    ControlFlowHandler.replace_branch(state, branch0, branch1, branchn);
                    return ControlFlowHandler.combine_assignment(state, branchn);
                }
                int cfr_ignored_0 = branch0.targetSecond;
                int cfr_ignored_1 = branch1.targetSecond;
            }
            if (ControlFlowHandler.is_assignment(branch0, register) && ControlFlowHandler.is_assignment(branch1) && branch0.inverseValue == branch1.inverseValue && branch0.targetSecond == branch1.targetSecond) {
                if (verbose) {
                    System.err.println("assign " + (branch0.inverseValue ? "or" : "and") + " " + branch1.line + " " + branch0.line);
                }
                if (ControlFlowHandler.is_conditional(branch0)) {
                    branch0 = ControlFlowHandler.combine_conditional(state, branch0);
                    if (branch0.inverseValue) {
                        branch0.cond = branch0.cond.inverse();
                    }
                } else {
                    boolean inverse = branch0.inverseValue;
                    branch0 = ControlFlowHandler.combine_assignment(state, branch0);
                    if (inverse != branch0.inverseValue) {
                        throw new IllegalStateException();
                    }
                }
                Condition c = branch0.inverseValue ? new OrCondition(branch0.cond, branch1.cond) : new AndCondition(branch0.cond, branch1.cond);
                Branch branchn = new Branch(branch0.line, branch1.line2, branch1.type, c, branch1.targetFirst, branch1.targetSecond, branch1.finalset);
                branchn.inverseValue = branch1.inverseValue;
                branchn.target = register;
                ControlFlowHandler.replace_branch(state, branch0, branch1, branchn);
                return ControlFlowHandler.combine_assignment(state, branchn);
            }
            if (ControlFlowHandler.is_assignment(branch0, register) && branch1.type == Branch.Type.finalset && branch0.targetSecond == branch1.targetSecond) {
                if (branch0.finalset != null && branch0.finalset != branch1.finalset) {
                    Branch b = branch0.next;
                    while (b != null) {
                        if (b.cond == branch0.finalset) {
                            ControlFlowHandler.remove_branch(state, b);
                            break;
                        }
                        b = b.next;
                    }
                }
                if (ControlFlowHandler.is_conditional(branch0)) {
                    branch0 = ControlFlowHandler.combine_conditional(state, branch0);
                    if (branch0.inverseValue) {
                        branch0.cond = branch0.cond.inverse();
                    }
                } else {
                    boolean inverse = branch0.inverseValue;
                    branch0 = ControlFlowHandler.combine_assignment(state, branch0);
                    if (inverse != branch0.inverseValue) {
                        throw new IllegalStateException();
                    }
                }
                if (verbose) {
                    System.err.println("final assign " + (branch0.inverseValue ? "or" : "and") + " " + branch1.line + " " + branch0.line);
                }
                Condition c = branch0.inverseValue ? new OrCondition(branch0.cond, branch1.cond) : new AndCondition(branch0.cond, branch1.cond);
                Branch branchn = new Branch(branch0.line, branch1.line2, Branch.Type.finalset, c, branch1.targetFirst, branch1.targetSecond, branch1.finalset);
                branchn.target = register;
                ControlFlowHandler.replace_branch(state, branch0, branch1, branchn);
                return ControlFlowHandler.combine_assignment(state, branchn);
            }
        }
        return branch1;
    }

    private static void raw_add_branch(State state, Branch b) {
        if (b.type == Branch.Type.finalset) {
            List<Branch> list = state.finalsetbranches.get(b.line);
            if (list == null) {
                list = new LinkedList<Branch>();
                state.finalsetbranches.set(b.line, list);
            }
            list.add(b);
        } else if (b.type == Branch.Type.testset) {
            state.setbranches[b.line] = b;
        } else {
            state.branches[b.line] = b;
        }
    }

    private static void raw_remove_branch(State state, Branch b) {
        if (b.type == Branch.Type.finalset) {
            List<Branch> list = state.finalsetbranches.get(b.line);
            if (list == null) {
                throw new IllegalStateException();
            }
            list.remove(b);
        } else if (b.type == Branch.Type.testset) {
            state.setbranches[b.line] = null;
        } else {
            state.branches[b.line] = null;
        }
    }

    private static void replace_branch(State state, Branch branch0, Branch branch1, Branch branchn) {
        ControlFlowHandler.remove_branch(state, branch0);
        ControlFlowHandler.raw_remove_branch(state, branch1);
        branchn.previous = branch1.previous;
        if (branchn.previous == null) {
            state.begin_branch = branchn;
        } else {
            branchn.previous.next = branchn;
        }
        branchn.next = branch1.next;
        if (branchn.next == null) {
            state.end_branch = branchn;
        } else {
            branchn.next.previous = branchn;
        }
        ControlFlowHandler.raw_add_branch(state, branchn);
    }

    private static void remove_branch(State state, Branch b) {
        ControlFlowHandler.raw_remove_branch(state, b);
        Branch prev = b.previous;
        Branch next = b.next;
        if (prev != null) {
            prev.next = next;
        } else {
            state.begin_branch = next;
        }
        if (next != null) {
            next.previous = prev;
        } else {
            state.end_branch = prev;
        }
    }

    private static void insert_branch(State state, Branch b) {
        ControlFlowHandler.raw_add_branch(state, b);
    }

    private static void link_branches(State state) {
        Branch previous = null;
        int index = 0;
        while (index < state.branches.length) {
            int array = 0;
            while (array < 3) {
                if (array == 0) {
                    List<Branch> list = state.finalsetbranches.get(index);
                    if (list != null) {
                        for (Branch b : list) {
                            b.previous = previous;
                            if (previous != null) {
                                previous.next = b;
                            } else {
                                state.begin_branch = b;
                            }
                            previous = b;
                        }
                    }
                } else {
                    Branch b;
                    Branch[] branches = array == 1 ? state.setbranches : state.branches;
                    b = branches[index];
                    if (b != null) {
                        b.previous = previous;
                        if (previous != null) {
                            previous.next = b;
                        } else {
                            state.begin_branch = b;
                        }
                        previous = b;
                    }
                }
                ++array;
            }
            ++index;
        }
        state.end_branch = previous;
    }

    private static boolean is_jmp_raw(State state, int line) {
        Op op = state.code.op(line);
        return op == Op.JMP || op == Op.JMP52 || op == Op.JMP54;
    }

    private static boolean is_jmp(State state, int line) {
        Code code = state.code;
        Op op = code.op(line);
        if (op == Op.JMP || op == Op.JMP54) {
            return true;
        }
        if (op == Op.JMP52) {
            return !ControlFlowHandler.is_close(state, line);
        }
        return false;
    }

    private static boolean is_close(State state, int line) {
        Code code = state.code;
        Op op = code.op(line);
        if (op == Op.CLOSE) {
            return true;
        }
        if (op == Op.JMP52) {
            int target = code.target(line);
            if (target == line + 1) {
                return code.A(line) != 0;
            }
            if (line + 1 <= code.length && code.op(line + 1) == Op.JMP52) {
                return target == code.target(line + 1) && code.A(line) != 0;
            }
            return false;
        }
        return false;
    }

    private static int get_close_value(State state, int line) {
        Code code = state.code;
        Op op = code.op(line);
        if (op == Op.CLOSE) {
            return code.A(line);
        }
        if (op == Op.JMP52) {
            return code.A(line) - 1;
        }
        throw new IllegalStateException();
    }

    private static CloseType get_close_type(State state, int line) {
        if (line < 1 || !ControlFlowHandler.is_close(state, line)) {
            return CloseType.NONE;
        }
        Op op = state.code.op(line);
        if (op == Op.CLOSE) {
            return state.function.header.version.closesemantics.get() == Version.CloseSemantics.LUA54 ? CloseType.CLOSE54 : CloseType.CLOSE;
        }
        return CloseType.JMP;
    }

    private static boolean has_statement(State state, int begin, int end) {
        int line = begin;
        while (line <= end) {
            if (ControlFlowHandler.is_statement(state, line)) {
                return true;
            }
            ++line;
        }
        return state.d.hasStatement(begin, end);
    }

    private static boolean is_statement(State state, int line) {
        if (state.reverse_targets[line]) {
            return true;
        }
        Registers r = state.r;
        if (!r.getNewLocals(line).isEmpty()) {
            return true;
        }
        Code code = state.code;
        if (code.isUpvalueDeclaration(line)) {
            return false;
        }
        switch (code.op(line)) {
            case MOVE: 
            case LOADK: 
            case LOADBOOL: 
            case GETUPVAL: 
            case GETGLOBAL: 
            case GETTABLE: 
            case NEWTABLE: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case POW: 
            case UNM: 
            case NOT: 
            case LEN: 
            case CONCAT: 
            case TESTSET: 
            case CLOSURE: 
            case LOADKX: 
            case GETTABUP: 
            case NEWTABLE50: 
            case IDIV: 
            case BAND: 
            case BOR: 
            case BXOR: 
            case SHL: 
            case SHR: 
            case BNOT: 
            case LOADI: 
            case LOADF: 
            case LOADFALSE: 
            case LFALSESKIP: 
            case LOADTRUE: 
            case GETTABUP54: 
            case GETTABLE54: 
            case GETI: 
            case GETFIELD: 
            case NEWTABLE54: 
            case CONCAT54: 
            case TESTSET54: {
                return r.isLocal(code.A(line), line);
            }
            case ADDI: 
            case ADDK: 
            case SUBK: 
            case MULK: 
            case MODK: 
            case POWK: 
            case DIVK: 
            case IDIVK: 
            case BANDK: 
            case BORK: 
            case BXORK: 
            case SHRI: 
            case SHLI: 
            case ADD54: 
            case SUB54: 
            case MUL54: 
            case MOD54: 
            case POW54: 
            case DIV54: 
            case IDIV54: 
            case BAND54: 
            case BOR54: 
            case BXOR54: 
            case SHL54: 
            case SHR54: {
                return false;
            }
            case MMBIN: 
            case MMBINI: 
            case MMBINK: {
                if (line <= 1) {
                    throw new IllegalStateException();
                }
                return r.isLocal(code.A(line - 1), line - 1);
            }
            case LOADNIL: {
                int register = code.A(line);
                while (register <= code.B(line)) {
                    if (r.isLocal(register, line)) {
                        return true;
                    }
                    ++register;
                }
                return false;
            }
            case LOADNIL52: {
                int register = code.A(line);
                while (register <= code.A(line) + code.B(line)) {
                    if (r.isLocal(register, line)) {
                        return true;
                    }
                    ++register;
                }
                return false;
            }
            case SETGLOBAL: 
            case SETUPVAL: 
            case TAILCALL: 
            case RETURN: 
            case FORLOOP: 
            case FORPREP: 
            case TFORLOOP: 
            case CLOSE: 
            case SETTABUP: 
            case TFORCALL: 
            case TFORLOOP52: 
            case TFORPREP: 
            case SETTABUP54: 
            case TBC: 
            case TAILCALL54: 
            case RETURN54: 
            case RETURN0: 
            case RETURN1: 
            case FORLOOP54: 
            case FORPREP54: 
            case TFORPREP54: 
            case TFORCALL54: 
            case TFORLOOP54: {
                return true;
            }
            case TEST50: {
                return code.A(line) != code.B(line) && r.isLocal(code.A(line), line);
            }
            case SELF: 
            case SELF54: {
                return r.isLocal(code.A(line), line) || r.isLocal(code.A(line) + 1, line);
            }
            case EQ: 
            case LT: 
            case LE: 
            case TEST: 
            case SETLIST: 
            case SETLIST52: 
            case EXTRAARG: 
            case SETLIST50: 
            case SETLISTO: 
            case EQ54: 
            case LT54: 
            case LE54: 
            case EQK: 
            case EQI: 
            case LTI: 
            case LEI: 
            case GTI: 
            case GEI: 
            case TEST54: 
            case SETLIST54: 
            case VARARGPREP: 
            case EXTRABYTE: {
                return false;
            }
            case JMP: 
            case JMP52: 
            case JMP54: {
                Op next;
                if (line == 1) {
                    return true;
                }
                Op prev = line >= 2 ? code.op(line - 1) : null;
                Op op = next = line + 1 <= code.length ? code.op(line + 1) : null;
                if (prev == Op.EQ) {
                    return false;
                }
                if (prev == Op.LT) {
                    return false;
                }
                if (prev == Op.LE) {
                    return false;
                }
                if (prev == Op.EQ54) {
                    return false;
                }
                if (prev == Op.LT54) {
                    return false;
                }
                if (prev == Op.LE54) {
                    return false;
                }
                if (prev == Op.EQK) {
                    return false;
                }
                if (prev == Op.EQI) {
                    return false;
                }
                if (prev == Op.LTI) {
                    return false;
                }
                if (prev == Op.LEI) {
                    return false;
                }
                if (prev == Op.GTI) {
                    return false;
                }
                if (prev == Op.GEI) {
                    return false;
                }
                if (prev == Op.TEST50) {
                    return false;
                }
                if (prev == Op.TEST) {
                    return false;
                }
                if (prev == Op.TEST54) {
                    return false;
                }
                if (prev == Op.TESTSET) {
                    return false;
                }
                if (prev == Op.TESTSET54) {
                    return false;
                }
                if (next == Op.LOADBOOL && code.C(line + 1) != 0) {
                    return false;
                }
                return next != Op.LFALSESKIP;
            }
            case CALL: {
                int a = code.A(line);
                int c = code.C(line);
                if (c == 1) {
                    return true;
                }
                if (c == 0) {
                    c = r.registers - a + 1;
                }
                int register = a;
                while (register < a + c - 1) {
                    if (r.isLocal(register, line)) {
                        return true;
                    }
                    ++register;
                }
                return false;
            }
            case VARARG: {
                int a = code.A(line);
                int b = code.B(line);
                if (b == 0) {
                    b = r.registers - a + 1;
                }
                int register = a;
                while (register < a + b - 1) {
                    if (r.isLocal(register, line)) {
                        return true;
                    }
                    ++register;
                }
                return false;
            }
            case VARARG54: {
                int a = code.A(line);
                int c = code.C(line);
                if (c == 0) {
                    c = r.registers - a + 1;
                }
                int register = a;
                while (register < a + c - 1) {
                    if (r.isLocal(register, line)) {
                        return true;
                    }
                    ++register;
                }
                return false;
            }
            case SETTABLE: 
            case SETTABLE54: 
            case SETI: 
            case SETFIELD: {
                return false;
            }
            case DEFAULT: 
            case DEFAULT54: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException("Illegal opcode: " + (Object)((Object)code.op(line)));
    }

    private ControlFlowHandler() {
    }

    private static class Branch
    implements Comparable<Branch> {
        public Branch previous;
        public Branch next;
        public int line;
        public int line2;
        public int target;
        public Type type;
        public Condition cond;
        public int targetFirst;
        public int targetSecond;
        public boolean inverseValue;
        public FinalSetCondition finalset;

        public Branch(int line, int line2, Type type, Condition cond, int targetFirst, int targetSecond, FinalSetCondition finalset) {
            this.line = line;
            this.line2 = line2;
            this.type = type;
            this.cond = cond;
            this.targetFirst = targetFirst;
            this.targetSecond = targetSecond;
            this.inverseValue = false;
            this.target = -1;
            this.finalset = finalset;
        }

        @Override
        public int compareTo(Branch other) {
            return this.line - other.line;
        }

        private static enum Type {
            comparison,
            test,
            testset,
            finalset,
            jump;

        }
    }

    public static class Result {
        public List<Block> blocks;
        public boolean[] labels;

        public Result(State state) {
            this.blocks = state.blocks;
            this.labels = state.labels;
        }
    }

    private static class State {
        public Decompiler d;
        public LFunction function;
        public Registers r;
        public Code code;
        public Branch begin_branch;
        public Branch end_branch;
        public Branch[] branches;
        public Branch[] setbranches;
        public ArrayList<List<Branch>> finalsetbranches;
        public boolean[] reverse_targets;
        public int[] resolved;
        public boolean[] labels;
        public List<Block> blocks;

        private State() {
        }
    }
}

