/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import unluac.Configuration;
import unluac.Version;
import unluac.decompile.Code;
import unluac.decompile.ControlFlowHandler;
import unluac.decompile.Declaration;
import unluac.decompile.Function;
import unluac.decompile.Op;
import unluac.decompile.Output;
import unluac.decompile.OutputProvider;
import unluac.decompile.Registers;
import unluac.decompile.Upvalues;
import unluac.decompile.VariableFinder;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.block.DoEndBlock;
import unluac.decompile.expression.ClosureExpression;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.expression.Expression;
import unluac.decompile.expression.FunctionCall;
import unluac.decompile.expression.TableLiteral;
import unluac.decompile.expression.TableReference;
import unluac.decompile.expression.Vararg;
import unluac.decompile.operation.CallOperation;
import unluac.decompile.operation.GlobalSet;
import unluac.decompile.operation.LoadNil;
import unluac.decompile.operation.MultipleRegisterSet;
import unluac.decompile.operation.Operation;
import unluac.decompile.operation.RegisterSet;
import unluac.decompile.operation.ReturnOperation;
import unluac.decompile.operation.TableSet;
import unluac.decompile.operation.UpvalueSet;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Label;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.GlobalTarget;
import unluac.decompile.target.TableTarget;
import unluac.decompile.target.Target;
import unluac.decompile.target.UpvalueTarget;
import unluac.decompile.target.VariableTarget;
import unluac.parse.LFunction;
import unluac.parse.LUpvalue;
import unluac.util.Stack;

public class Decompiler {
    public final LFunction function;
    public final Code code;
    public final Declaration[] declList;
    private final int registers;
    private final int length;
    private final Upvalues upvalues;
    private final Function f;
    private final LFunction[] functions;
    private final int params;
    private final int vararg;

    public Decompiler(LFunction function) {
        this(function, null, -1);
    }

    public Decompiler(LFunction function, Declaration[] parentDecls, int line) {
        this.f = new Function(function);
        this.function = function;
        this.registers = function.maximumStackSize;
        this.length = function.code.length;
        this.code = new Code(function);
        if (function.stripped || this.getConfiguration().variable == Configuration.VariableMode.NODEBUG) {
            if (this.getConfiguration().variable == Configuration.VariableMode.FINDER) {
                this.declList = VariableFinder.process(this, function.numParams, function.maximumStackSize);
            } else {
                this.declList = new Declaration[function.maximumStackSize];
                int scopeEnd = this.length + function.header.version.outerblockscopeadjustment.get();
                int i = 0;
                while (i < Math.min(function.numParams, function.maximumStackSize)) {
                    this.declList[i] = new Declaration("A" + i + "_" + function.level, 0, scopeEnd);
                    ++i;
                }
                if (this.getVersion().varargtype.get() != Version.VarArgType.ELLIPSIS && (function.vararg & 1) != 0 && i < function.maximumStackSize) {
                    this.declList[i++] = new Declaration("arg", 0, scopeEnd);
                }
                while (i < function.maximumStackSize) {
                    this.declList[i] = new Declaration("L" + i + "_" + function.level, 0, scopeEnd);
                    ++i;
                }
            }
        } else if (function.locals.length >= function.numParams) {
            this.declList = new Declaration[function.locals.length];
            int i = 0;
            while (i < this.declList.length) {
                this.declList[i] = new Declaration(function.locals[i], this.code);
                ++i;
            }
        } else {
            this.declList = new Declaration[function.numParams];
            int i = 0;
            while (i < this.declList.length) {
                this.declList[i] = new Declaration("_ARG_" + i + "_", 0, this.length - 1);
                ++i;
            }
        }
        this.upvalues = new Upvalues(function, parentDecls, line);
        this.functions = function.functions;
        this.params = function.numParams;
        this.vararg = function.vararg;
    }

    public Configuration getConfiguration() {
        return this.function.header.config;
    }

    public Version getVersion() {
        return this.function.header.version;
    }

    public boolean getNoDebug() {
        return this.function.header.config.variable == Configuration.VariableMode.NODEBUG || this.function.stripped && this.function.header.config.variable == Configuration.VariableMode.DEFAULT;
    }

    public State decompile() {
        State state = new State();
        state.r = new Registers(this.registers, this.length, this.declList, this.f, this.getNoDebug());
        ControlFlowHandler.Result result = ControlFlowHandler.process(this, state.r);
        List<Block> blocks = result.blocks;
        state.outer = blocks.get(0);
        state.labels = result.labels;
        this.processSequence(state, blocks, 1, this.code.length);
        for (Block block : blocks) {
            block.resolve(state.r);
        }
        this.handleUnusedConstants(state.outer);
        return state;
    }

    public void print(State state) {
        this.print(state, new Output());
    }

    public void print(State state, OutputProvider out) {
        this.print(state, new Output(out));
    }

    public void print(State state, Output out) {
        this.handleInitialDeclares(out);
        state.outer.print(this, out);
    }

    private void handleUnusedConstants(Block outer) {
        final HashSet unusedConstants = new HashSet(this.function.constants.length);
        outer.walk(new Walker(){
            private int nextConstant = 0;

            @Override
            public void visitExpression(Expression expression) {
                int index;
                if (expression.isConstant() && (index = expression.getConstantIndex()) >= 0) {
                    while (index > this.nextConstant) {
                        unusedConstants.add(this.nextConstant++);
                    }
                    if (index == this.nextConstant) {
                        ++this.nextConstant;
                    }
                }
            }
        });
        outer.walk(new Walker(){
            private int nextConstant = 0;

            @Override
            public void visitStatement(Statement statement) {
                if (unusedConstants.contains(this.nextConstant) && statement.useConstant(Decompiler.this.f, this.nextConstant)) {
                    ++this.nextConstant;
                }
            }

            @Override
            public void visitExpression(Expression expression) {
                int index;
                if (expression.isConstant() && (index = expression.getConstantIndex()) >= this.nextConstant) {
                    this.nextConstant = index + 1;
                }
            }
        });
    }

    private void handleInitialDeclares(Output out) {
        ArrayList<Declaration> initdecls = new ArrayList<Declaration>(this.declList.length);
        int initdeclcount = this.params;
        switch (this.getVersion().varargtype.get()) {
            case ARG: 
            case HYBRID: {
                initdeclcount += this.vararg & 1;
                break;
            }
        }
        int i = initdeclcount;
        while (i < this.declList.length) {
            if (this.declList[i].begin == 0) {
                initdecls.add(this.declList[i]);
            }
            ++i;
        }
        if (initdecls.size() > 0) {
            out.print("local ");
            out.print(((Declaration)initdecls.get((int)0)).name);
            i = 1;
            while (i < initdecls.size()) {
                out.print(", ");
                out.print(((Declaration)initdecls.get((int)i)).name);
                ++i;
            }
            out.println();
        }
    }

    private int fb2int50(int fb) {
        return (fb & 7) << (fb >> 3);
    }

    private int fb2int(int fb) {
        int exponent = fb >> 3 & 0x1F;
        if (exponent == 0) {
            return fb;
        }
        return (fb & 7) + 8 << exponent - 1;
    }

    private Expression.BinaryOperation decodeBinOp(int tm) {
        switch (tm) {
            case 6: {
                return Expression.BinaryOperation.ADD;
            }
            case 7: {
                return Expression.BinaryOperation.SUB;
            }
            case 8: {
                return Expression.BinaryOperation.MUL;
            }
            case 9: {
                return Expression.BinaryOperation.MOD;
            }
            case 10: {
                return Expression.BinaryOperation.POW;
            }
            case 11: {
                return Expression.BinaryOperation.DIV;
            }
            case 12: {
                return Expression.BinaryOperation.IDIV;
            }
            case 13: {
                return Expression.BinaryOperation.BAND;
            }
            case 14: {
                return Expression.BinaryOperation.BOR;
            }
            case 15: {
                return Expression.BinaryOperation.BXOR;
            }
            case 16: {
                return Expression.BinaryOperation.SHL;
            }
            case 17: {
                return Expression.BinaryOperation.SHR;
            }
        }
        throw new IllegalStateException();
    }

    private void handle50BinOp(List<Operation> operations, State state, int line, Expression.BinaryOperation op) {
        operations.add(new RegisterSet(line, this.code.A(line), Expression.make(op, state.r.getKExpression(this.code.B(line), line), state.r.getKExpression(this.code.C(line), line))));
    }

    private void handle54BinOp(List<Operation> operations, State state, int line, Expression.BinaryOperation op) {
        operations.add(new RegisterSet(line, this.code.A(line), Expression.make(op, state.r.getExpression(this.code.B(line), line), state.r.getExpression(this.code.C(line), line))));
    }

    private void handle54BinKOp(List<Operation> operations, State state, int line, Expression.BinaryOperation op) {
        if (line + 1 > this.code.length || this.code.op(line + 1) != Op.MMBINK) {
            throw new IllegalStateException();
        }
        Expression left = state.r.getExpression(this.code.B(line), line);
        Expression right = this.f.getConstantExpression(this.code.C(line));
        if (this.code.k(line + 1)) {
            Expression temp = left;
            left = right;
            right = temp;
        }
        operations.add(new RegisterSet(line, this.code.A(line), Expression.make(op, left, right)));
    }

    private void handleUnaryOp(List<Operation> operations, State state, int line, Expression.UnaryOperation op) {
        operations.add(new RegisterSet(line, this.code.A(line), Expression.make(op, state.r.getExpression(this.code.B(line), line))));
    }

    private void handleSetList(List<Operation> operations, State state, int line, int stack, int count, int offset) {
        Expression table = state.r.getValue(stack, line);
        int i = 1;
        while (i <= count) {
            operations.add(new TableSet(line, table, ConstantExpression.createInteger(offset + i), state.r.getExpression(stack + i, line), false, state.r.getUpdated(stack + i, line)));
            ++i;
        }
    }

    private List<Operation> processLine(State state, int line) {
        Registers r = state.r;
        boolean[] skip = state.skip;
        LinkedList<Operation> operations = new LinkedList<Operation>();
        int A = this.code.A(line);
        int B = this.code.B(line);
        int C = this.code.C(line);
        int Bx = this.code.Bx(line);
        switch (this.code.op(line)) {
            case MOVE: {
                operations.add(new RegisterSet(line, A, r.getExpression(B, line)));
                break;
            }
            case LOADI: {
                operations.add(new RegisterSet(line, A, ConstantExpression.createInteger(this.code.sBx(line))));
                break;
            }
            case LOADF: {
                operations.add(new RegisterSet(line, A, ConstantExpression.createDouble(this.code.sBx(line))));
                break;
            }
            case LOADK: {
                operations.add(new RegisterSet(line, A, this.f.getConstantExpression(Bx)));
                break;
            }
            case LOADKX: {
                if (line + 1 > this.code.length || this.code.op(line + 1) != Op.EXTRAARG) {
                    throw new IllegalStateException();
                }
                operations.add(new RegisterSet(line, A, this.f.getConstantExpression(this.code.Ax(line + 1))));
                break;
            }
            case LOADBOOL: {
                operations.add(new RegisterSet(line, A, ConstantExpression.createBoolean(B != 0)));
                break;
            }
            case LOADFALSE: 
            case LFALSESKIP: {
                operations.add(new RegisterSet(line, A, ConstantExpression.createBoolean(false)));
                break;
            }
            case LOADTRUE: {
                operations.add(new RegisterSet(line, A, ConstantExpression.createBoolean(true)));
                break;
            }
            case LOADNIL: {
                operations.add(new LoadNil(line, A, B));
                break;
            }
            case LOADNIL52: {
                operations.add(new LoadNil(line, A, A + B));
                break;
            }
            case GETGLOBAL: {
                operations.add(new RegisterSet(line, A, this.f.getGlobalExpression(Bx)));
                break;
            }
            case SETGLOBAL: {
                operations.add(new GlobalSet(line, this.f.getGlobalName(Bx), r.getExpression(A, line)));
                break;
            }
            case GETUPVAL: {
                operations.add(new RegisterSet(line, A, this.upvalues.getExpression(B)));
                break;
            }
            case SETUPVAL: {
                operations.add(new UpvalueSet(line, this.upvalues.getName(B), r.getExpression(A, line)));
                break;
            }
            case GETTABUP: {
                operations.add(new RegisterSet(line, A, new TableReference(this.upvalues.getExpression(B), r.getKExpression(C, line))));
                break;
            }
            case GETTABUP54: {
                operations.add(new RegisterSet(line, A, new TableReference(this.upvalues.getExpression(B), this.f.getConstantExpression(C))));
                break;
            }
            case GETTABLE: {
                operations.add(new RegisterSet(line, A, new TableReference(r.getExpression(B, line), r.getKExpression(C, line))));
                break;
            }
            case GETTABLE54: {
                operations.add(new RegisterSet(line, A, new TableReference(r.getExpression(B, line), r.getExpression(C, line))));
                break;
            }
            case GETI: {
                operations.add(new RegisterSet(line, A, new TableReference(r.getExpression(B, line), ConstantExpression.createInteger(C))));
                break;
            }
            case GETFIELD: {
                operations.add(new RegisterSet(line, A, new TableReference(r.getExpression(B, line), this.f.getConstantExpression(C))));
                break;
            }
            case SETTABLE: {
                operations.add(new TableSet(line, r.getExpression(A, line), r.getKExpression(B, line), r.getKExpression(C, line), true, line));
                break;
            }
            case SETTABLE54: {
                operations.add(new TableSet(line, r.getExpression(A, line), r.getExpression(B, line), r.getKExpression54(C, this.code.k(line), line), true, line));
                break;
            }
            case SETI: {
                operations.add(new TableSet(line, r.getExpression(A, line), ConstantExpression.createInteger(B), r.getKExpression54(C, this.code.k(line), line), true, line));
                break;
            }
            case SETFIELD: {
                operations.add(new TableSet(line, r.getExpression(A, line), this.f.getConstantExpression(B), r.getKExpression54(C, this.code.k(line), line), true, line));
                break;
            }
            case SETTABUP: {
                operations.add(new TableSet(line, this.upvalues.getExpression(A), r.getKExpression(B, line), r.getKExpression(C, line), true, line));
                break;
            }
            case SETTABUP54: {
                operations.add(new TableSet(line, this.upvalues.getExpression(A), this.f.getConstantExpression(B), r.getKExpression54(C, this.code.k(line), line), true, line));
                break;
            }
            case NEWTABLE50: {
                operations.add(new RegisterSet(line, A, new TableLiteral(this.fb2int50(B), C == 0 ? 0 : 1 << C)));
                break;
            }
            case NEWTABLE: {
                operations.add(new RegisterSet(line, A, new TableLiteral(this.fb2int(B), this.fb2int(C))));
                break;
            }
            case NEWTABLE54: {
                if (this.code.op(line + 1) != Op.EXTRAARG) {
                    throw new IllegalStateException();
                }
                int arraySize = C;
                if (this.code.k(line)) {
                    arraySize += this.code.Ax(line + 1) * (this.code.getExtractor().C.max() + 1);
                }
                operations.add(new RegisterSet(line, A, new TableLiteral(arraySize, B == 0 ? 0 : 1 << B - 1)));
                break;
            }
            case SELF: {
                Expression common = r.getExpression(B, line);
                operations.add(new RegisterSet(line, A + 1, common));
                operations.add(new RegisterSet(line, A, new TableReference(common, r.getKExpression(C, line))));
                break;
            }
            case SELF54: {
                Expression common = r.getExpression(B, line);
                operations.add(new RegisterSet(line, A + 1, common));
                operations.add(new RegisterSet(line, A, new TableReference(common, r.getKExpression54(C, this.code.k(line), line))));
                break;
            }
            case ADD: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.ADD);
                break;
            }
            case SUB: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.SUB);
                break;
            }
            case MUL: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.MUL);
                break;
            }
            case DIV: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.DIV);
                break;
            }
            case IDIV: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.IDIV);
                break;
            }
            case MOD: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.MOD);
                break;
            }
            case POW: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.POW);
                break;
            }
            case BAND: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.BAND);
                break;
            }
            case BOR: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.BOR);
                break;
            }
            case BXOR: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.BXOR);
                break;
            }
            case SHL: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.SHL);
                break;
            }
            case SHR: {
                this.handle50BinOp(operations, state, line, Expression.BinaryOperation.SHR);
                break;
            }
            case ADD54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.ADD);
                break;
            }
            case SUB54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.SUB);
                break;
            }
            case MUL54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.MUL);
                break;
            }
            case DIV54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.DIV);
                break;
            }
            case IDIV54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.IDIV);
                break;
            }
            case MOD54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.MOD);
                break;
            }
            case POW54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.POW);
                break;
            }
            case BAND54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.BAND);
                break;
            }
            case BOR54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.BOR);
                break;
            }
            case BXOR54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.BXOR);
                break;
            }
            case SHL54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.SHL);
                break;
            }
            case SHR54: {
                this.handle54BinOp(operations, state, line, Expression.BinaryOperation.SHR);
                break;
            }
            case ADDI: {
                if (line + 1 > this.code.length || this.code.op(line + 1) != Op.MMBINI) {
                    throw new IllegalStateException();
                }
                Expression.BinaryOperation op = this.decodeBinOp(this.code.C(line + 1));
                int immediate = this.code.sC(line);
                boolean swap = false;
                if (this.code.k(line + 1)) {
                    if (op != Expression.BinaryOperation.ADD) {
                        throw new IllegalStateException();
                    }
                    swap = true;
                } else if (op != Expression.BinaryOperation.ADD) {
                    if (op == Expression.BinaryOperation.SUB) {
                        immediate = -immediate;
                    } else {
                        throw new IllegalStateException();
                    }
                }
                Expression left = r.getExpression(B, line);
                Expression right = ConstantExpression.createInteger(immediate);
                if (swap) {
                    Expression temp = left;
                    left = right;
                    right = temp;
                }
                operations.add(new RegisterSet(line, A, Expression.make(op, left, right)));
                break;
            }
            case ADDK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.ADD);
                break;
            }
            case SUBK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.SUB);
                break;
            }
            case MULK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.MUL);
                break;
            }
            case DIVK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.DIV);
                break;
            }
            case IDIVK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.IDIV);
                break;
            }
            case MODK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.MOD);
                break;
            }
            case POWK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.POW);
                break;
            }
            case BANDK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.BAND);
                break;
            }
            case BORK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.BOR);
                break;
            }
            case BXORK: {
                this.handle54BinKOp(operations, state, line, Expression.BinaryOperation.BXOR);
                break;
            }
            case SHRI: {
                if (line + 1 > this.code.length || this.code.op(line + 1) != Op.MMBINI) {
                    throw new IllegalStateException();
                }
                int immediate = this.code.sC(line);
                Expression.BinaryOperation op = this.decodeBinOp(this.code.C(line + 1));
                if (op != Expression.BinaryOperation.SHR) {
                    if (op == Expression.BinaryOperation.SHL) {
                        immediate = -immediate;
                    } else {
                        throw new IllegalStateException();
                    }
                }
                operations.add(new RegisterSet(line, A, Expression.make(op, r.getExpression(B, line), ConstantExpression.createInteger(immediate))));
                break;
            }
            case SHLI: {
                operations.add(new RegisterSet(line, A, Expression.make(Expression.BinaryOperation.SHL, ConstantExpression.createInteger(this.code.sC(line)), r.getExpression(B, line))));
                break;
            }
            case MMBIN: 
            case MMBINI: 
            case MMBINK: {
                break;
            }
            case UNM: {
                this.handleUnaryOp(operations, state, line, Expression.UnaryOperation.UNM);
                break;
            }
            case NOT: {
                this.handleUnaryOp(operations, state, line, Expression.UnaryOperation.NOT);
                break;
            }
            case LEN: {
                this.handleUnaryOp(operations, state, line, Expression.UnaryOperation.LEN);
                break;
            }
            case BNOT: {
                this.handleUnaryOp(operations, state, line, Expression.UnaryOperation.BNOT);
                break;
            }
            case CONCAT: {
                Expression value = r.getExpression(C, line);
                while (C-- > B) {
                    value = Expression.make(Expression.BinaryOperation.CONCAT, r.getExpression(C, line), value);
                }
                operations.add(new RegisterSet(line, A, value));
                break;
            }
            case CONCAT54: {
                if (B < 2) {
                    throw new IllegalStateException();
                }
                Expression value = r.getExpression(A + --B, line);
                while (B-- > 0) {
                    value = Expression.make(Expression.BinaryOperation.CONCAT, r.getExpression(A + B, line), value);
                }
                operations.add(new RegisterSet(line, A, value));
                break;
            }
            case JMP: 
            case EQ: 
            case LT: 
            case LE: 
            case TEST: 
            case JMP52: 
            case JMP54: 
            case EQ54: 
            case LT54: 
            case LE54: 
            case EQK: 
            case EQI: 
            case LTI: 
            case LEI: 
            case GTI: 
            case GEI: 
            case TEST54: {
                break;
            }
            case TEST50: {
                if (!this.getNoDebug() || A == B) break;
                operations.add(new RegisterSet(line, A, Expression.make(Expression.BinaryOperation.OR, r.getExpression(B, line), this.initialExpression(state, A, line))));
                break;
            }
            case TESTSET: 
            case TESTSET54: {
                if (!this.getNoDebug()) break;
                operations.add(new RegisterSet(line, A, Expression.make(Expression.BinaryOperation.OR, r.getExpression(B, line), this.initialExpression(state, A, line))));
                break;
            }
            case CALL: {
                boolean multiple;
                boolean bl = multiple = C >= 3 || C == 0;
                if (B == 0) {
                    B = this.registers - A;
                }
                if (C == 0) {
                    C = this.registers - A + 1;
                }
                Expression function = r.getExpression(A, line);
                Expression[] arguments = new Expression[B - 1];
                int register = A + 1;
                while (register <= A + B - 1) {
                    arguments[register - A - 1] = r.getExpression(register, line);
                    ++register;
                }
                FunctionCall value = new FunctionCall(function, arguments, multiple);
                if (C == 1) {
                    operations.add(new CallOperation(line, value));
                    break;
                }
                if (C == 2 && !multiple) {
                    operations.add(new RegisterSet(line, A, value));
                    break;
                }
                operations.add(new MultipleRegisterSet(line, A, A + C - 2, value));
                break;
            }
            case TAILCALL: 
            case TAILCALL54: {
                if (B == 0) {
                    B = this.registers - A;
                }
                Expression function = r.getExpression(A, line);
                Expression[] arguments = new Expression[B - 1];
                int register = A + 1;
                while (register <= A + B - 1) {
                    arguments[register - A - 1] = r.getExpression(register, line);
                    ++register;
                }
                FunctionCall value = new FunctionCall(function, arguments, true);
                operations.add(new ReturnOperation(line, value));
                skip[line + 1] = true;
                break;
            }
            case RETURN: 
            case RETURN54: {
                if (B == 0) {
                    B = this.registers - A + 1;
                }
                Expression[] values = new Expression[B - 1];
                int register = A;
                while (register <= A + B - 2) {
                    values[register - A] = r.getExpression(register, line);
                    ++register;
                }
                operations.add(new ReturnOperation(line, values));
                break;
            }
            case RETURN0: {
                operations.add(new ReturnOperation(line, new Expression[0]));
                break;
            }
            case RETURN1: {
                operations.add(new ReturnOperation(line, new Expression[]{r.getExpression(A, line)}));
                break;
            }
            case FORLOOP: 
            case FORPREP: 
            case TFORLOOP: 
            case TFORCALL: 
            case TFORLOOP52: 
            case TFORPREP: 
            case FORLOOP54: 
            case FORPREP54: 
            case TFORPREP54: 
            case TFORCALL54: 
            case TFORLOOP54: {
                break;
            }
            case SETLIST50: {
                this.handleSetList(operations, state, line, A, 1 + Bx % 32, Bx - Bx % 32);
                break;
            }
            case SETLISTO: {
                this.handleSetList(operations, state, line, A, this.registers - A - 1, Bx - Bx % 32);
                break;
            }
            case SETLIST: {
                if (C == 0) {
                    C = this.code.codepoint(line + 1);
                    skip[line + 1] = true;
                }
                if (B == 0) {
                    B = this.registers - A - 1;
                }
                this.handleSetList(operations, state, line, A, B, (C - 1) * 50);
                break;
            }
            case SETLIST52: {
                if (C == 0) {
                    if (line + 1 > this.code.length || this.code.op(line + 1) != Op.EXTRAARG) {
                        throw new IllegalStateException();
                    }
                    C = this.code.Ax(line + 1);
                    skip[line + 1] = true;
                }
                if (B == 0) {
                    B = this.registers - A - 1;
                }
                this.handleSetList(operations, state, line, A, B, (C - 1) * 50);
                break;
            }
            case SETLIST54: {
                if (this.code.k(line)) {
                    if (line + 1 > this.code.length || this.code.op(line + 1) != Op.EXTRAARG) {
                        throw new IllegalStateException();
                    }
                    C += this.code.Ax(line + 1) * (this.code.getExtractor().C.max() + 1);
                    skip[line + 1] = true;
                }
                if (B == 0) {
                    B = this.registers - A - 1;
                }
                this.handleSetList(operations, state, line, A, B, C);
                break;
            }
            case TBC: {
                r.getDeclaration((int)A, (int)line).tbc = true;
                break;
            }
            case CLOSE: {
                break;
            }
            case CLOSURE: {
                LFunction f = this.functions[Bx];
                operations.add(new RegisterSet(line, A, new ClosureExpression(f, line + 1)));
                if (this.function.header.version.upvaluedeclarationtype.get() != Version.UpvalueDeclarationType.INLINE) break;
                int i = 0;
                while (i < f.numUpvalues) {
                    LUpvalue upvalue = f.upvalues[i];
                    switch (this.code.op(line + 1 + i)) {
                        case MOVE: {
                            upvalue.instack = true;
                            break;
                        }
                        case GETUPVAL: {
                            upvalue.instack = false;
                            break;
                        }
                        default: {
                            throw new IllegalStateException();
                        }
                    }
                    upvalue.idx = this.code.B(line + 1 + i);
                    skip[line + 1 + i] = true;
                    ++i;
                }
                break;
            }
            case VARARGPREP: {
                break;
            }
            case VARARG: {
                boolean multiple;
                boolean bl = multiple = B != 2;
                if (B == 1) {
                    throw new IllegalStateException();
                }
                if (B == 0) {
                    B = this.registers - A + 1;
                }
                Vararg value = new Vararg(B - 1, multiple);
                operations.add(new MultipleRegisterSet(line, A, A + B - 2, value));
                break;
            }
            case VARARG54: {
                boolean multiple;
                boolean bl = multiple = C != 2;
                if (C == 1) {
                    throw new IllegalStateException();
                }
                if (C == 0) {
                    C = this.registers - A + 1;
                }
                Vararg value = new Vararg(C - 1, multiple);
                operations.add(new MultipleRegisterSet(line, A, A + C - 2, value));
                break;
            }
            case EXTRAARG: 
            case EXTRABYTE: {
                break;
            }
            case DEFAULT: 
            case DEFAULT54: {
                throw new IllegalStateException();
            }
        }
        return operations;
    }

    private Expression initialExpression(State state, int register, int line) {
        if (line == 1) {
            if (register < this.function.numParams) {
                throw new IllegalStateException();
            }
            return ConstantExpression.createNil(line);
        }
        return state.r.getExpression(register, line - 1);
    }

    private Assignment processOperation(State state, Operation operation, int line, int nextLine, Block block) {
        Registers r = state.r;
        boolean[] skip = state.skip;
        Assignment assign = null;
        List<Statement> stmts = operation.process(r, block);
        if (stmts.size() == 1) {
            Statement stmt = stmts.get(0);
            if (stmt instanceof Assignment) {
                assign = (Assignment)stmt;
            }
            if (assign != null) {
                boolean declare = false;
                for (Declaration newLocal : r.getNewLocals(line, block.closeRegister)) {
                    if (!assign.getFirstTarget().isDeclaration(newLocal)) continue;
                    declare = true;
                    break;
                }
                while (!declare && nextLine < block.end) {
                    Op op = this.code.op(nextLine);
                    if (this.isMoveIntoTarget(r, nextLine)) {
                        Target target = this.getMoveIntoTargetTarget(r, nextLine, line + 1);
                        Expression value = this.getMoveIntoTargetValue(r, nextLine, line + 1);
                        assign.addFirst(target, value, nextLine);
                        skip[nextLine] = true;
                        ++nextLine;
                        continue;
                    }
                    if (op != Op.MMBIN && op != Op.MMBINI && op != Op.MMBINK && !this.code.isUpvalueDeclaration(nextLine)) break;
                    ++nextLine;
                }
            }
        }
        for (Statement stmt : stmts) {
            block.addStatement(stmt);
        }
        return assign;
    }

    public boolean hasStatement(int begin, int end) {
        if (begin <= end) {
            State state = new State();
            state.r = new Registers(this.registers, this.length, this.declList, this.f, this.getNoDebug());
            state.outer = new DoEndBlock(this.function, begin, end + 1);
            state.labels = new boolean[this.code.length + 1];
            List<Block> blocks = Arrays.asList(state.outer);
            this.processSequence(state, blocks, begin, end);
            return !state.outer.isEmpty();
        }
        return false;
    }

    private void processSequence(State state, List<Block> blocks, int begin, int end) {
        Registers r = state.r;
        int blockContainerIndex = 0;
        int blockStatementIndex = 0;
        ArrayList<Block> blockContainers = new ArrayList<Block>(blocks.size());
        ArrayList<Block> blockStatements = new ArrayList<Block>(blocks.size());
        for (Block block : blocks) {
            if (block.isContainer()) {
                blockContainers.add(block);
                continue;
            }
            blockStatements.add(block);
        }
        Stack<Block> blockStack = new Stack<Block>();
        blockStack.push((Block)blockContainers.get(blockContainerIndex++));
        state.skip = new boolean[this.code.length + 1];
        boolean[] skip = state.skip;
        boolean[] labels_handled = new boolean[this.code.length + 1];
        int line = 1;
        while (true) {
            int nextline = line;
            List<Operation> operations = null;
            List<Declaration> prevLocals = null;
            List<Declaration> newLocals = null;
            if (((Block)blockStack.peek()).end <= line) {
                Block endingBlock = (Block)blockStack.pop();
                Operation operation = endingBlock.process(this);
                if (blockStack.isEmpty()) {
                    return;
                }
                if (operation == null) {
                    throw new IllegalStateException();
                }
                operations = Arrays.asList(operation);
                prevLocals = r.getNewLocals(line - 1);
            } else {
                if (!labels_handled[line] && state.labels[line]) {
                    ((Block)blockStack.peek()).addStatement(new Label(line));
                    labels_handled[line] = true;
                }
                List<Declaration> locals = r.getNewLocals(line, ((Block)blockStack.peek()).closeRegister);
                while (blockContainerIndex < blockContainers.size() && ((Block)blockContainers.get((int)blockContainerIndex)).begin <= line) {
                    Block next = (Block)blockContainers.get(blockContainerIndex++);
                    if (!locals.isEmpty() && next.allowsPreDeclare() && (locals.get((int)0).end > next.scopeEnd() || locals.get((int)0).register < next.closeRegister)) {
                        Assignment declaration = new Assignment();
                        int declareEnd = locals.get((int)0).end;
                        declaration.declare(locals.get((int)0).begin);
                        while (!(locals.isEmpty() || locals.get((int)0).end != declareEnd || next.closeRegister != -1 && locals.get((int)0).register >= next.closeRegister)) {
                            Declaration decl = locals.get(0);
                            declaration.addLast(new VariableTarget(decl), ConstantExpression.createNil(line), line);
                            locals.remove(0);
                        }
                        ((Block)blockStack.peek()).addStatement(declaration);
                    }
                    blockStack.push(next);
                }
            }
            Block block = (Block)blockStack.peek();
            r.startLine(line);
            if (operations == null) {
                if (blockStatementIndex < blockStatements.size() && ((Block)blockStatements.get((int)blockStatementIndex)).begin <= line) {
                    Block blockStatement = (Block)blockStatements.get(blockStatementIndex++);
                    Operation operation = blockStatement.process(this);
                    operations = Arrays.asList(operation);
                } else {
                    nextline = line + 1;
                    operations = !skip[line] && line >= begin && line <= end ? this.processLine(state, line) : Collections.emptyList();
                    if (line >= begin && line <= end) {
                        newLocals = r.getNewLocals(line, block.closeRegister);
                    }
                }
            }
            Assignment assignment = null;
            for (Operation operation : operations) {
                Assignment operationAssignment = this.processOperation(state, operation, line, nextline, block);
                if (operationAssignment == null) continue;
                assignment = operationAssignment;
            }
            List<Declaration> locals = newLocals;
            if (assignment != null && prevLocals != null) {
                locals = prevLocals;
            }
            if (locals != null && !locals.isEmpty()) {
                int scopeEnd = -1;
                if (assignment == null) {
                    assignment = new Assignment();
                    block.addStatement(assignment);
                } else {
                    for (Declaration decl : locals) {
                        if (!assignment.assigns(decl)) continue;
                        scopeEnd = decl.end;
                        break;
                    }
                }
                assignment.declare(locals.get((int)0).begin);
                for (Declaration decl : locals) {
                    if (scopeEnd != -1 && decl.end != scopeEnd || decl.register < block.closeRegister) continue;
                    assignment.addLast(new VariableTarget(decl), r.getValue(decl.register, line + 1), r.getUpdated(decl.register, line - 1));
                }
            }
            line = nextline;
        }
    }

    private boolean isMoveIntoTarget(Registers r, int line) {
        if (this.code.isUpvalueDeclaration(line)) {
            return false;
        }
        switch (this.code.op(line)) {
            case MOVE: {
                return r.isAssignable(this.code.A(line), line) && !r.isLocal(this.code.B(line), line);
            }
            case SETGLOBAL: 
            case SETUPVAL: {
                return !r.isLocal(this.code.A(line), line);
            }
            case SETTABLE: 
            case SETTABUP: {
                int C = this.code.C(line);
                if (this.f.isConstant(C)) {
                    return false;
                }
                return !r.isLocal(C, line);
            }
            case SETTABUP54: 
            case SETTABLE54: 
            case SETI: 
            case SETFIELD: {
                if (this.code.k(line)) {
                    return false;
                }
                return !r.isLocal(this.code.C(line), line);
            }
        }
        return false;
    }

    private Target getMoveIntoTargetTarget(Registers r, int line, int previous) {
        switch (this.code.op(line)) {
            case MOVE: {
                return r.getTarget(this.code.A(line), line);
            }
            case SETUPVAL: {
                return new UpvalueTarget(this.upvalues.getName(this.code.B(line)));
            }
            case SETGLOBAL: {
                return new GlobalTarget(this.f.getGlobalName(this.code.Bx(line)));
            }
            case SETTABLE: {
                return new TableTarget(r.getExpression(this.code.A(line), previous), r.getKExpression(this.code.B(line), previous));
            }
            case SETTABLE54: {
                return new TableTarget(r.getExpression(this.code.A(line), previous), r.getExpression(this.code.B(line), previous));
            }
            case SETI: {
                return new TableTarget(r.getExpression(this.code.A(line), previous), ConstantExpression.createInteger(this.code.B(line)));
            }
            case SETFIELD: {
                return new TableTarget(r.getExpression(this.code.A(line), previous), this.f.getConstantExpression(this.code.B(line)));
            }
            case SETTABUP: {
                int A = this.code.A(line);
                int B = this.code.B(line);
                return new TableTarget(this.upvalues.getExpression(A), r.getKExpression(B, previous));
            }
            case SETTABUP54: {
                int A = this.code.A(line);
                int B = this.code.B(line);
                return new TableTarget(this.upvalues.getExpression(A), this.f.getConstantExpression(B));
            }
        }
        throw new IllegalStateException();
    }

    private Expression getMoveIntoTargetValue(Registers r, int line, int previous) {
        int A = this.code.A(line);
        int B = this.code.B(line);
        int C = this.code.C(line);
        switch (this.code.op(line)) {
            case MOVE: {
                return r.getValue(B, previous);
            }
            case SETGLOBAL: 
            case SETUPVAL: {
                return r.getExpression(A, previous);
            }
            case SETTABLE: 
            case SETTABUP: {
                if (this.f.isConstant(C)) {
                    throw new IllegalStateException();
                }
                return r.getExpression(C, previous);
            }
            case SETTABUP54: 
            case SETTABLE54: 
            case SETI: 
            case SETFIELD: {
                if (this.code.k(line)) {
                    throw new IllegalStateException();
                }
                return r.getExpression(C, previous);
            }
        }
        throw new IllegalStateException();
    }

    public static class State {
        private Registers r;
        private boolean[] skip;
        private Block outer;
        private boolean[] labels;
    }
}

