/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.assemble.Directive;
import unluac.decompile.Code;
import unluac.decompile.Op;
import unluac.decompile.OpcodeMap;
import unluac.decompile.Output;
import unluac.parse.LAbsLineInfo;
import unluac.parse.LFunction;
import unluac.parse.LLocal;
import unluac.parse.LUpvalue;
import unluac.util.StringUtils;

public class Disassembler {
    private final LFunction function;
    private final Code code;
    private final String name;
    private final String parent;

    public Disassembler(LFunction function) {
        this(function, "main", null);
    }

    private Disassembler(LFunction function, String name, String parent) {
        this.function = function;
        this.code = new Code(function);
        this.name = name;
        this.parent = parent;
    }

    public void disassemble(Output out) {
        this.disassemble(out, 0, 0);
    }

    private void disassemble(Output out, int level, int index) {
        if (this.parent == null) {
            out.println(".version\t" + this.function.header.version.getName());
            out.println();
            for (Directive directive : this.function.header.lheader_type.get_directives()) {
                directive.disassemble(out, this.function.header, this.function.header.lheader);
            }
            out.println();
            if (this.function.header.opmap != this.function.header.version.getOpcodeMap()) {
                OpcodeMap opmap = this.function.header.opmap;
                int opcode = 0;
                while (opcode < opmap.size()) {
                    Object op = opmap.get(opcode);
                    if (op != null) {
                        out.println(String.valueOf(Directive.OP.token) + "\t" + opcode + "\t" + ((Op)((Object)op)).name);
                    }
                    ++opcode;
                }
                out.println();
            }
        }
        String fullname = this.parent == null ? this.name : String.valueOf(this.parent) + "/" + this.name;
        out.println(".function\t" + fullname);
        out.println();
        for (Directive directive : this.function.header.function.get_directives()) {
            directive.disassemble(out, this.function.header, this.function);
        }
        out.println();
        if (this.function.locals.length > 0) {
            int local = 1;
            while (local <= this.function.locals.length) {
                LLocal l = this.function.locals[local - 1];
                out.println(".local\t" + l.name.toPrintString() + "\t" + l.start + "\t" + l.end);
                ++local;
            }
            out.println();
        }
        if (this.function.upvalues.length > 0) {
            int upvalue = 1;
            while (upvalue <= this.function.upvalues.length) {
                LUpvalue u = this.function.upvalues[upvalue - 1];
                out.println(".upvalue\t" + StringUtils.toPrintString(u.name) + "\t" + u.idx + "\t" + u.instack);
                ++upvalue;
            }
            out.println();
        }
        if (this.function.constants.length > 0) {
            int constant = 1;
            while (constant <= this.function.constants.length) {
                out.println(".constant\tk" + (constant - 1) + "\t" + this.function.constants[constant - 1].toPrintString());
                ++constant;
            }
            out.println();
        }
        boolean[] label = new boolean[this.function.code.length];
        int line = 1;
        while (line <= this.function.code.length) {
            int target;
            Op op = this.code.op(line);
            if (op != null && op.hasJump() && (target = this.code.target(line)) >= 1 && target <= label.length) {
                label[target - 1] = true;
            }
            ++line;
        }
        int abslineinfoindex = 0;
        int line2 = 1;
        while (line2 <= this.function.code.length) {
            int target;
            if (label[line2 - 1]) {
                out.println(".label\tl" + line2);
            }
            if (this.function.abslineinfo != null && abslineinfoindex < this.function.abslineinfo.length && this.function.abslineinfo[abslineinfoindex].pc == line2 - 1) {
                LAbsLineInfo info = this.function.abslineinfo[abslineinfoindex++];
                out.println(".abslineinfo\t" + info.pc + "\t" + info.line);
            }
            if (line2 <= this.function.lines.length) {
                out.print(".line\t" + this.function.lines[line2 - 1] + "\t");
            }
            Op op = this.code.op(line2);
            String cpLabel = null;
            if (op != null && op.hasJump() && (target = this.code.target(line2)) >= 1 && target <= this.code.length) {
                cpLabel = "l" + target;
            }
            if (op == null) {
                out.println(Op.defaultToString(this.code.codepoint(line2), this.function.header.version, this.code.getExtractor()));
            } else {
                out.println(op.codePointToString(this.code.codepoint(line2), this.code.getExtractor(), cpLabel));
            }
            ++line2;
        }
        line2 = this.function.code.length + 1;
        while (line2 <= this.function.lines.length) {
            if (this.function.abslineinfo != null && abslineinfoindex < this.function.abslineinfo.length && this.function.abslineinfo[abslineinfoindex].pc == line2 - 1) {
                LAbsLineInfo info = this.function.abslineinfo[abslineinfoindex++];
                out.println(".abslineinfo\t" + info.pc + "\t" + info.line);
            }
            out.println(".line\t" + this.function.lines[line2 - 1]);
            ++line2;
        }
        if (this.function.abslineinfo != null) {
            while (abslineinfoindex < this.function.abslineinfo.length) {
                LAbsLineInfo info = this.function.abslineinfo[abslineinfoindex++];
                out.println(".abslineinfo\t" + info.pc + "\t" + info.line);
            }
        }
        out.println();
        int subindex = 0;
        LFunction[] lFunctionArray = this.function.functions;
        int n = this.function.functions.length;
        int n2 = 0;
        while (n2 < n) {
            LFunction child = lFunctionArray[n2];
            new Disassembler(child, "f" + subindex, fullname).disassemble(out, level + 1, subindex);
            ++subindex;
            ++n2;
        }
    }
}

