/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.decompile.CodeExtract;
import unluac.decompile.Constant;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.expression.GlobalExpression;
import unluac.parse.LFunction;

public class Function {
    private Version version;
    private Constant[] constants;
    private final CodeExtract extract;

    public Function(LFunction function) {
        this.version = function.header.version;
        this.constants = new Constant[function.constants.length];
        int i = 0;
        while (i < this.constants.length) {
            this.constants[i] = new Constant(function.constants[i]);
            ++i;
        }
        this.extract = function.header.extractor;
    }

    public boolean isConstant(int register) {
        return this.extract.is_k(register);
    }

    public int constantIndex(int register) {
        return this.extract.get_k(register);
    }

    public ConstantExpression getGlobalName(int constantIndex) {
        Constant constant = this.constants[constantIndex];
        if (!constant.isIdentifierPermissive(this.version)) {
            throw new IllegalStateException();
        }
        return new ConstantExpression(constant, true, constantIndex);
    }

    public ConstantExpression getConstantExpression(int constantIndex) {
        Constant constant = this.constants[constantIndex];
        return new ConstantExpression(constant, constant.isIdentifier(this.version), constantIndex);
    }

    public GlobalExpression getGlobalExpression(int constantIndex) {
        return new GlobalExpression(this.getGlobalName(constantIndex), constantIndex);
    }

    public Version getVersion() {
        return this.version;
    }
}

