/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.Version;
import unluac.decompile.CodeExtract;
import unluac.decompile.OperandFormat;

public enum Op {
    MOVE("move", 31, OperandFormat.AR, OperandFormat.BR),
    LOADK("loadk", 31, OperandFormat.AR, OperandFormat.BxK),
    LOADBOOL("loadbool", 15, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    LOADNIL("loadnil", 3, OperandFormat.AR, OperandFormat.BR),
    GETUPVAL("getupval", 31, OperandFormat.AR, OperandFormat.BU),
    GETGLOBAL("getglobal", 3, OperandFormat.AR, OperandFormat.BxK),
    GETTABLE("gettable", 15, OperandFormat.AR, OperandFormat.BR, OperandFormat.CRK),
    SETGLOBAL("setglobal", 3, OperandFormat.AR, OperandFormat.BxK),
    SETUPVAL("setupval", 31, OperandFormat.AR, OperandFormat.BU),
    SETTABLE("settable", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    NEWTABLE("newtable", 14, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    SELF("self", 15, OperandFormat.AR, OperandFormat.BR, OperandFormat.CRK),
    ADD("add", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    SUB("sub", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    MUL("mul", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    DIV("div", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    MOD("mod", 14, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    POW("pow", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    UNM("unm", 15, OperandFormat.AR, OperandFormat.BR),
    NOT("not", 15, OperandFormat.AR, OperandFormat.BR),
    LEN("len", 14, OperandFormat.AR, OperandFormat.BR),
    CONCAT("concat", 15, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    JMP("jmp", 3, OperandFormat.sBxJ),
    EQ("eq", 15, OperandFormat.A, OperandFormat.BRK, OperandFormat.CRK),
    LT("lt", 15, OperandFormat.A, OperandFormat.BRK, OperandFormat.CRK),
    LE("le", 15, OperandFormat.A, OperandFormat.BRK, OperandFormat.CRK),
    TEST("test", 14, OperandFormat.AR, OperandFormat.C),
    TESTSET("testset", 14, OperandFormat.AR, OperandFormat.BR, OperandFormat.C),
    CALL("call", 31, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    TAILCALL("tailcall", 15, OperandFormat.AR, OperandFormat.B),
    RETURN("return", 15, OperandFormat.AR, OperandFormat.B),
    FORLOOP("forloop", 15, OperandFormat.AR, OperandFormat.sBxJ),
    FORPREP("forprep", 14, OperandFormat.AR, OperandFormat.sBxJ),
    TFORLOOP("tforloop", 3, OperandFormat.AR, OperandFormat.C),
    SETLIST("setlist", 2, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    CLOSE("close", 19, OperandFormat.AR),
    CLOSURE("closure", 31, OperandFormat.AR, OperandFormat.BxF),
    VARARG("vararg", 14, OperandFormat.AR, OperandFormat.B),
    JMP52("jmp", 12, OperandFormat.A, OperandFormat.sBxJ),
    LOADNIL52("loadnil", 28, OperandFormat.AR, OperandFormat.B),
    LOADKX("loadkx", 28, OperandFormat.AR),
    GETTABUP("gettabup", 12, OperandFormat.AR, OperandFormat.BU, OperandFormat.CRK),
    SETTABUP("settabup", 12, OperandFormat.AU, OperandFormat.BRK, OperandFormat.CRK),
    SETLIST52("setlist", 12, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    TFORCALL("tforcall", 12, OperandFormat.AR, OperandFormat.C),
    TFORLOOP52("tforloop", 12, OperandFormat.AR, OperandFormat.sBxJ),
    EXTRAARG("extraarg", 28, OperandFormat.Ax),
    NEWTABLE50("newtable", 1, OperandFormat.AR, OperandFormat.B, OperandFormat.C),
    SETLIST50("setlist", 1, OperandFormat.AR, OperandFormat.Bx),
    SETLISTO("setlisto", 1, OperandFormat.AR, OperandFormat.Bx),
    TFORPREP("tforprep", 1, OperandFormat.AR, OperandFormat.sBxJ),
    TEST50("test", 1, OperandFormat.AR, OperandFormat.BR, OperandFormat.C),
    IDIV("idiv", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    BAND("band", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    BOR("bor", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    BXOR("bxor", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    SHL("shl", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    SHR("shr", 8, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    BNOT("bnot", 24, OperandFormat.AR, OperandFormat.BR),
    LOADI("loadi", 16, OperandFormat.AR, OperandFormat.sBxI),
    LOADF("loadf", 16, OperandFormat.AR, OperandFormat.sBxF),
    LOADFALSE("loadfalse", 16, OperandFormat.AR),
    LFALSESKIP("lfalseskip", 16, OperandFormat.AR),
    LOADTRUE("loadtrue", 16, OperandFormat.AR),
    GETTABUP54("gettabup", 16, OperandFormat.AR, OperandFormat.BU, OperandFormat.CKS),
    GETTABLE54("gettable", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    GETI("geti", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CI),
    GETFIELD("getfield", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CKS),
    SETTABUP54("settabup", 16, OperandFormat.AU, OperandFormat.BK, OperandFormat.CRK54),
    SETTABLE54("settable", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CRK54),
    SETI("seti", 16, OperandFormat.AR, OperandFormat.BI, OperandFormat.CRK54),
    SETFIELD("setfield", 16, OperandFormat.AR, OperandFormat.BKS, OperandFormat.CRK54),
    NEWTABLE54("newtable", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    SELF54("self", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CRK54),
    ADDI("addi", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CsI),
    ADDK("addk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    SUBK("subk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    MULK("mulk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    MODK("modk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    POWK("powk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    DIVK("divk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    IDIVK("idivk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CK),
    BANDK("bandk", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CKI),
    BORK("bork", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CKI),
    BXORK("bxork", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CKI),
    SHRI("shri", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CsI),
    SHLI("shli", 16, OperandFormat.AR, OperandFormat.CsI, OperandFormat.BR),
    ADD54("add", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    SUB54("sub", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    MUL54("mul", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    MOD54("mod", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    POW54("pow", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    DIV54("div", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    IDIV54("idiv", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    BAND54("band", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    BOR54("bor", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    BXOR54("bxor", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    SHL54("shl", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    SHR54("shr", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.CR),
    MMBIN("mmbin", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.C),
    MMBINI("mmbini", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.C, OperandFormat.k),
    MMBINK("mmbink", 16, OperandFormat.AR, OperandFormat.BK, OperandFormat.C, OperandFormat.k),
    CONCAT54("concat", 16, OperandFormat.AR, OperandFormat.B),
    TBC("tbc", 16, OperandFormat.AR),
    JMP54("jmp", 16, OperandFormat.sJ),
    EQ54("eq", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.k),
    LT54("lt", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.k),
    LE54("le", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.k),
    EQK("eqk", 16, OperandFormat.AR, OperandFormat.BK, OperandFormat.k),
    EQI("eqi", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    LTI("lti", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    LEI("lei", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    GTI("gti", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    GEI("gei", 16, OperandFormat.AR, OperandFormat.BsI, OperandFormat.k, OperandFormat.C),
    TEST54("test", 16, OperandFormat.AR, OperandFormat.k),
    TESTSET54("testset", 16, OperandFormat.AR, OperandFormat.BR, OperandFormat.k),
    TAILCALL54("tailcall", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    RETURN54("return", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    RETURN0("return0", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    RETURN1("return1", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    FORLOOP54("forloop", 16, OperandFormat.AR, OperandFormat.BxJn),
    FORPREP54("forprep", 16, OperandFormat.AR, OperandFormat.BxJ),
    TFORPREP54("tforprep", 16, OperandFormat.AR, OperandFormat.BxJ),
    TFORCALL54("tforcall", 16, OperandFormat.AR, OperandFormat.C),
    TFORLOOP54("tforloop", 16, OperandFormat.AR, OperandFormat.BxJn),
    SETLIST54("setlist", 16, OperandFormat.AR, OperandFormat.B, OperandFormat.C, OperandFormat.k),
    VARARG54("vararg", 16, OperandFormat.AR, OperandFormat.C),
    VARARGPREP("varargprep", 16, OperandFormat.A),
    EXTRABYTE("extrabyte", 31, OperandFormat.x),
    DEFAULT("default", 0, OperandFormat.AR, OperandFormat.BRK, OperandFormat.CRK),
    DEFAULT54("default", 0, OperandFormat.AR, OperandFormat.BR, OperandFormat.C, OperandFormat.k);

    public final String name;
    public final int versions;
    public final OperandFormat[] operands;

    private Op(String name, int versions) {
        this.name = name;
        this.versions = versions;
        this.operands = new OperandFormat[0];
    }

    private Op(String name, int versions, OperandFormat f1) {
        this.name = name;
        this.versions = versions;
        this.operands = new OperandFormat[]{f1};
    }

    private Op(String name, int versions, OperandFormat f1, OperandFormat f2) {
        this.name = name;
        this.versions = versions;
        this.operands = new OperandFormat[]{f1, f2};
    }

    private Op(String name, int versions, OperandFormat f1, OperandFormat f2, OperandFormat f3) {
        this.name = name;
        this.versions = versions;
        this.operands = new OperandFormat[]{f1, f2, f3};
    }

    private Op(String name, int versions, OperandFormat f1, OperandFormat f2, OperandFormat f3, OperandFormat f4) {
        this.name = name;
        this.versions = versions;
        this.operands = new OperandFormat[]{f1, f2, f3, f4};
    }

    public boolean hasExtraByte(int codepoint, CodeExtract ex) {
        if (this == SETLIST) {
            return ex.C.extract(codepoint) == 0;
        }
        return false;
    }

    public int jumpField(int codepoint, CodeExtract ex) {
        switch (this) {
            case FORPREP54: 
            case TFORPREP54: {
                return ex.Bx.extract(codepoint);
            }
            case FORLOOP54: 
            case TFORLOOP54: {
                return -ex.Bx.extract(codepoint);
            }
            case JMP: 
            case FORLOOP: 
            case FORPREP: 
            case JMP52: 
            case TFORLOOP52: 
            case TFORPREP: {
                return ex.sBx.extract(codepoint);
            }
            case JMP54: {
                return ex.sJ.extract(codepoint);
            }
        }
        throw new IllegalStateException();
    }

    public int target(int codepoint, CodeExtract ex) {
        switch (this) {
            case MOVE: 
            case LOADK: 
            case LOADBOOL: 
            case GETUPVAL: 
            case GETGLOBAL: 
            case GETTABLE: 
            case NEWTABLE: 
            case ADD: 
            case SUB: 
            case MUL: 
            case DIV: 
            case MOD: 
            case POW: 
            case UNM: 
            case NOT: 
            case LEN: 
            case CONCAT: 
            case TESTSET: 
            case CLOSURE: 
            case LOADKX: 
            case GETTABUP: 
            case NEWTABLE50: 
            case TEST50: 
            case IDIV: 
            case BAND: 
            case BOR: 
            case BXOR: 
            case SHL: 
            case SHR: 
            case BNOT: 
            case LOADI: 
            case LOADF: 
            case LOADFALSE: 
            case LFALSESKIP: 
            case LOADTRUE: 
            case GETTABUP54: 
            case GETTABLE54: 
            case GETI: 
            case GETFIELD: 
            case NEWTABLE54: 
            case ADDI: 
            case ADDK: 
            case SUBK: 
            case MULK: 
            case MODK: 
            case POWK: 
            case DIVK: 
            case IDIVK: 
            case BANDK: 
            case BORK: 
            case BXORK: 
            case SHRI: 
            case SHLI: 
            case ADD54: 
            case SUB54: 
            case MUL54: 
            case MOD54: 
            case POW54: 
            case DIV54: 
            case IDIV54: 
            case BAND54: 
            case BOR54: 
            case BXOR54: 
            case SHL54: 
            case SHR54: 
            case CONCAT54: 
            case TESTSET54: {
                return ex.A.extract(codepoint);
            }
            case MMBIN: 
            case MMBINI: 
            case MMBINK: {
                return -1;
            }
            case LOADNIL: {
                if (ex.A.extract(codepoint) == ex.B.extract(codepoint)) {
                    return ex.A.extract(codepoint);
                }
                return -1;
            }
            case LOADNIL52: {
                if (ex.B.extract(codepoint) == 0) {
                    return ex.A.extract(codepoint);
                }
                return -1;
            }
            case SETGLOBAL: 
            case SETUPVAL: 
            case SETTABLE: 
            case SELF: 
            case JMP: 
            case EQ: 
            case LT: 
            case LE: 
            case TEST: 
            case TAILCALL: 
            case RETURN: 
            case FORLOOP: 
            case FORPREP: 
            case TFORLOOP: 
            case SETLIST: 
            case CLOSE: 
            case JMP52: 
            case SETTABUP: 
            case SETLIST52: 
            case TFORCALL: 
            case TFORLOOP52: 
            case EXTRAARG: 
            case SETLIST50: 
            case SETLISTO: 
            case TFORPREP: 
            case SETTABUP54: 
            case SETTABLE54: 
            case SETI: 
            case SETFIELD: 
            case SELF54: 
            case TBC: 
            case JMP54: 
            case EQ54: 
            case LT54: 
            case LE54: 
            case EQK: 
            case EQI: 
            case LTI: 
            case LEI: 
            case GTI: 
            case GEI: 
            case TEST54: 
            case TAILCALL54: 
            case RETURN54: 
            case RETURN0: 
            case RETURN1: 
            case FORLOOP54: 
            case FORPREP54: 
            case TFORPREP54: 
            case TFORCALL54: 
            case TFORLOOP54: 
            case SETLIST54: 
            case VARARGPREP: {
                return -1;
            }
            case CALL: {
                int a = ex.A.extract(codepoint);
                int c = ex.C.extract(codepoint);
                if (c == 2) {
                    return a;
                }
                return -1;
            }
            case VARARG: {
                int a = ex.A.extract(codepoint);
                int b = ex.B.extract(codepoint);
                if (b == 2) {
                    return a;
                }
                return -1;
            }
            case VARARG54: {
                int a = ex.A.extract(codepoint);
                int c = ex.C.extract(codepoint);
                if (c == 2) {
                    return a;
                }
                return -1;
            }
            case EXTRABYTE: {
                return -1;
            }
            case DEFAULT: 
            case DEFAULT54: {
                throw new IllegalStateException();
            }
        }
        throw new IllegalStateException(this.name());
    }

    private static String fixedOperand(int field) {
        return Integer.toString(field);
    }

    private static String registerOperand(int field) {
        return "r" + field;
    }

    private static String upvalueOperand(int field) {
        return "u" + field;
    }

    private static String constantOperand(int field) {
        return "k" + field;
    }

    private static String functionOperand(int field) {
        return "f" + field;
    }

    public boolean hasJump() {
        int i = 0;
        while (i < this.operands.length) {
            OperandFormat.Format format = this.operands[i].format;
            if (format == OperandFormat.Format.JUMP || format == OperandFormat.Format.JUMP_NEGATIVE) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String codePointToString(int codepoint, CodeExtract ex, String label) {
        return Op.toStringHelper(this.name, this.operands, codepoint, ex, label);
    }

    public static String defaultToString(int codepoint, Version version, CodeExtract ex) {
        return Op.toStringHelper(String.format("op%02d", ex.op.extract(codepoint)), version.getDefaultOp().operands, codepoint, ex, null);
    }

    private static String toStringHelper(String name, OperandFormat[] operands, int codepoint, CodeExtract ex, String label) {
        int width = 10;
        StringBuilder b = new StringBuilder();
        b.append(name);
        int i = 0;
        while (i < width - name.length()) {
            b.append(' ');
            ++i;
        }
        String[] parameters = new String[operands.length];
        int i2 = 0;
        while (i2 < operands.length) {
            CodeExtract.Field field;
            switch (operands[i2].field) {
                case A: {
                    field = ex.A;
                    break;
                }
                case B: {
                    field = ex.B;
                    break;
                }
                case C: {
                    field = ex.C;
                    break;
                }
                case k: {
                    field = ex.k;
                    break;
                }
                case Ax: {
                    field = ex.Ax;
                    break;
                }
                case sJ: {
                    field = ex.sJ;
                    break;
                }
                case Bx: {
                    field = ex.Bx;
                    break;
                }
                case sBx: {
                    field = ex.sBx;
                    break;
                }
                case x: {
                    field = ex.x;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            int x = field.extract(codepoint);
            switch (operands[i2].format) {
                case RAW: 
                case IMMEDIATE_INTEGER: 
                case IMMEDIATE_FLOAT: {
                    parameters[i2] = Op.fixedOperand(x);
                    break;
                }
                case IMMEDIATE_SIGNED_INTEGER: {
                    parameters[i2] = Op.fixedOperand(x - field.max() / 2);
                    break;
                }
                case REGISTER: {
                    parameters[i2] = Op.registerOperand(x);
                    break;
                }
                case UPVALUE: {
                    parameters[i2] = Op.upvalueOperand(x);
                    break;
                }
                case REGISTER_K: {
                    if (ex.is_k(x)) {
                        parameters[i2] = Op.constantOperand(ex.get_k(x));
                        break;
                    }
                    parameters[i2] = Op.registerOperand(x);
                    break;
                }
                case REGISTER_K54: {
                    if (ex.k.extract(codepoint) != 0) {
                        parameters[i2] = Op.constantOperand(x);
                        break;
                    }
                    parameters[i2] = Op.registerOperand(x);
                    break;
                }
                case CONSTANT: 
                case CONSTANT_INTEGER: 
                case CONSTANT_STRING: {
                    parameters[i2] = Op.constantOperand(x);
                    break;
                }
                case FUNCTION: {
                    parameters[i2] = Op.functionOperand(x);
                    break;
                }
                case JUMP: {
                    if (label != null) {
                        parameters[i2] = label;
                        break;
                    }
                    parameters[i2] = Op.fixedOperand(x + operands[i2].offset);
                    break;
                }
                case JUMP_NEGATIVE: {
                    if (label != null) {
                        parameters[i2] = label;
                        break;
                    }
                    parameters[i2] = Op.fixedOperand(-x);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ++i2;
        }
        String[] stringArray = parameters;
        int n = parameters.length;
        int n2 = 0;
        while (n2 < n) {
            String parameter = stringArray[n2];
            b.append(' ');
            int i3 = 0;
            while (i3 < 5 - parameter.length()) {
                b.append(' ');
                ++i3;
            }
            b.append(parameter);
            ++n2;
        }
        return b.toString();
    }
}

