/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import unluac.decompile.OutputProvider;

public class Output {
    private OutputProvider out;
    private int indentationLevel = 0;
    private int position = 0;

    public Output() {
        this(new OutputProvider(){

            @Override
            public void print(String s) {
                System.out.print(s);
            }

            @Override
            public void print(byte b) {
                System.out.write(b);
            }

            @Override
            public void println() {
                System.out.println();
            }
        });
    }

    public Output(OutputProvider out) {
        this.out = out;
    }

    public void indent() {
        this.indentationLevel += 2;
    }

    public void dedent() {
        this.indentationLevel -= 2;
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public int getPosition() {
        return this.position;
    }

    public void setIndentationLevel(int indentationLevel) {
        this.indentationLevel = indentationLevel;
    }

    private void start() {
        if (this.position == 0) {
            int i = this.indentationLevel;
            while (i != 0) {
                this.out.print(" ");
                ++this.position;
                --i;
            }
        }
    }

    public void print(String s) {
        this.start();
        int i = 0;
        while (i < s.length()) {
            this.out.print((byte)s.charAt(i));
            ++i;
        }
        this.position += s.length();
    }

    public void print(byte b) {
        this.start();
        this.out.print(b);
        ++this.position;
    }

    public void println() {
        this.start();
        this.out.println();
        this.position = 0;
    }

    public void println(String s) {
        this.print(s);
        this.println();
    }
}

