/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import unluac.Version;
import unluac.decompile.Declaration;
import unluac.decompile.Function;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.expression.Expression;
import unluac.decompile.expression.LocalVariable;
import unluac.decompile.target.Target;
import unluac.decompile.target.VariableTarget;

public class Registers {
    public final int registers;
    public final int length;
    private final Declaration[][] decls;
    private final Function f;
    public final boolean isNoDebug;
    private final Expression[][] values;
    private final int[][] updated;
    private boolean[] startedLines;

    public Registers(int registers, int length, Declaration[] declList, Function f, boolean isNoDebug) {
        this.registers = registers;
        this.length = length;
        this.decls = new Declaration[registers][length + 1];
        int i = 0;
        while (i < declList.length) {
            Declaration decl = declList[i];
            int register = 0;
            while (this.decls[register][decl.begin] != null) {
                ++register;
            }
            decl.register = register;
            int line = decl.begin;
            while (line <= decl.end) {
                this.decls[register][line] = decl;
                ++line;
            }
            ++i;
        }
        this.values = new Expression[registers][length + 1];
        ConstantExpression nil = ConstantExpression.createNil(0);
        int register = 0;
        while (register < registers) {
            this.values[register][0] = nil;
            ++register;
        }
        this.updated = new int[registers][length + 1];
        this.startedLines = new boolean[length + 1];
        Arrays.fill(this.startedLines, false);
        this.f = f;
        this.isNoDebug = isNoDebug;
    }

    public Function getFunction() {
        return this.f;
    }

    public boolean isAssignable(int register, int line) {
        return this.isLocal(register, line) && (!this.decls[register][line].forLoop || this.isNoDebug);
    }

    public boolean isLocal(int register, int line) {
        if (register < 0) {
            return false;
        }
        return this.decls[register][line] != null;
    }

    public boolean isNewLocal(int register, int line) {
        Declaration decl = this.decls[register][line];
        return decl != null && decl.begin == line && !decl.forLoop && !decl.forLoopExplicit;
    }

    public List<Declaration> getNewLocals(int line) {
        return this.getNewLocals(line, 0);
    }

    public List<Declaration> getNewLocals(int line, int first) {
        first = Math.max(0, first);
        ArrayList<Declaration> locals = new ArrayList<Declaration>(Math.max(this.registers - first, 0));
        int register = first;
        while (register < this.registers) {
            if (this.isNewLocal(register, line)) {
                locals.add(this.getDeclaration(register, line));
            }
            ++register;
        }
        return locals;
    }

    public Declaration getDeclaration(int register, int line) {
        return this.decls[register][line];
    }

    public void startLine(int line) {
        this.startedLines[line] = true;
        int register = 0;
        while (register < this.registers) {
            this.values[register][line] = this.values[register][line - 1];
            this.updated[register][line] = this.updated[register][line - 1];
            ++register;
        }
    }

    public boolean isKConstant(int register) {
        return this.f.isConstant(register);
    }

    public Expression getExpression(int register, int line) {
        if (this.isLocal(register, line - 1)) {
            return new LocalVariable(this.getDeclaration(register, line - 1));
        }
        return this.values[register][line - 1];
    }

    public Expression getKExpression(int register, int line) {
        if (this.f.isConstant(register)) {
            return this.f.getConstantExpression(this.f.constantIndex(register));
        }
        return this.getExpression(register, line);
    }

    public Expression getKExpression54(int register, boolean k, int line) {
        if (k) {
            return this.f.getConstantExpression(register);
        }
        return this.getExpression(register, line);
    }

    public Expression getValue(int register, int line) {
        if (this.isNoDebug) {
            return this.getExpression(register, line);
        }
        return this.values[register][line - 1];
    }

    public int getUpdated(int register, int line) {
        return this.updated[register][line];
    }

    public void setValue(int register, int line, Expression expression) {
        this.values[register][line] = expression;
        this.updated[register][line] = line;
    }

    public Target getTarget(int register, int line) {
        if (!this.isLocal(register, line)) {
            throw new IllegalStateException("No declaration exists in register " + register + " at line " + line);
        }
        return new VariableTarget(this.decls[register][line]);
    }

    public void setInternalLoopVariable(int register, int begin, int end) {
        Declaration decl = this.getDeclaration(register, begin);
        if (decl == null) {
            decl = new Declaration("_FOR_", begin, end);
            decl.register = register;
            this.newDeclaration(decl, register, begin, end);
            if (!this.isNoDebug) {
                throw new IllegalStateException("TEMP");
            }
        } else if (!(this.isNoDebug || decl.begin == begin && decl.end == end)) {
            System.err.println("given: " + begin + " " + end);
            System.err.println("expected: " + decl.begin + " " + decl.end);
            throw new IllegalStateException();
        }
        decl.forLoop = true;
    }

    public void setExplicitLoopVariable(int register, int begin, int end) {
        Declaration decl = this.getDeclaration(register, begin);
        if (decl == null) {
            decl = new Declaration("_FORV_" + register + "_", begin, end);
            decl.register = register;
            this.newDeclaration(decl, register, begin, end);
            if (!this.isNoDebug) {
                throw new IllegalStateException("TEMP");
            }
        } else if (!(this.isNoDebug || decl.begin == begin && decl.end == end)) {
            System.err.println("given: " + begin + " " + end);
            System.err.println("expected: " + decl.begin + " " + decl.end);
            throw new IllegalStateException();
        }
        decl.forLoopExplicit = true;
    }

    private void newDeclaration(Declaration decl, int register, int begin, int end) {
        int line = begin;
        while (line <= end) {
            this.decls[register][line] = decl;
            ++line;
        }
    }

    public Version getVersion() {
        return this.f.getVersion();
    }
}

