/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile;

import java.util.ArrayList;
import java.util.Iterator;
import unluac.decompile.Code;
import unluac.decompile.Declaration;
import unluac.decompile.Decompiler;
import unluac.decompile.Op;
import unluac.parse.LFunction;
import unluac.parse.LUpvalue;

public class VariableFinder {
    static int lc = 0;

    private static boolean isConstantReference(Decompiler d, int value) {
        return d.function.header.extractor.is_k(value);
    }

    public static Declaration[] process(Decompiler d, int args, int registers) {
        int register;
        Code code = d.code;
        RegisterStates states = new RegisterStates(registers, code.length());
        boolean[] skip = new boolean[code.length()];
        int line = 1;
        while (line <= code.length()) {
            states.nextLine(line);
            if (!skip[line - 1]) {
                int A = code.A(line);
                int B = code.B(line);
                int C = code.C(line);
                switch (code.op(line)) {
                    case MOVE: {
                        states.setWritten(A, line);
                        states.setRead(B, line);
                        if (A < B) {
                            states.setLocalWrite(A, A, line);
                            break;
                        }
                        if (B >= A) break;
                        states.setLocalRead(B, line);
                        break;
                    }
                    case LOADK: 
                    case LOADBOOL: 
                    case GETUPVAL: 
                    case GETGLOBAL: 
                    case NEWTABLE: 
                    case NEWTABLE50: {
                        states.setWritten(A, line);
                        break;
                    }
                    case LOADNIL: {
                        int maximum = B;
                        int register2 = code.A(line);
                        while (register2 <= maximum) {
                            states.setWritten(register2, line);
                            ++register2;
                        }
                        break;
                    }
                    case LOADNIL52: {
                        int maximum = A + B;
                        int register3 = code.A(line);
                        while (register3 <= maximum) {
                            states.setWritten(register3, line);
                            ++register3;
                        }
                        break;
                    }
                    case GETTABLE: {
                        states.setWritten(A, line);
                        if (!VariableFinder.isConstantReference(d, code.B(line))) {
                            states.setRead(B, line);
                        }
                        if (VariableFinder.isConstantReference(d, code.C(line))) break;
                        states.setRead(C, line);
                        break;
                    }
                    case SETGLOBAL: 
                    case SETUPVAL: {
                        states.setRead(A, line);
                        break;
                    }
                    case SETTABLE: 
                    case ADD: 
                    case SUB: 
                    case MUL: 
                    case DIV: 
                    case MOD: 
                    case POW: {
                        states.setWritten(A, line);
                        if (!VariableFinder.isConstantReference(d, code.B(line))) {
                            states.setRead(B, line);
                        }
                        if (VariableFinder.isConstantReference(d, code.C(line))) break;
                        states.setRead(C, line);
                        break;
                    }
                    case SELF: {
                        states.setWritten(A, line);
                        states.setWritten(A + 1, line);
                        states.setRead(B, line);
                        if (VariableFinder.isConstantReference(d, code.C(line))) break;
                        states.setRead(C, line);
                        break;
                    }
                    case UNM: 
                    case NOT: 
                    case LEN: {
                        states.get((int)code.A((int)line), (int)line).written = true;
                        states.get((int)code.B((int)line), (int)line).read = true;
                        break;
                    }
                    case CONCAT: {
                        states.setWritten(A, line);
                        int register4 = B;
                        while (register4 <= C) {
                            states.setRead(register4, line);
                            states.setTemporaryRead(register4, line);
                            ++register4;
                        }
                        break;
                    }
                    case SETLIST: {
                        states.setTemporaryRead(A + 1, line);
                        break;
                    }
                    case JMP: 
                    case JMP52: {
                        break;
                    }
                    case EQ: 
                    case LT: 
                    case LE: {
                        if (!VariableFinder.isConstantReference(d, code.B(line))) {
                            states.setRead(B, line);
                        }
                        if (VariableFinder.isConstantReference(d, code.C(line))) break;
                        states.setRead(C, line);
                        break;
                    }
                    case TEST: {
                        states.setRead(A, line);
                        break;
                    }
                    case TESTSET: {
                        states.setWritten(A, line);
                        states.setLocalWrite(A, A, line);
                        states.setRead(B, line);
                        break;
                    }
                    case CLOSURE: {
                        LFunction f = d.function.functions[code.Bx(line)];
                        LUpvalue[] lUpvalueArray = f.upvalues;
                        int n = f.upvalues.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LUpvalue upvalue = lUpvalueArray[n2];
                            if (upvalue.instack) {
                                states.setLocalRead(upvalue.idx, line);
                            }
                            ++n2;
                        }
                        states.get((int)code.A((int)line), (int)line).written = true;
                        break;
                    }
                    case CALL: 
                    case TAILCALL: {
                        if (code.op(line) != Op.TAILCALL && C >= 2) {
                            int register5 = A;
                            while (register5 <= A + C - 2) {
                                states.setWritten(register5, line);
                                ++register5;
                            }
                        }
                        int register6 = A;
                        while (register6 <= A + B - 1) {
                            states.setRead(register6, line);
                            states.setTemporaryRead(register6, line);
                            ++register6;
                        }
                        if (C < 2) break;
                        int nline = line + 1;
                        int register7 = A + C - 2;
                        while (register7 >= A && nline <= code.length()) {
                            if (code.op(nline) == Op.MOVE && code.B(nline) == register7) {
                                states.setWritten(code.A(nline), nline);
                                states.setRead(code.B(nline), nline);
                                states.setLocalWrite(code.A(nline), code.A(nline), nline);
                                skip[nline - 1] = true;
                            }
                            --register7;
                            ++nline;
                        }
                        break;
                    }
                    case RETURN: {
                        if (B == 0) {
                            B = registers - code.A(line) + 1;
                        }
                        int register8 = A;
                        while (register8 <= A + B - 2) {
                            states.get((int)register8, (int)line).read = true;
                            ++register8;
                        }
                        break;
                    }
                }
            }
            ++line;
        }
        int register9 = 0;
        while (register9 < registers) {
            states.setWritten(register9, 1);
            ++register9;
        }
        line = 1;
        while (line <= code.length()) {
            register = 0;
            while (register < registers) {
                RegisterState s = states.get(register, line);
                if (s.written && (s.read_count >= 2 || line >= 2 && s.read_count == 0)) {
                    states.setLocalWrite(register, register, line);
                }
                ++register;
            }
            ++line;
        }
        line = 1;
        while (line <= code.length()) {
            register = 0;
            while (register < registers) {
                RegisterState s = states.get(register, line);
                if (s.written && s.temporary) {
                    ArrayList<Integer> ancestors = new ArrayList<Integer>();
                    int read = 0;
                    while (read < registers) {
                        RegisterState r = states.get(read, line);
                        if (r.read && !r.local) {
                            ancestors.add(read);
                        }
                        ++read;
                    }
                    int pline = line - 1;
                    while (pline >= 1) {
                        boolean any_written = false;
                        int pregister = 0;
                        while (pregister < registers) {
                            if (states.get((int)pregister, (int)pline).written && ancestors.contains(pregister)) {
                                any_written = true;
                                ancestors.remove((Object)pregister);
                            }
                            ++pregister;
                        }
                        if (!any_written) break;
                        pregister = 0;
                        while (pregister < registers) {
                            RegisterState a = states.get(pregister, pline);
                            if (a.read && !a.local) {
                                ancestors.add(pregister);
                            }
                            ++pregister;
                        }
                        --pline;
                    }
                    Iterator pregister = ancestors.iterator();
                    while (pregister.hasNext()) {
                        int ancestor = (Integer)pregister.next();
                        if (pline < 1) continue;
                        states.setLocalRead(ancestor, pline);
                    }
                }
                ++register;
            }
            ++line;
        }
        ArrayList<Declaration> declList = new ArrayList<Declaration>(registers);
        register = 0;
        while (register < registers) {
            String id = "L";
            boolean local = false;
            boolean temporary = false;
            int read = 0;
            int written = 0;
            int start = 0;
            if (register < args) {
                local = true;
                id = "A";
            }
            boolean is_arg = false;
            if (register == args) {
                switch (d.getVersion().varargtype.get()) {
                    case ARG: 
                    case HYBRID: {
                        if ((d.function.vararg & 1) == 0) break;
                        local = true;
                        is_arg = true;
                        break;
                    }
                }
            }
            if (!local && !temporary) {
                int line2 = 1;
                while (line2 <= code.length()) {
                    RegisterState state = states.get(register, line2);
                    if (state.local) {
                        temporary = false;
                        local = true;
                    }
                    if (state.temporary) {
                        start = line2 + 1;
                        temporary = true;
                    }
                    if (state.read) {
                        written = 0;
                        ++read;
                    }
                    if (state.written) {
                        if (written > 0 && read == 0) {
                            temporary = false;
                            local = true;
                        }
                        read = 0;
                        ++written;
                    }
                    ++line2;
                }
            }
            if (!local && !temporary && (read >= 2 || read == 0 && written != 0)) {
                local = true;
            }
            if (local) {
                // empty if block
            }
            if (local) {
                String name = is_arg ? "arg" : String.valueOf(id) + register + "_" + lc++;
                Declaration decl = new Declaration(name, start, code.length() + d.getVersion().outerblockscopeadjustment.get());
                decl.register = register;
                declList.add(decl);
            }
            ++register;
        }
        return declList.toArray(new Declaration[declList.size()]);
    }

    private VariableFinder() {
    }

    static class RegisterState {
        int last_written = 1;
        int last_read = -1;
        int read_count = 0;
        boolean temporary = false;
        boolean local = false;
        boolean read = false;
        boolean written = false;
    }

    static class RegisterStates {
        private int registers;
        private int lines;
        private RegisterState[][] states;

        RegisterStates(int registers, int lines) {
            this.registers = registers;
            this.lines = lines;
            this.states = new RegisterState[lines][registers];
            int line = 0;
            while (line < lines) {
                int register = 0;
                while (register < registers) {
                    this.states[line][register] = new RegisterState();
                    ++register;
                }
                ++line;
            }
        }

        public RegisterState get(int register, int line) {
            return this.states[line - 1][register];
        }

        public void setWritten(int register, int line) {
            this.get((int)register, (int)line).written = true;
            this.get((int)register, (int)(line + 1)).last_written = line;
        }

        public void setRead(int register, int line) {
            this.get((int)register, (int)line).read = true;
            ++this.get((int)register, (int)this.get((int)register, (int)line).last_written).read_count;
            this.get((int)register, (int)this.get((int)register, (int)line).last_written).last_read = line;
        }

        public void setLocalRead(int register, int line) {
            int r = 0;
            while (r <= register) {
                this.get((int)r, (int)this.get((int)r, (int)line).last_written).local = true;
                ++r;
            }
        }

        public void setLocalWrite(int register_min, int register_max, int line) {
            int r = 0;
            while (r < register_min) {
                this.get((int)r, (int)this.get((int)r, (int)line).last_written).local = true;
                ++r;
            }
            r = register_min;
            while (r <= register_max) {
                this.get((int)r, (int)line).local = true;
                ++r;
            }
        }

        public void setTemporaryRead(int register, int line) {
            int r = register;
            while (r < this.registers) {
                this.get((int)r, (int)this.get((int)r, (int)line).last_written).temporary = true;
                ++r;
            }
        }

        public void setTemporaryWrite(int register_min, int register_max, int line) {
            int r = register_max + 1;
            while (r < this.registers) {
                this.get((int)r, (int)this.get((int)r, (int)line).last_written).temporary = true;
                ++r;
            }
            r = register_min;
            while (r <= register_max) {
                this.get((int)r, (int)line).temporary = true;
                ++r;
            }
        }

        public void nextLine(int line) {
            if (line + 1 < this.lines) {
                int r = 0;
                while (r < this.registers) {
                    if (this.get((int)r, (int)line).last_written > this.get((int)r, (int)(line + 1)).last_written) {
                        this.get((int)r, (int)(line + 1)).last_written = this.get((int)r, (int)line).last_written;
                    }
                    ++r;
                }
            }
        }
    }
}

