/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Function;
import unluac.decompile.Output;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class AlwaysLoop
extends ContainerBlock {
    private final boolean repeat;
    private ConstantExpression condition;

    public AlwaysLoop(LFunction function, int begin, int end, CloseType closeType, int closeLine, boolean repeat) {
        super(function, begin, end, closeType, closeLine, 0);
        this.repeat = repeat;
        this.condition = null;
    }

    @Override
    public int scopeEnd() {
        return this.usingClose && this.closeType == CloseType.CLOSE ? this.closeLine - 1 : this.end - 2;
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public boolean isUnprotected() {
        return true;
    }

    @Override
    public int getUnprotectedTarget() {
        return this.begin;
    }

    @Override
    public int getUnprotectedLine() {
        return this.end - 1;
    }

    @Override
    public int getLoopback() {
        return this.begin;
    }

    @Override
    public void print(Decompiler d, Output out) {
        if (this.repeat) {
            out.println("repeat");
        } else {
            out.print("while ");
            if (this.condition == null) {
                out.print("true");
            } else {
                this.condition.print(d, out);
            }
            out.println(" do");
        }
        out.indent();
        Statement.printSequence(d, out, this.statements);
        out.dedent();
        if (this.repeat) {
            out.print("until false");
        } else {
            out.print("end");
        }
    }

    @Override
    public boolean useConstant(Function f, int index) {
        if (!this.repeat && this.condition == null) {
            this.condition = f.getConstantExpression(index);
            return true;
        }
        return false;
    }
}

