/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.ArrayList;
import java.util.List;
import unluac.decompile.CloseType;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public abstract class ContainerBlock
extends Block {
    protected final List<Statement> statements;
    protected final CloseType closeType;
    protected final int closeLine;
    protected boolean usingClose;

    public ContainerBlock(LFunction function, int begin, int end, CloseType closeType, int closeLine, int priority) {
        super(function, begin, end, priority);
        this.closeType = closeType;
        this.closeLine = closeLine;
        this.usingClose = false;
        this.statements = new ArrayList<Statement>(Math.max(4, end - begin + 1));
    }

    @Override
    public void walk(Walker w) {
        w.visitStatement(this);
        for (Statement statement : this.statements) {
            statement.walk(w);
        }
    }

    @Override
    public boolean isContainer() {
        return this.begin < this.end;
    }

    @Override
    public boolean isEmpty() {
        return this.statements.isEmpty();
    }

    @Override
    public void addStatement(Statement statement) {
        this.statements.add(statement);
    }

    @Override
    public boolean hasCloseLine() {
        return this.closeType != CloseType.NONE;
    }

    @Override
    public int getCloseLine() {
        if (this.closeType == CloseType.NONE) {
            throw new IllegalStateException();
        }
        return this.closeLine;
    }

    @Override
    public void useClose() {
        this.usingClose = true;
    }
}

