/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.block.Block;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.block.IfThenElseBlock;
import unluac.decompile.block.IfThenEndBlock;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class ElseEndBlock
extends ContainerBlock {
    public IfThenElseBlock partner;

    public ElseEndBlock(LFunction function, int begin, int end, CloseType closeType, int closeLine) {
        super(function, begin, end, closeType, closeLine, -1);
    }

    @Override
    public int compareTo(Block block) {
        if (block == this.partner) {
            return 1;
        }
        int result = super.compareTo(block);
        return result;
    }

    @Override
    public boolean breakable() {
        return false;
    }

    @Override
    public int scopeEnd() {
        return this.usingClose && this.closeType == CloseType.CLOSE ? this.closeLine - 1 : super.scopeEnd();
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler d, Output out) {
        if (this.statements.size() == 1 && this.statements.get(0) instanceof IfThenEndBlock) {
            out.print("else");
            ((Statement)this.statements.get(0)).print(d, out);
        } else if (this.statements.size() == 2 && this.statements.get(0) instanceof IfThenElseBlock && this.statements.get(1) instanceof ElseEndBlock) {
            out.print("else");
            ((Statement)this.statements.get(0)).print(d, out);
            ((Statement)this.statements.get(1)).print(d, out);
        } else {
            out.print("else");
            out.println();
            out.indent();
            Statement.printSequence(d, out, this.statements);
            out.dedent();
            out.print("end");
        }
    }
}

