/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.Target;
import unluac.parse.LFunction;

public abstract class ForBlock
extends ContainerBlock {
    protected final int register;
    protected final boolean forvarClose;
    protected Target target;
    protected Expression start;
    protected Expression stop;
    protected Expression step;

    public ForBlock(LFunction function, int begin, int end, int register, CloseType closeType, int closeLine, boolean forvarClose) {
        super(function, begin, end, closeType, closeLine, -1);
        this.register = register;
        this.forvarClose = forvarClose;
    }

    public abstract void handleVariableDeclarations(Registers var1);

    @Override
    public void walk(Walker w) {
        w.visitStatement(this);
        this.start.walk(w);
        this.stop.walk(w);
        this.step.walk(w);
        for (Statement statement : this.statements) {
            statement.walk(w);
        }
    }

    @Override
    public int scopeEnd() {
        int scopeEnd = this.end - 2;
        if (this.forvarClose) {
            --scopeEnd;
        }
        if (this.usingClose && (this.closeType == CloseType.CLOSE || this.closeType == CloseType.JMP)) {
            --scopeEnd;
        }
        return scopeEnd;
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler d, Output out) {
        out.print("for ");
        this.target.print(d, out, false);
        out.print(" = ");
        this.start.print(d, out);
        out.print(", ");
        this.stop.print(d, out);
        if (!this.step.isInteger() || this.step.asInteger() != 1) {
            out.print(", ");
            this.step.print(d, out);
        }
        out.print(" do");
        out.println();
        out.indent();
        Statement.printSequence(d, out, this.statements);
        out.dedent();
        out.print("end");
    }
}

