/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.condition.AndCondition;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.FinalSetCondition;
import unluac.decompile.condition.OrCondition;
import unluac.decompile.expression.Expression;
import unluac.decompile.operation.Operation;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class IfThenEndBlock
extends ContainerBlock {
    private final Condition cond;
    private final boolean redirected;
    private final Registers r;
    private Expression condexpr;

    public IfThenEndBlock(LFunction function, Registers r, Condition cond, int begin, int end) {
        this(function, r, cond, begin, end, CloseType.NONE, -1, false);
    }

    public IfThenEndBlock(LFunction function, Registers r, Condition cond, int begin, int end, CloseType closeType, int closeLine, boolean redirected) {
        super(function, begin == end ? begin - 1 : begin, end, closeType, closeLine, -1);
        this.r = r;
        this.cond = cond;
        this.redirected = redirected;
    }

    @Override
    public int scopeEnd() {
        return this.usingClose && this.closeType == CloseType.CLOSE ? this.closeLine - 1 : super.scopeEnd();
    }

    @Override
    public void resolve(Registers r) {
        this.condexpr = this.cond.asExpression(r);
    }

    @Override
    public void walk(Walker w) {
        w.visitStatement(this);
        this.condexpr.walk(w);
        for (Statement statement : this.statements) {
            statement.walk(w);
        }
    }

    @Override
    public boolean breakable() {
        return false;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public Operation process(Decompiler d) {
        final int test = this.cond.register();
        if (!(this.scopeUsed || this.redirected || test < 0 || this.r.getUpdated(test, this.end - 1) < this.begin || d.getNoDebug())) {
            int line;
            Statement stmt;
            Assignment assign = null;
            if (this.statements.size() == 1 && (stmt = (Statement)this.statements.get(0)) instanceof Assignment && (assign = (Assignment)stmt).getArity() > 1 && (line = assign.getFirstLine()) >= this.begin && line < this.end) {
                assign = null;
            }
            if (assign != null && (this.cond.isRegisterTest() || this.cond.isOrCondition() || assign.isDeclaration()) && assign.getLastTarget().isLocal() && assign.getLastTarget().getIndex() == test || this.statements.isEmpty()) {
                Assignment fassign;
                FinalSetCondition finalset = new FinalSetCondition(this.end - 1, test);
                finalset.type = FinalSetCondition.Type.VALUE;
                Condition combined = this.cond.invertible() ? new OrCondition(this.cond.inverse(), finalset) : new AndCondition(this.cond, finalset);
                if (assign != null) {
                    fassign = assign;
                    fassign.replaceLastValue(combined.asExpression(this.r));
                } else {
                    fassign = null;
                }
                final Condition fcombined = combined;
                return new Operation(this.end - 1){

                    @Override
                    public List<Statement> process(Registers r, Block block) {
                        if (fassign == null) {
                            r.setValue(test, IfThenEndBlock.this.end - 1, fcombined.asExpression(r));
                            return Collections.emptyList();
                        }
                        return Arrays.asList(fassign);
                    }
                };
            }
        }
        return super.process(d);
    }

    @Override
    public void print(Decompiler d, Output out) {
        out.print("if ");
        this.condexpr.print(d, out);
        out.print(" then");
        out.println();
        out.indent();
        Statement.printSequence(d, out, this.statements);
        out.dedent();
        out.print("end");
    }
}

