/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import unluac.decompile.ControlFlowHandler;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.Block;
import unluac.decompile.condition.Condition;
import unluac.decompile.expression.Expression;
import unluac.decompile.operation.Operation;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public class SetBlock
extends Block {
    public final int target;
    private Assignment assign;
    public final Condition cond;
    private Registers r;
    private boolean finalize = false;

    public SetBlock(LFunction function, Condition cond, int target, int line, int begin, int end, Registers r) {
        super(function, begin, end, 2);
        if (begin == end) {
            throw new IllegalStateException();
        }
        this.target = target;
        this.cond = cond;
        this.r = r;
        if (target == -1) {
            throw new IllegalStateException();
        }
    }

    @Override
    public void walk(Walker w) {
        throw new IllegalStateException();
    }

    @Override
    public void addStatement(Statement statement) {
        if (!this.finalize && statement instanceof Assignment) {
            this.assign = (Assignment)statement;
        }
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler d, Output out) {
        if (this.assign == null || this.assign.getFirstTarget() == null) {
            throw new IllegalStateException();
        }
        Assignment assignOut = new Assignment(this.assign.getFirstTarget(), this.getValue(), this.assign.getFirstLine());
        assignOut.print(d, out);
    }

    @Override
    public boolean breakable() {
        return false;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    public void useAssignment(Assignment assign) {
        this.assign = assign;
    }

    public Expression getValue() {
        return this.cond.asExpression(this.r);
    }

    @Override
    public Operation process(Decompiler d) {
        if (ControlFlowHandler.verbose) {
            System.out.print("set expression: ");
            this.cond.asExpression(this.r).print(d, new Output());
            System.out.println();
        }
        if (this.assign != null) {
            this.assign.replaceValue(this.target, this.getValue());
            return new Operation(this.end - 1){

                @Override
                public List<Statement> process(Registers r, Block block) {
                    return Arrays.asList(SetBlock.this.assign);
                }
            };
        }
        return new Operation(this.end - 1){

            @Override
            public List<Statement> process(Registers r, Block block) {
                if (r.isLocal(SetBlock.this.target, SetBlock.this.end - 1)) {
                    return Arrays.asList(new Assignment(r.getTarget(SetBlock.this.target, SetBlock.this.end - 1), SetBlock.this.cond.asExpression(r), SetBlock.this.end - 1));
                }
                r.setValue(SetBlock.this.target, SetBlock.this.end - 1, SetBlock.this.cond.asExpression(r));
                return Collections.emptyList();
            }
        };
    }
}

