/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import java.util.ArrayList;
import java.util.List;
import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.Target;
import unluac.parse.LFunction;

public class TForBlock
extends ContainerBlock {
    protected final int internalRegisterFirst;
    protected final int internalRegisterLast;
    protected final int explicitRegisterFirst;
    protected final int explicitRegisterLast;
    protected final int internalScopeBegin;
    protected final int internalScopeEnd;
    protected final int explicitScopeBegin;
    protected final int explicitScopeEnd;
    protected final int innerScopeEnd;
    private Target[] targets;
    private Expression[] values;

    public static TForBlock make50(LFunction function, int begin, int end, int register, int length, boolean innerClose) {
        int innerScopeEnd = end - 3;
        if (innerClose) {
            --innerScopeEnd;
        }
        return new TForBlock(function, begin, end, register, register + 1, register + 2, register + 1 + length, begin - 1, end - 1, begin - 1, end - 1, innerScopeEnd);
    }

    public static TForBlock make51(LFunction function, int begin, int end, int register, int length, boolean forvarClose, boolean innerClose) {
        int explicitScopeEnd = end - 3;
        int innerScopeEnd = end - 3;
        if (forvarClose) {
            --explicitScopeEnd;
            --innerScopeEnd;
        }
        if (innerClose) {
            --innerScopeEnd;
        }
        return new TForBlock(function, begin, end, register, register + 2, register + 3, register + 2 + length, begin - 2, end - 1, begin - 1, explicitScopeEnd, innerScopeEnd);
    }

    public static TForBlock make54(LFunction function, int begin, int end, int register, int length, boolean forvarClose) {
        int innerScopeEnd = end - 3;
        if (forvarClose) {
            --innerScopeEnd;
        }
        return new TForBlock(function, begin, end, register, register + 3, register + 4, register + 3 + length, begin - 2, end, begin - 1, end - 3, innerScopeEnd);
    }

    public TForBlock(LFunction function, int begin, int end, int internalRegisterFirst, int internalRegisterLast, int explicitRegisterFirst, int explicitRegisterLast, int internalScopeBegin, int internalScopeEnd, int explicitScopeBegin, int explicitScopeEnd, int innerScopeEnd) {
        super(function, begin, end, CloseType.NONE, -1, -1);
        this.internalRegisterFirst = internalRegisterFirst;
        this.internalRegisterLast = internalRegisterLast;
        this.explicitRegisterFirst = explicitRegisterFirst;
        this.explicitRegisterLast = explicitRegisterLast;
        this.internalScopeBegin = internalScopeBegin;
        this.internalScopeEnd = internalScopeEnd;
        this.explicitScopeBegin = explicitScopeBegin;
        this.explicitScopeEnd = explicitScopeEnd;
        this.innerScopeEnd = innerScopeEnd;
    }

    public List<Target> getTargets(Registers r) {
        ArrayList<Target> targets = new ArrayList<Target>(this.explicitRegisterLast - this.explicitRegisterFirst + 1);
        int register = this.explicitRegisterFirst;
        while (register <= this.explicitRegisterLast) {
            targets.add(r.getTarget(register, this.begin - 1));
            ++register;
        }
        return targets;
    }

    public void handleVariableDeclarations(Registers r) {
        int register = this.internalRegisterFirst;
        while (register <= this.internalRegisterLast) {
            r.setInternalLoopVariable(register, this.internalScopeBegin, this.internalScopeEnd);
            ++register;
        }
        register = this.explicitRegisterFirst;
        while (register <= this.explicitRegisterLast) {
            r.setExplicitLoopVariable(register, this.explicitScopeBegin, this.explicitScopeEnd);
            ++register;
        }
    }

    @Override
    public void resolve(Registers r) {
        List<Target> targets = this.getTargets(r);
        ArrayList<Expression> values = new ArrayList<Expression>(3);
        int register = this.internalRegisterFirst;
        while (register <= this.internalRegisterLast) {
            Expression value = r.getValue(register, this.begin - 1);
            values.add(value);
            if (value.isMultiple()) break;
            ++register;
        }
        this.targets = targets.toArray(new Target[targets.size()]);
        this.values = values.toArray(new Expression[values.size()]);
    }

    @Override
    public void walk(Walker w) {
        w.visitStatement(this);
        Expression[] expressionArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            expression.walk(w);
            ++n2;
        }
        for (Statement statement : this.statements) {
            statement.walk(w);
        }
    }

    @Override
    public int scopeEnd() {
        return this.innerScopeEnd;
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public boolean isUnprotected() {
        return false;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler d, Output out) {
        out.print("for ");
        this.targets[0].print(d, out, false);
        int i = 1;
        while (i < this.targets.length) {
            out.print(", ");
            this.targets[i].print(d, out, false);
            ++i;
        }
        out.print(" in ");
        this.values[0].print(d, out);
        i = 1;
        while (i < this.values.length) {
            out.print(", ");
            this.values[i].print(d, out);
            ++i;
        }
        out.print(" do");
        out.println();
        out.indent();
        Statement.printSequence(d, out, this.statements);
        out.dedent();
        out.print("end");
    }
}

