/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.block;

import unluac.decompile.CloseType;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Registers;
import unluac.decompile.Walker;
import unluac.decompile.block.ContainerBlock;
import unluac.decompile.condition.Condition;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.parse.LFunction;

public abstract class WhileBlock
extends ContainerBlock {
    protected Condition cond;
    private Expression condexpr;

    public WhileBlock(LFunction function, Condition cond, int begin, int end, CloseType closeType, int closeLine) {
        super(function, begin, end, closeType, closeLine, -1);
        this.cond = cond;
    }

    @Override
    public void resolve(Registers r) {
        this.condexpr = this.cond.asExpression(r);
    }

    @Override
    public void walk(Walker w) {
        w.visitStatement(this);
        this.condexpr.walk(w);
        for (Statement statement : this.statements) {
            statement.walk(w);
        }
    }

    @Override
    public boolean breakable() {
        return true;
    }

    @Override
    public int getLoopback() {
        throw new IllegalStateException();
    }

    @Override
    public void print(Decompiler d, Output out) {
        out.print("while ");
        this.condexpr.print(d, out);
        out.print(" do");
        out.println();
        out.indent();
        Statement.printSequence(d, out, this.statements);
        out.dedent();
        out.print("end");
    }
}

