/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.condition;

import unluac.decompile.Registers;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.NotCondition;
import unluac.decompile.expression.BinaryExpression;
import unluac.decompile.expression.Expression;

public class BinaryCondition
implements Condition {
    private final Operator op;
    private final int line;
    private final Condition.Operand left;
    private final Condition.Operand right;
    private final boolean inverted;

    private static String operator_to_string(Operator op, boolean inverted, boolean transposed) {
        switch (op) {
            case EQ: {
                return inverted ? "~=" : "==";
            }
            case LT: {
                return transposed ? ">" : "<";
            }
            case LE: {
                return transposed ? ">=" : "<=";
            }
            case GT: {
                return transposed ? "<" : ">";
            }
            case GE: {
                return transposed ? "<=" : ">=";
            }
        }
        throw new IllegalStateException();
    }

    public BinaryCondition(Operator op, int line, Condition.Operand left, Condition.Operand right) {
        this(op, line, left, right, false);
    }

    private BinaryCondition(Operator op, int line, Condition.Operand left, Condition.Operand right, boolean inverted) {
        this.op = op;
        this.line = line;
        this.left = left;
        this.right = right;
        this.inverted = inverted;
    }

    @Override
    public Condition inverse() {
        if (this.op == Operator.EQ) {
            return new BinaryCondition(this.op, this.line, this.left, this.right, !this.inverted);
        }
        return new NotCondition(this);
    }

    @Override
    public boolean invertible() {
        return this.op == Operator.EQ;
    }

    @Override
    public int register() {
        return -1;
    }

    @Override
    public boolean isRegisterTest() {
        return false;
    }

    @Override
    public boolean isOrCondition() {
        return false;
    }

    @Override
    public boolean isSplitable() {
        return false;
    }

    @Override
    public Condition[] split() {
        throw new IllegalStateException();
    }

    @Override
    public Expression asExpression(Registers r) {
        boolean transpose = false;
        Expression leftExpression = this.left.asExpression(r, this.line);
        Expression rightExpression = this.right.asExpression(r, this.line);
        if (this.op != Operator.EQ || this.left.type == Condition.OperandType.K) {
            if (this.left.isRegister(r) && this.right.isRegister(r)) {
                transpose = this.left.getUpdated(r, this.line) > this.right.getUpdated(r, this.line);
            } else {
                int rightIndex = rightExpression.getConstantIndex();
                int leftIndex = leftExpression.getConstantIndex();
                if (rightIndex != -1 && leftIndex != -1) {
                    transpose = this.left.type == Condition.OperandType.K && rightIndex == leftIndex ? true : rightIndex < leftIndex;
                }
            }
        }
        String opstring = BinaryCondition.operator_to_string(this.op, this.inverted, transpose);
        BinaryExpression rtn = new BinaryExpression(opstring, !transpose ? leftExpression : rightExpression, !transpose ? rightExpression : leftExpression, 3, 1);
        return rtn;
    }

    @Override
    public String toString() {
        return this.left + " " + BinaryCondition.operator_to_string(this.op, this.inverted, false) + " " + this.right;
    }

    public static enum Operator {
        EQ,
        LT,
        LE,
        GT,
        GE;

    }
}

