/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.condition;

import unluac.decompile.Registers;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.expression.Expression;

public interface Condition {
    public Condition inverse();

    public boolean invertible();

    public int register();

    public boolean isRegisterTest();

    public boolean isOrCondition();

    public boolean isSplitable();

    public Condition[] split();

    public Expression asExpression(Registers var1);

    public String toString();

    public static class Operand {
        public final OperandType type;
        public final int value;

        public Operand(OperandType type, int value) {
            this.type = type;
            this.value = value;
        }

        public Expression asExpression(Registers r, int line) {
            switch (this.type) {
                case R: {
                    return r.getExpression(this.value, line);
                }
                case RK: {
                    return r.getKExpression(this.value, line);
                }
                case K: {
                    return r.getFunction().getConstantExpression(this.value);
                }
                case I: {
                    return ConstantExpression.createInteger(this.value);
                }
                case F: {
                    return ConstantExpression.createDouble(this.value);
                }
            }
            throw new IllegalStateException();
        }

        public boolean isRegister(Registers r) {
            switch (this.type) {
                case R: {
                    return true;
                }
                case RK: {
                    return !r.isKConstant(this.value);
                }
                case K: {
                    return false;
                }
                case I: {
                    return false;
                }
                case F: {
                    return false;
                }
            }
            throw new IllegalStateException();
        }

        public int getUpdated(Registers r, int line) {
            switch (this.type) {
                case R: {
                    return r.getUpdated(this.value, line);
                }
                case RK: {
                    if (r.isKConstant(this.value)) {
                        throw new IllegalStateException();
                    }
                    return r.getUpdated(this.value, line);
                }
            }
            throw new IllegalStateException();
        }
    }

    public static enum OperandType {
        R,
        RK,
        K,
        I,
        F;

    }
}

