/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.condition;

import unluac.decompile.Registers;
import unluac.decompile.condition.AndCondition;
import unluac.decompile.condition.Condition;
import unluac.decompile.condition.NotCondition;
import unluac.decompile.expression.BinaryExpression;
import unluac.decompile.expression.Expression;

public class OrCondition
implements Condition {
    private Condition left;
    private Condition right;

    public OrCondition(Condition left, Condition right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public Condition inverse() {
        if (this.invertible()) {
            return new AndCondition(this.left.inverse(), this.right.inverse());
        }
        return new NotCondition(this);
    }

    @Override
    public boolean invertible() {
        return this.right.invertible();
    }

    @Override
    public int register() {
        return this.right.register();
    }

    @Override
    public boolean isRegisterTest() {
        return false;
    }

    @Override
    public boolean isOrCondition() {
        return true;
    }

    @Override
    public boolean isSplitable() {
        return false;
    }

    @Override
    public Condition[] split() {
        throw new IllegalStateException();
    }

    @Override
    public Expression asExpression(Registers r) {
        return new BinaryExpression("or", this.left.asExpression(r), this.right.asExpression(r), 1, 0);
    }

    @Override
    public String toString() {
        return "(" + this.left + " or " + this.right + ")";
    }
}

