/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class BinaryExpression
extends Expression {
    private final String op;
    private final Expression left;
    private final Expression right;
    private final int associativity;

    public static BinaryExpression replaceRight(BinaryExpression template, Expression replacement) {
        return new BinaryExpression(template.op, template.left, replacement, template.precedence, template.associativity);
    }

    public BinaryExpression(String op, Expression left, Expression right, int precedence, int associativity) {
        super(precedence);
        this.op = op;
        this.left = left;
        this.right = right;
        this.associativity = associativity;
    }

    @Override
    public void walk(Walker w) {
        w.visitExpression(this);
        this.left.walk(w);
        this.right.walk(w);
    }

    @Override
    public boolean isUngrouped() {
        return !this.beginsWithParen();
    }

    @Override
    public int getConstantIndex() {
        return Math.max(this.left.getConstantIndex(), this.right.getConstantIndex());
    }

    @Override
    public boolean beginsWithParen() {
        return this.leftGroup() || this.left.beginsWithParen();
    }

    @Override
    public void print(Decompiler d, Output out) {
        boolean leftGroup = this.leftGroup();
        boolean rightGroup = this.rightGroup();
        if (leftGroup) {
            out.print("(");
        }
        this.left.print(d, out);
        if (leftGroup) {
            out.print(")");
        }
        out.print(" ");
        out.print(this.op);
        out.print(" ");
        if (rightGroup) {
            out.print("(");
        }
        this.right.print(d, out);
        if (rightGroup) {
            out.print(")");
        }
    }

    public String getOp() {
        return this.op;
    }

    private boolean leftGroup() {
        return this.precedence > this.left.precedence || this.precedence == this.left.precedence && this.associativity == 2;
    }

    private boolean rightGroup() {
        return this.precedence > this.right.precedence || this.precedence == this.right.precedence && this.associativity == 1;
    }
}

