/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.decompile.target.TableTarget;
import unluac.decompile.target.Target;
import unluac.decompile.target.VariableTarget;
import unluac.parse.LFunction;
import unluac.parse.LUpvalue;

public class ClosureExpression
extends Expression {
    private final LFunction function;
    private int upvalueLine;

    public ClosureExpression(LFunction function, int upvalueLine) {
        super(13);
        this.function = function;
        this.upvalueLine = upvalueLine;
    }

    @Override
    public void walk(Walker w) {
        w.visitExpression(this);
    }

    @Override
    public int getConstantIndex() {
        return -1;
    }

    @Override
    public boolean isClosure() {
        return true;
    }

    @Override
    public boolean isUngrouped() {
        return true;
    }

    @Override
    public boolean isUpvalueOf(int register) {
        int i = 0;
        while (i < this.function.upvalues.length) {
            LUpvalue upvalue = this.function.upvalues[i];
            if (upvalue.instack && upvalue.idx == register) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int closureUpvalueLine() {
        return this.upvalueLine;
    }

    @Override
    public void print(Decompiler outer, Output out) {
        Decompiler d = new Decompiler(this.function, outer.declList, this.upvalueLine);
        out.print("function");
        this.printMain(out, d, true);
    }

    @Override
    public void printClosure(Decompiler outer, Output out, Target name) {
        Decompiler d = new Decompiler(this.function, outer.declList, this.upvalueLine);
        out.print("function ");
        if (this.function.numParams >= 1 && d.declList[0].name.equals("self") && name instanceof TableTarget) {
            name.printMethod(outer, out);
            this.printMain(out, d, false);
        } else {
            name.print(outer, out, false);
            this.printMain(out, d, true);
        }
    }

    private void printMain(Output out, Decompiler d, boolean includeFirst) {
        int start;
        out.print("(");
        int n = start = includeFirst ? 0 : 1;
        if (this.function.numParams > start) {
            new VariableTarget(d.declList[start]).print(d, out, false);
            int i = start + 1;
            while (i < this.function.numParams) {
                out.print(", ");
                new VariableTarget(d.declList[i]).print(d, out, false);
                ++i;
            }
        }
        if (this.function.vararg != 0) {
            if (this.function.numParams > start) {
                out.print(", ...");
            } else {
                out.print("...");
            }
        }
        out.print(")");
        out.println();
        out.indent();
        Decompiler.State result = d.decompile();
        d.print(result, out);
        out.dedent();
        out.print("end");
    }
}

