/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Constant;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.parse.LBoolean;
import unluac.parse.LNil;

public class ConstantExpression
extends Expression {
    private final Constant constant;
    private final boolean identifier;
    private final int index;
    private final int line;

    public static ConstantExpression createNil(int line) {
        return new ConstantExpression(new Constant(LNil.NIL), false, -1, line);
    }

    public static ConstantExpression createBoolean(boolean v) {
        return new ConstantExpression(new Constant(v ? LBoolean.LTRUE : LBoolean.LFALSE), false, -1);
    }

    public static ConstantExpression createInteger(int i) {
        return new ConstantExpression(new Constant(i), false, -1);
    }

    public static ConstantExpression createDouble(double x) {
        return new ConstantExpression(new Constant(x), false, -1);
    }

    private static int getPrecedence(Constant constant) {
        if (constant.isNumber() && constant.isNegative()) {
            return 11;
        }
        return 13;
    }

    public ConstantExpression(Constant constant, boolean identifier, int index) {
        this(constant, identifier, index, -1);
    }

    private ConstantExpression(Constant constant, boolean identifier, int index, int line) {
        super(ConstantExpression.getPrecedence(constant));
        this.constant = constant;
        this.identifier = identifier;
        this.index = index;
        this.line = line;
    }

    @Override
    public void walk(Walker w) {
        w.visitExpression(this);
    }

    @Override
    public int getConstantIndex() {
        return this.index;
    }

    @Override
    public int getConstantLine() {
        return this.line;
    }

    @Override
    public void print(Decompiler d, Output out) {
        this.constant.print(d, out, false);
    }

    @Override
    public void printBraced(Decompiler d, Output out) {
        this.constant.print(d, out, true);
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public boolean isUngrouped() {
        return true;
    }

    @Override
    public boolean isNil() {
        return this.constant.isNil();
    }

    @Override
    public boolean isBoolean() {
        return this.constant.isBoolean();
    }

    @Override
    public boolean isInteger() {
        return this.constant.isInteger();
    }

    @Override
    public int asInteger() {
        return this.constant.asInteger();
    }

    @Override
    public boolean isString() {
        return this.constant.isString();
    }

    @Override
    public boolean isIdentifier() {
        return this.identifier;
    }

    @Override
    public String asName() {
        return this.constant.asName();
    }

    @Override
    public boolean isBrief() {
        return !this.constant.isString() || this.constant.asName().length() <= 10;
    }
}

