/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import java.util.List;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.BinaryExpression;
import unluac.decompile.expression.TableLiteral;
import unluac.decompile.expression.UnaryExpression;
import unluac.decompile.target.Target;

public abstract class Expression {
    public static final int PRECEDENCE_OR = 1;
    public static final int PRECEDENCE_AND = 2;
    public static final int PRECEDENCE_COMPARE = 3;
    public static final int PRECEDENCE_BOR = 4;
    public static final int PRECEDENCE_BXOR = 5;
    public static final int PRECEDENCE_BAND = 6;
    public static final int PRECEDENCE_SHIFT = 7;
    public static final int PRECEDENCE_CONCAT = 8;
    public static final int PRECEDENCE_ADD = 9;
    public static final int PRECEDENCE_MUL = 10;
    public static final int PRECEDENCE_UNARY = 11;
    public static final int PRECEDENCE_POW = 12;
    public static final int PRECEDENCE_ATOMIC = 13;
    public static final int ASSOCIATIVITY_NONE = 0;
    public static final int ASSOCIATIVITY_LEFT = 1;
    public static final int ASSOCIATIVITY_RIGHT = 2;
    public final int precedence;

    public static BinaryExpression make(BinaryOperation op, Expression left, Expression right) {
        return Expression.make(op, left, right, false);
    }

    public static BinaryExpression make(BinaryOperation op, Expression left, Expression right, boolean flip) {
        if (flip) {
            Expression swap = left;
            left = right;
            right = swap;
        }
        return new BinaryExpression(op.op, left, right, op.precedence, op.associativity);
    }

    public static UnaryExpression make(UnaryOperation op, Expression expression) {
        return new UnaryExpression(op.op, expression, 11);
    }

    public static void printSequence(Decompiler d, Output out, List<Expression> exprs, boolean linebreak, boolean multiple) {
        int n = exprs.size();
        int i = 1;
        for (Expression expr : exprs) {
            boolean last;
            boolean bl = last = i == n;
            if (expr.isMultiple()) {
                last = true;
            }
            if (last) {
                if (multiple) {
                    expr.printMultiple(d, out);
                    break;
                }
                expr.print(d, out);
                break;
            }
            expr.print(d, out);
            out.print(",");
            if (linebreak) {
                out.println();
            } else {
                out.print(" ");
            }
            ++i;
        }
    }

    public Expression(int precedence) {
        this.precedence = precedence;
    }

    protected static void printUnary(Decompiler d, Output out, String op, Expression expression) {
        out.print(op);
        expression.print(d, out);
    }

    protected static void printBinary(Decompiler d, Output out, String op, Expression left, Expression right) {
        left.print(d, out);
        out.print(" ");
        out.print(op);
        out.print(" ");
        right.print(d, out);
    }

    public abstract void walk(Walker var1);

    public abstract void print(Decompiler var1, Output var2);

    public void printBraced(Decompiler d, Output out) {
        this.print(d, out);
    }

    public void printMultiple(Decompiler d, Output out) {
        this.print(d, out);
    }

    public abstract int getConstantIndex();

    public int getConstantLine() {
        return -1;
    }

    public boolean beginsWithParen() {
        return false;
    }

    public boolean isNil() {
        return false;
    }

    public boolean isClosure() {
        return false;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isUngrouped() {
        return false;
    }

    public boolean isUpvalueOf(int register) {
        throw new IllegalStateException();
    }

    public boolean isBoolean() {
        return false;
    }

    public boolean isInteger() {
        return false;
    }

    public int asInteger() {
        throw new IllegalStateException();
    }

    public boolean isString() {
        return false;
    }

    public boolean isIdentifier() {
        return false;
    }

    public boolean isDotChain() {
        return false;
    }

    public int closureUpvalueLine() {
        throw new IllegalStateException();
    }

    public void printClosure(Decompiler d, Output out, Target name) {
        throw new IllegalStateException();
    }

    public String asName() {
        throw new IllegalStateException();
    }

    public boolean isTableLiteral() {
        return false;
    }

    public boolean isNewEntryAllowed() {
        throw new IllegalStateException();
    }

    public void addEntry(TableLiteral.Entry entry) {
        throw new IllegalStateException();
    }

    public boolean isMultiple() {
        return false;
    }

    public boolean isMemberAccess() {
        return false;
    }

    public Expression getTable() {
        throw new IllegalStateException();
    }

    public String getField() {
        throw new IllegalStateException();
    }

    public boolean isBrief() {
        return false;
    }

    public boolean isEnvironmentTable(Decompiler d) {
        return false;
    }

    public static enum BinaryOperation {
        CONCAT("..", 8, 2),
        ADD("+", 9, 1),
        SUB("-", 9, 1),
        MUL("*", 10, 1),
        DIV("/", 10, 1),
        IDIV("//", 10, 1),
        MOD("%", 10, 1),
        POW("^", 12, 2),
        BAND("&", 6, 1),
        BOR("|", 4, 1),
        BXOR("~", 5, 1),
        SHL("<<", 7, 1),
        SHR(">>", 7, 1),
        OR("or", 1, 0),
        AND("and", 2, 0);

        public final String op;
        public final int precedence;
        public final int associativity;

        private BinaryOperation(String op, int precedence, int associativity) {
            this.op = op;
            this.precedence = precedence;
            this.associativity = associativity;
        }
    }

    public static enum UnaryOperation {
        UNM("-"),
        NOT("not "),
        LEN("#"),
        BNOT("~");

        public final String op;

        private UnaryOperation(String op) {
            this.op = op;
        }
    }
}

