/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import java.util.ArrayList;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class FunctionCall
extends Expression {
    private final Expression function;
    private final Expression[] arguments;
    private final boolean multiple;

    public FunctionCall(Expression function, Expression[] arguments, boolean multiple) {
        super(13);
        this.function = function;
        this.arguments = arguments;
        this.multiple = multiple;
    }

    @Override
    public void walk(Walker w) {
        w.visitExpression(this);
        this.function.walk(w);
        Expression[] expressionArray = this.arguments;
        int n = this.arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            expression.walk(w);
            ++n2;
        }
    }

    @Override
    public int getConstantIndex() {
        int index = this.function.getConstantIndex();
        Expression[] expressionArray = this.arguments;
        int n = this.arguments.length;
        int n2 = 0;
        while (n2 < n) {
            Expression argument = expressionArray[n2];
            index = Math.max(argument.getConstantIndex(), index);
            ++n2;
        }
        return index;
    }

    @Override
    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public void printMultiple(Decompiler d, Output out) {
        if (!this.multiple) {
            out.print("(");
        }
        this.print(d, out);
        if (!this.multiple) {
            out.print(")");
        }
    }

    private boolean isMethodCall() {
        return this.function.isMemberAccess() && this.arguments.length > 0 && this.function.getTable() == this.arguments[0];
    }

    @Override
    public boolean beginsWithParen() {
        if (this.isMethodCall()) {
            Expression obj = this.function.getTable();
            return obj.isUngrouped() || obj.beginsWithParen();
        }
        return this.function.isUngrouped() || this.function.beginsWithParen();
    }

    @Override
    public void print(Decompiler d, Output out) {
        ArrayList<Expression> args = new ArrayList<Expression>(this.arguments.length);
        if (this.isMethodCall()) {
            Expression obj = this.function.getTable();
            if (obj.isUngrouped()) {
                out.print("(");
                obj.print(d, out);
                out.print(")");
            } else {
                obj.print(d, out);
            }
            out.print(":");
            out.print(this.function.getField());
            int i = 1;
            while (i < this.arguments.length) {
                args.add(this.arguments[i]);
                ++i;
            }
        } else {
            if (this.function.isUngrouped()) {
                out.print("(");
                this.function.print(d, out);
                out.print(")");
            } else {
                this.function.print(d, out);
            }
            int i = 0;
            while (i < this.arguments.length) {
                args.add(this.arguments[i]);
                ++i;
            }
        }
        out.print("(");
        Expression.printSequence(d, out, args, false, true);
        out.print(")");
    }
}

