/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import java.util.ArrayList;
import java.util.Collections;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class TableLiteral
extends Expression {
    private ArrayList<Entry> entries;
    private boolean isObject = true;
    private boolean isList = true;
    private int listLength = 1;
    private final int hashSize;
    private int hashCount;

    public TableLiteral(int arraySize, int hashSize) {
        super(13);
        this.entries = new ArrayList(arraySize + hashSize);
        this.hashSize = hashSize;
        this.hashCount = 0;
    }

    @Override
    public void walk(Walker w) {
        Collections.sort(this.entries);
        w.visitExpression(this);
        boolean lastEntry = false;
        for (Entry entry : this.entries) {
            entry.key.walk(w);
            if (lastEntry) continue;
            entry.value.walk(w);
            if (!entry.value.isMultiple()) continue;
            lastEntry = true;
        }
    }

    @Override
    public int getConstantIndex() {
        int index = -1;
        for (Entry entry : this.entries) {
            index = Math.max(entry.key.getConstantIndex(), index);
            index = Math.max(entry.value.getConstantIndex(), index);
        }
        return index;
    }

    @Override
    public void print(Decompiler d, Output out) {
        this.listLength = 1;
        if (this.entries.isEmpty()) {
            out.print("{}");
        } else {
            boolean lineBreak;
            boolean bl = lineBreak = this.isList && this.entries.size() > 5 || this.isObject && this.entries.size() > 2 || !this.isObject;
            if (!lineBreak) {
                for (Entry entry : this.entries) {
                    Expression value = entry.value;
                    if (value.isBrief()) continue;
                    lineBreak = true;
                    break;
                }
            }
            out.print("{");
            if (lineBreak) {
                out.println();
                out.indent();
            }
            this.printEntry(d, 0, out);
            if (!this.entries.get((int)0).value.isMultiple()) {
                int index = 1;
                while (index < this.entries.size()) {
                    out.print(",");
                    if (lineBreak) {
                        out.println();
                    } else {
                        out.print(" ");
                    }
                    this.printEntry(d, index, out);
                    if (this.entries.get((int)index).value.isMultiple()) break;
                    ++index;
                }
            }
            if (lineBreak) {
                out.println();
                out.dedent();
            }
            out.print("}");
        }
    }

    private void printEntry(Decompiler d, int index, Output out) {
        boolean multiple;
        Entry entry = this.entries.get(index);
        Expression key = entry.key;
        Expression value = entry.value;
        boolean isList = entry.isList;
        boolean bl = multiple = index + 1 >= this.entries.size() || value.isMultiple();
        if (isList && key.isInteger() && this.listLength == key.asInteger()) {
            if (multiple) {
                value.printMultiple(d, out);
            } else {
                value.print(d, out);
            }
            ++this.listLength;
        } else if (entry.hash) {
            out.print(key.asName());
            out.print(" = ");
            value.print(d, out);
        } else {
            out.print("[");
            key.printBraced(d, out);
            out.print("] = ");
            value.print(d, out);
        }
    }

    @Override
    public boolean isTableLiteral() {
        return true;
    }

    @Override
    public boolean isUngrouped() {
        return true;
    }

    @Override
    public boolean isNewEntryAllowed() {
        return true;
    }

    @Override
    public void addEntry(Entry entry) {
        if (this.hashCount < this.hashSize && entry.key.isIdentifier()) {
            entry.hash = true;
            ++this.hashCount;
        }
        this.entries.add(entry);
        this.isObject = this.isObject && (entry.isList || entry.key.isIdentifier());
        this.isList = this.isList && entry.isList;
    }

    @Override
    public boolean isBrief() {
        return false;
    }

    public static class Entry
    implements Comparable<Entry> {
        public final Expression key;
        public final Expression value;
        public final boolean isList;
        public final int timestamp;
        private boolean hash;

        public Entry(Expression key, Expression value, boolean isList, int timestamp) {
            this.key = key;
            this.value = value;
            this.isList = isList;
            this.timestamp = timestamp;
        }

        @Override
        public int compareTo(Entry e) {
            return Integer.valueOf(this.timestamp).compareTo(e.timestamp);
        }
    }
}

