/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class TableReference
extends Expression {
    private final Expression table;
    private final Expression index;

    public TableReference(Expression table, Expression index) {
        super(13);
        this.table = table;
        this.index = index;
    }

    @Override
    public void walk(Walker w) {
        w.visitExpression(this);
        this.table.walk(w);
        this.index.walk(w);
    }

    @Override
    public int getConstantIndex() {
        return Math.max(this.table.getConstantIndex(), this.index.getConstantIndex());
    }

    @Override
    public void print(Decompiler d, Output out) {
        boolean isGlobal;
        boolean bl = isGlobal = this.table.isEnvironmentTable(d) && this.index.isIdentifier();
        if (!isGlobal) {
            if (this.table.isUngrouped()) {
                out.print("(");
                this.table.print(d, out);
                out.print(")");
            } else {
                this.table.print(d, out);
            }
        }
        if (this.index.isIdentifier()) {
            if (!isGlobal) {
                out.print(".");
            }
            out.print(this.index.asName());
        } else {
            out.print("[");
            this.index.printBraced(d, out);
            out.print("]");
        }
    }

    @Override
    public boolean isDotChain() {
        return this.index.isIdentifier() && this.table.isDotChain();
    }

    @Override
    public boolean isMemberAccess() {
        return this.index.isIdentifier();
    }

    @Override
    public boolean beginsWithParen() {
        return this.table.isUngrouped() || this.table.beginsWithParen();
    }

    @Override
    public Expression getTable() {
        return this.table;
    }

    @Override
    public String getField() {
        return this.index.asName();
    }
}

