/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.expression;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;

public class UnaryExpression
extends Expression {
    private final String op;
    private final Expression expression;

    public UnaryExpression(String op, Expression expression, int precedence) {
        super(precedence);
        this.op = op;
        this.expression = expression;
    }

    @Override
    public void walk(Walker w) {
        w.visitExpression(this);
        this.expression.walk(w);
    }

    @Override
    public boolean isUngrouped() {
        return true;
    }

    @Override
    public int getConstantIndex() {
        return this.expression.getConstantIndex();
    }

    @Override
    public void print(Decompiler d, Output out) {
        out.print(this.op);
        if (this.precedence > this.expression.precedence) {
            out.print("(");
        }
        this.expression.print(d, out);
        if (this.precedence > this.expression.precedence) {
            out.print(")");
        }
    }
}

