/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.operation;

import java.util.ArrayList;
import java.util.List;
import unluac.decompile.Registers;
import unluac.decompile.block.Block;
import unluac.decompile.expression.ConstantExpression;
import unluac.decompile.operation.Operation;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Statement;

public class LoadNil
extends Operation {
    public final int registerFirst;
    public final int registerLast;

    public LoadNil(int line, int registerFirst, int registerLast) {
        super(line);
        this.registerFirst = registerFirst;
        this.registerLast = registerLast;
    }

    @Override
    public List<Statement> process(Registers r, Block block) {
        ArrayList<Statement> assignments = new ArrayList<Statement>(this.registerLast - this.registerFirst + 1);
        ConstantExpression nil = ConstantExpression.createNil(this.line);
        Assignment declare = null;
        int scopeEnd = -1;
        int register = this.registerFirst;
        while (register <= this.registerLast) {
            if (r.isAssignable(register, this.line)) {
                scopeEnd = r.getDeclaration((int)register, (int)this.line).end;
            }
            ++register;
        }
        register = this.registerFirst;
        while (register <= this.registerLast) {
            r.setValue(register, this.line, nil);
            if (r.isAssignable(register, this.line) && r.getDeclaration((int)register, (int)this.line).end == scopeEnd && register >= block.closeRegister) {
                if (r.getDeclaration((int)register, (int)this.line).begin == this.line) {
                    if (declare == null) {
                        declare = new Assignment();
                        assignments.add(declare);
                    }
                    declare.addLast(r.getTarget(register, this.line), nil, this.line);
                } else {
                    assignments.add(new Assignment(r.getTarget(register, this.line), nil, this.line));
                }
            }
            ++register;
        }
        return assignments;
    }
}

