/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.operation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import unluac.decompile.Registers;
import unluac.decompile.block.Block;
import unluac.decompile.expression.Expression;
import unluac.decompile.expression.TableLiteral;
import unluac.decompile.operation.Operation;
import unluac.decompile.statement.Assignment;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.TableTarget;

public class TableSet
extends Operation {
    private Expression table;
    private Expression index;
    private Expression value;
    private boolean isTable;
    private int timestamp;

    public TableSet(int line, Expression table, Expression index, Expression value, boolean isTable, int timestamp) {
        super(line);
        this.table = table;
        this.index = index;
        this.value = value;
        this.isTable = isTable;
        this.timestamp = timestamp;
    }

    @Override
    public List<Statement> process(Registers r, Block block) {
        if (!r.isNoDebug && this.table.isTableLiteral() && (this.value.isMultiple() || this.table.isNewEntryAllowed())) {
            this.table.addEntry(new TableLiteral.Entry(this.index, this.value, !this.isTable, this.timestamp));
            return Collections.emptyList();
        }
        return Arrays.asList(new Assignment(new TableTarget(this.table, this.index), this.value, this.line));
    }
}

