/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.statement;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import unluac.decompile.Declaration;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;
import unluac.decompile.target.Target;

public class Assignment
extends Statement {
    private final ArrayList<Target> targets = new ArrayList(5);
    private final ArrayList<Expression> values = new ArrayList(5);
    private final ArrayList<Integer> lines = new ArrayList(5);
    private boolean allnil = true;
    private boolean declare = false;
    private int declareStart = 0;

    public Assignment() {
    }

    @Override
    public void walk(Walker w) {
        w.visitStatement(this);
        for (Target target : this.targets) {
            target.walk(w);
        }
        for (Expression expression : this.values) {
            expression.walk(w);
        }
    }

    @Override
    public boolean beginsWithParen() {
        return !this.declare && this.targets.get(0).beginsWithParen();
    }

    public Target getFirstTarget() {
        return this.targets.get(0);
    }

    public Target getLastTarget() {
        return this.targets.get(this.targets.size() - 1);
    }

    public Expression getFirstValue() {
        return this.values.get(0);
    }

    public void replaceLastValue(Expression value) {
        this.values.set(this.values.size() - 1, value);
    }

    public int getFirstLine() {
        return this.lines.get(0);
    }

    public boolean assignsTarget(Declaration decl) {
        for (Target target : this.targets) {
            if (!target.isDeclaration(decl)) continue;
            return true;
        }
        return false;
    }

    public int getArity() {
        return this.targets.size();
    }

    public Assignment(Target target, Expression value, int line) {
        this.targets.add(target);
        this.values.add(value);
        this.lines.add(line);
        this.allnil = this.allnil && value.isNil();
    }

    public void addFirst(Target target, Expression value, int line) {
        this.targets.add(0, target);
        this.values.add(0, value);
        this.lines.add(0, line);
        this.allnil = this.allnil && value.isNil();
    }

    public void addLast(Target target, Expression value, int line) {
        if (this.targets.contains(target)) {
            int index = this.targets.indexOf(target);
            this.targets.remove(index);
            value = this.values.remove(index);
            this.lines.remove(index);
        }
        this.targets.add(target);
        this.values.add(value);
        this.lines.add(line);
        this.allnil = this.allnil && value.isNil();
    }

    public Expression getValue(int target) {
        int index = 0;
        for (Target t : this.targets) {
            if (t.isLocal() && t.getIndex() == target) {
                return this.values.get(index);
            }
            ++index;
        }
        throw new IllegalStateException();
    }

    public void replaceValue(int target, Expression value) {
        int index = 0;
        for (Target t : this.targets) {
            if (t.isLocal() && t.getIndex() == target) {
                this.values.set(index, value);
                return;
            }
            ++index;
        }
        throw new IllegalStateException();
    }

    public boolean assignListEquals(List<Declaration> decls) {
        if (decls.size() != this.targets.size()) {
            return false;
        }
        for (Target target : this.targets) {
            boolean found = false;
            for (Declaration decl : decls) {
                if (!target.isDeclaration(decl)) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public void declare(int declareStart) {
        this.declare = true;
        this.declareStart = declareStart;
    }

    public boolean isDeclaration() {
        return this.declare;
    }

    public boolean assigns(Declaration decl) {
        for (Target target : this.targets) {
            if (!target.isDeclaration(decl)) continue;
            return true;
        }
        return false;
    }

    public boolean canDeclare(List<Declaration> locals) {
        for (Target target : this.targets) {
            boolean isNewLocal = false;
            for (Declaration decl : locals) {
                if (!target.isDeclaration(decl)) continue;
                isNewLocal = true;
                break;
            }
            if (isNewLocal) continue;
            return false;
        }
        return true;
    }

    @Override
    public void print(Decompiler d, Output out) {
        if (!this.targets.isEmpty()) {
            if (this.declare) {
                out.print("local ");
            }
            boolean functionSugar = false;
            if (this.targets.size() == 1 && this.values.size() == 1 && this.values.get(0).isClosure() && this.targets.get(0).isFunctionName()) {
                Expression closure = this.values.get(0);
                if (!this.declare || this.declareStart >= closure.closureUpvalueLine()) {
                    functionSugar = true;
                }
                if (this.targets.get(0).isLocal() && closure.isUpvalueOf(this.targets.get(0).getIndex())) {
                    functionSugar = true;
                }
            }
            if (!functionSugar) {
                this.targets.get(0).print(d, out, this.declare);
                int i = 1;
                while (i < this.targets.size()) {
                    out.print(", ");
                    this.targets.get(i).print(d, out, this.declare);
                    ++i;
                }
                if (!this.declare || !this.allnil) {
                    out.print(" = ");
                    LinkedList<Expression> expressions = new LinkedList<Expression>();
                    int size = this.values.size();
                    if (size >= 2 && this.values.get(size - 1).isNil() && (this.lines.get(size - 1).intValue() == this.values.get(size - 1).getConstantLine() || this.values.get(size - 1).getConstantLine() == -1)) {
                        expressions.addAll(this.values);
                    } else {
                        boolean include = false;
                        int i2 = size - 1;
                        while (i2 >= 0) {
                            Expression value = this.values.get(i2);
                            if (include || !value.isNil() || value.getConstantIndex() != -1) {
                                include = true;
                            }
                            if (include) {
                                expressions.addFirst(value);
                            }
                            --i2;
                        }
                        if (expressions.isEmpty() && !this.declare) {
                            expressions.addAll(this.values);
                        }
                    }
                    Expression.printSequence(d, out, expressions, false, this.targets.size() > expressions.size());
                }
            } else {
                this.values.get(0).printClosure(d, out, this.targets.get(0));
            }
            if (this.comment != null) {
                out.print(" -- ");
                out.print(this.comment);
            }
        }
    }
}

