/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.statement;

import java.util.ArrayList;
import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.decompile.statement.Statement;

public class Return
extends Statement {
    private Expression[] values;

    public Return() {
        this.values = new Expression[0];
    }

    public Return(Expression value) {
        this.values = new Expression[1];
        this.values[0] = value;
    }

    public Return(Expression[] values) {
        this.values = values;
    }

    @Override
    public void walk(Walker w) {
        w.visitStatement(this);
        Expression[] expressionArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Expression expression = expressionArray[n2];
            expression.walk(w);
            ++n2;
        }
    }

    @Override
    public void print(Decompiler d, Output out) {
        out.print("do ");
        this.printTail(d, out);
        out.print(" end");
    }

    @Override
    public void printTail(Decompiler d, Output out) {
        out.print("return");
        if (this.values.length > 0) {
            out.print(" ");
            ArrayList<Expression> rtns = new ArrayList<Expression>(this.values.length);
            Expression[] expressionArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                Expression value = expressionArray[n2];
                rtns.add(value);
                ++n2;
            }
            Expression.printSequence(d, out, rtns, false, true);
        }
    }
}

