/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.statement;

import java.util.List;
import unluac.decompile.Decompiler;
import unluac.decompile.Function;
import unluac.decompile.Output;
import unluac.decompile.Walker;

public abstract class Statement {
    public String comment;

    public static void printSequence(Decompiler d, Output out, List<Statement> stmts) {
        int n = stmts.size();
        int i = 0;
        while (i < n) {
            boolean last = i + 1 == n;
            Statement stmt = stmts.get(i);
            if (stmt.beginsWithParen() && (i > 0 || d.getVersion().allowpreceedingsemicolon.get().booleanValue())) {
                out.print(";");
            }
            if (last) {
                stmt.printTail(d, out);
            } else {
                stmt.print(d, out);
            }
            if (!stmt.suppressNewline()) {
                out.println();
            }
            ++i;
        }
    }

    public abstract void print(Decompiler var1, Output var2);

    public void printTail(Decompiler d, Output out) {
        this.print(d, out);
    }

    public void addComment(String comment) {
        this.comment = comment;
    }

    public abstract void walk(Walker var1);

    public boolean beginsWithParen() {
        return false;
    }

    public boolean suppressNewline() {
        return false;
    }

    public boolean useConstant(Function f, int index) {
        return false;
    }
}

