/*
 * Decompiled with CFR 0.152.
 */
package unluac.decompile.target;

import unluac.decompile.Decompiler;
import unluac.decompile.Output;
import unluac.decompile.Walker;
import unluac.decompile.expression.Expression;
import unluac.decompile.expression.TableReference;
import unluac.decompile.target.Target;

public class TableTarget
extends Target {
    private final Expression table;
    private final Expression index;

    public TableTarget(Expression table, Expression index) {
        this.table = table;
        this.index = index;
    }

    @Override
    public void walk(Walker w) {
        this.table.walk(w);
        this.index.walk(w);
    }

    @Override
    public void print(Decompiler d, Output out, boolean declare) {
        new TableReference(this.table, this.index).print(d, out);
    }

    @Override
    public void printMethod(Decompiler d, Output out) {
        this.table.print(d, out);
        out.print(":");
        out.print(this.index.asName());
    }

    @Override
    public boolean isFunctionName() {
        if (!this.index.isIdentifier()) {
            return false;
        }
        return this.table.isDotChain();
    }

    @Override
    public boolean beginsWithParen() {
        return this.table.isUngrouped() || this.table.beginsWithParen();
    }
}

