/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import unluac.Configuration;
import unluac.Version;
import unluac.assemble.Tokenizer;
import unluac.decompile.CodeExtract;
import unluac.decompile.Op;
import unluac.decompile.OpcodeMap;
import unluac.parse.BIntegerType;
import unluac.parse.LAbsLineInfoType;
import unluac.parse.LBooleanType;
import unluac.parse.LConstantType;
import unluac.parse.LFunction;
import unluac.parse.LFunctionType;
import unluac.parse.LHeader;
import unluac.parse.LHeaderType;
import unluac.parse.LLocalType;
import unluac.parse.LNumberType;
import unluac.parse.LStringType;
import unluac.parse.LUpvalueType;

public class BHeader {
    private static final byte[] signature = new byte[]{27, 76, 117, 97};
    public final boolean debug = false;
    public final Configuration config;
    public final Version version;
    public final LHeader lheader;
    public final LHeaderType lheader_type;
    public final BIntegerType integer;
    public final BIntegerType sizeT;
    public final LBooleanType bool;
    public final LNumberType number;
    public final LNumberType linteger;
    public final LNumberType lfloat;
    public final LStringType string;
    public final LConstantType constant;
    public final LAbsLineInfoType abslineinfo;
    public final LLocalType local;
    public final LUpvalueType upvalue;
    public final LFunctionType function;
    public final CodeExtract extractor;
    public final OpcodeMap opmap;
    public final LFunction main;

    public BHeader(Version version, LHeader lheader) {
        this(version, lheader, null);
    }

    public BHeader(Version version, LHeader lheader, LFunction main) {
        this.config = null;
        this.version = version;
        this.lheader = lheader;
        this.lheader_type = version.getLHeaderType();
        this.integer = lheader.integer;
        this.sizeT = lheader.sizeT;
        this.bool = lheader.bool;
        this.number = lheader.number;
        this.linteger = lheader.linteger;
        this.lfloat = lheader.lfloat;
        this.string = lheader.string;
        this.constant = lheader.constant;
        this.abslineinfo = lheader.abslineinfo;
        this.local = lheader.local;
        this.upvalue = lheader.upvalue;
        this.function = lheader.function;
        this.extractor = lheader.extractor;
        this.opmap = version.getOpcodeMap();
        this.main = main;
    }

    public BHeader(ByteBuffer buffer, Configuration config) {
        this.config = config;
        int i = 0;
        while (i < signature.length) {
            if (buffer.get() != signature[i]) {
                throw new IllegalStateException("The input file does not have the signature of a valid Lua file.");
            }
            ++i;
        }
        int versionNumber = 0xFF & buffer.get();
        int major = versionNumber >> 4;
        int minor = versionNumber & 0xF;
        this.version = Version.getVersion(major, minor);
        if (this.version == null) {
            throw new IllegalStateException("The input chunk's Lua version is " + major + "." + minor + "; unluac can only handle Lua 5.0 - Lua 5.4.");
        }
        this.lheader_type = this.version.getLHeaderType();
        this.lheader = this.lheader_type.parse(buffer, this);
        this.integer = this.lheader.integer;
        this.sizeT = this.lheader.sizeT;
        this.bool = this.lheader.bool;
        this.number = this.lheader.number;
        this.linteger = this.lheader.linteger;
        this.lfloat = this.lheader.lfloat;
        this.string = this.lheader.string;
        this.constant = this.lheader.constant;
        this.abslineinfo = this.lheader.abslineinfo;
        this.local = this.lheader.local;
        this.upvalue = this.lheader.upvalue;
        this.function = this.lheader.function;
        this.extractor = this.lheader.extractor;
        if (config.opmap != null) {
            try {
                String tok;
                Tokenizer t = new Tokenizer(new FileInputStream(new File(config.opmap)));
                HashMap<Integer, Op> useropmap = new HashMap<Integer, Op>();
                while ((tok = t.next()) != null) {
                    if (tok.equals(".op")) {
                        int opcode;
                        tok = t.next();
                        if (tok == null) {
                            throw new IllegalStateException("Unexpected end of opmap file.");
                        }
                        try {
                            opcode = Integer.parseInt(tok);
                        }
                        catch (NumberFormatException e) {
                            throw new IllegalStateException("Excepted number in opmap file, got \"" + tok + "\".");
                        }
                        tok = t.next();
                        if (tok == null) {
                            throw new IllegalStateException("Unexpected end of opmap file.");
                        }
                        Op op = this.version.getOpcodeMap().get(tok);
                        if (op == null) {
                            throw new IllegalStateException("Unknown op name \"" + tok + "\" in opmap file.");
                        }
                        useropmap.put(opcode, op);
                        continue;
                    }
                    throw new IllegalStateException("Unexpected token \"" + tok + "\" + in opmap file.");
                }
                this.opmap = new OpcodeMap(useropmap);
            }
            catch (IOException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }
        this.opmap = this.version.getOpcodeMap();
        int upvalues = -1;
        if (versionNumber >= 83) {
            upvalues = 0xFF & buffer.get();
        }
        this.main = this.function.parse(buffer, this);
        if (upvalues >= 0 && this.main.numUpvalues != upvalues) {
            throw new IllegalStateException("The main chunk has the wrong number of upvalues: " + this.main.numUpvalues + " (" + upvalues + " expected)");
        }
        if (this.main.numUpvalues >= 1 && versionNumber >= 82 && (this.main.upvalues[0].name == null || this.main.upvalues[0].name.isEmpty())) {
            this.main.upvalues[0].name = "_ENV";
        }
        this.main.setLevel(1);
    }

    public void write(OutputStream out) throws IOException {
        out.write(signature);
        int major = this.version.getVersionMajor();
        int minor = this.version.getVersionMinor();
        int versionNumber = major << 4 | minor;
        out.write(versionNumber);
        this.version.getLHeaderType().write(out, this, this.lheader);
        if (this.version.useupvaluecountinheader.get().booleanValue()) {
            out.write(this.main.numUpvalues);
        }
        this.function.write(out, this, this.main);
    }
}

