/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BIntegerType;
import unluac.parse.LHeader;

class BIntegerType50
extends BIntegerType {
    public final int intSize;

    public BIntegerType50(int intSize) {
        this.intSize = intSize;
    }

    protected BInteger raw_parse(ByteBuffer buffer, BHeader header) {
        BInteger value;
        switch (this.intSize) {
            case 0: {
                value = new BInteger(0);
                break;
            }
            case 1: {
                value = new BInteger(buffer.get());
                break;
            }
            case 2: {
                value = new BInteger(buffer.getShort());
                break;
            }
            case 4: {
                value = new BInteger(buffer.getInt());
                break;
            }
            default: {
                byte[] bytes = new byte[this.intSize];
                int start = 0;
                int delta = 1;
                if (buffer.order() == ByteOrder.LITTLE_ENDIAN) {
                    start = this.intSize - 1;
                    delta = -1;
                }
                int i = start;
                while (i >= 0 && i < this.intSize) {
                    bytes[i] = buffer.get();
                    i += delta;
                }
                value = new BInteger(new BigInteger(bytes));
            }
        }
        return value;
    }

    protected void raw_write(OutputStream out, BHeader header, BInteger object) throws IOException {
        byte[] bytes = object.littleEndianBytes(this.intSize);
        if (header.lheader.endianness == LHeader.LEndianness.LITTLE) {
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                out.write(b);
                ++n2;
            }
        } else {
            int i = bytes.length - 1;
            while (i >= 0) {
                out.write(bytes[i]);
                --i;
            }
        }
    }

    @Override
    public BInteger parse(ByteBuffer buffer, BHeader header) {
        BInteger value = this.raw_parse(buffer, header);
        header.getClass();
        return value;
    }

    @Override
    public void write(OutputStream out, BHeader header, BInteger object) throws IOException {
        this.raw_write(out, header, object);
    }

    @Override
    public int getSize() {
        return this.intSize;
    }
}

