/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import unluac.parse.BHeader;
import unluac.parse.BInteger;
import unluac.parse.BIntegerType;

class BIntegerType54
extends BIntegerType {
    @Override
    public BInteger parse(ByteBuffer buffer, BHeader header) {
        byte b;
        long x = 0L;
        do {
            b = buffer.get();
            x = x << 7 | (long)(b & 0x7F);
        } while ((b & 0x80) == 0);
        if (Integer.MIN_VALUE <= x && x <= Integer.MAX_VALUE) {
            return new BInteger((int)x);
        }
        return new BInteger(BigInteger.valueOf(x));
    }

    @Override
    public void write(OutputStream out, BHeader header, BInteger object) throws IOException {
        byte[] bytes = object.compressedBytes();
        int i = bytes.length - 1;
        while (i >= 1) {
            out.write(bytes[i]);
            --i;
        }
        out.write(bytes[0] | 0x80);
    }
}

