/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import unluac.parse.BHeader;
import unluac.parse.BObjectType;
import unluac.parse.LBoolean;

public class LBooleanType
extends BObjectType<LBoolean> {
    @Override
    public LBoolean parse(ByteBuffer buffer, BHeader header) {
        byte value = buffer.get();
        if ((value & 0xFFFFFFFE) != 0) {
            throw new IllegalStateException();
        }
        LBoolean bool = value == 0 ? LBoolean.LFALSE : LBoolean.LTRUE;
        header.getClass();
        return bool;
    }

    @Override
    public void write(OutputStream out, BHeader header, LBoolean object) throws IOException {
        int value = object.value() ? 1 : 0;
        out.write(value);
    }
}

