/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import unluac.parse.BHeader;
import unluac.parse.LBoolean;
import unluac.parse.LConstantType;
import unluac.parse.LNil;
import unluac.parse.LNumber;
import unluac.parse.LObject;
import unluac.parse.LString;

class LConstantType50
extends LConstantType {
    LConstantType50() {
    }

    @Override
    public LObject parse(ByteBuffer buffer, BHeader header) {
        int type = 0xFF & buffer.get();
        header.getClass();
        switch (type) {
            case 0: {
                return LNil.NIL;
            }
            case 1: {
                return header.bool.parse(buffer, header);
            }
            case 3: {
                return header.number.parse(buffer, header);
            }
            case 4: {
                return (LObject)header.string.parse(buffer, header);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void write(OutputStream out, BHeader header, LObject object) throws IOException {
        if (object instanceof LNil) {
            out.write(0);
        } else if (object instanceof LBoolean) {
            out.write(1);
            header.bool.write(out, header, (LBoolean)object);
        } else if (object instanceof LNumber) {
            out.write(3);
            header.number.write(out, header, (LNumber)object);
        } else if (object instanceof LString) {
            out.write(4);
            header.string.write(out, header, (LString)object);
        } else {
            throw new IllegalStateException();
        }
    }
}

