/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import unluac.parse.BHeader;
import unluac.parse.LBoolean;
import unluac.parse.LConstantType;
import unluac.parse.LNil;
import unluac.parse.LNumber;
import unluac.parse.LObject;
import unluac.parse.LString;

class LConstantType54
extends LConstantType {
    LConstantType54() {
    }

    @Override
    public LObject parse(ByteBuffer buffer, BHeader header) {
        int type = 0xFF & buffer.get();
        switch (type) {
            case 0: {
                return LNil.NIL;
            }
            case 1: {
                return LBoolean.LFALSE;
            }
            case 17: {
                return LBoolean.LTRUE;
            }
            case 3: {
                return header.linteger.parse(buffer, header);
            }
            case 19: {
                return header.lfloat.parse(buffer, header);
            }
            case 5: {
                return (LObject)header.string.parse(buffer, header);
            }
            case 21: {
                LString s = (LString)header.string.parse(buffer, header);
                s.islong = true;
                return s;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public void write(OutputStream out, BHeader header, LObject object) throws IOException {
        if (object instanceof LNil) {
            out.write(0);
        } else if (object instanceof LBoolean) {
            if (((LBoolean)object).value()) {
                out.write(17);
            } else {
                out.write(1);
            }
        } else if (object instanceof LNumber) {
            LNumber n = (LNumber)object;
            if (!n.integralType()) {
                out.write(19);
                header.lfloat.write(out, header, (LNumber)object);
            } else {
                out.write(3);
                header.linteger.write(out, header, (LNumber)object);
            }
        } else if (object instanceof LString) {
            LString s = (LString)object;
            out.write(s.islong ? 21 : 5);
            header.string.write(out, header, s);
        } else {
            throw new IllegalStateException();
        }
    }
}

