/*
 * Decompiled with CFR 0.152.
 */
package unluac.parse;

import unluac.parse.LNumber;
import unluac.parse.LNumberType;

class LDoubleNumber
extends LNumber {
    public final double number;
    public final LNumberType.NumberMode mode;

    public LDoubleNumber(double number, LNumberType.NumberMode mode) {
        this.number = number;
        this.mode = mode;
    }

    @Override
    public String toPrintString() {
        if (this.mode == LNumberType.NumberMode.MODE_NUMBER && this.number == (double)Math.round(this.number)) {
            if (Double.doubleToRawLongBits(this.number) == Double.doubleToRawLongBits(-0.0)) {
                return "-0";
            }
            return Long.toString((long)this.number);
        }
        return Double.toString(this.number);
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof LDoubleNumber) {
            return Double.doubleToRawLongBits(this.number) == Double.doubleToRawLongBits(((LDoubleNumber)o).number);
        }
        if (o instanceof LNumber) {
            return this.value() == ((LNumber)o).value();
        }
        return false;
    }

    @Override
    public double value() {
        return this.number;
    }

    @Override
    public boolean integralType() {
        return false;
    }

    @Override
    public long bits() {
        return Double.doubleToRawLongBits(this.number);
    }
}

